/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.linkfs.LinkFileSystem;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackDetector;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import org.slf4j.Logger;

public class FolderRepositorySource
implements RepositorySource {
    static final Logger f_244616_ = LogUtils.getLogger();
    private final Path f_10382_;
    private final PackType f_243749_;
    private final PackSource f_10383_;
    private final DirectoryValidator f_290579_;

    public FolderRepositorySource(Path p_251796_, PackType p_251664_, PackSource p_250854_, DirectoryValidator p_300828_) {
        this.f_10382_ = p_251796_;
        this.f_243749_ = p_251664_;
        this.f_10383_ = p_250854_;
        this.f_290579_ = p_300828_;
    }

    private static String m_246927_(Path p_248745_) {
        return p_248745_.getFileName().toString();
    }

    @Override
    public void m_7686_(Consumer<Pack> p_250965_) {
        try {
            FileUtil.m_257659_(this.f_10382_);
            FolderRepositorySource.m_247293_(this.f_10382_, this.f_290579_, false, (p_248243_, p_248244_) -> {
                String $$3 = FolderRepositorySource.m_246927_(p_248243_);
                Pack $$4 = Pack.m_245429_("file/" + $$3, Component.m_237113_($$3), false, p_248244_, this.f_243749_, Pack.Position.TOP, this.f_10383_);
                if ($$4 != null) {
                    p_250965_.accept($$4);
                }
            });
        }
        catch (IOException $$1) {
            f_244616_.warn("Failed to list packs in {}", (Object)this.f_10382_, (Object)$$1);
        }
    }

    public static void m_247293_(Path p_248794_, DirectoryValidator p_299329_, boolean p_255987_, BiConsumer<Path, Pack.ResourcesSupplier> p_248580_) throws IOException {
        FolderPackDetector $$4 = new FolderPackDetector(p_299329_, p_255987_);
        try (DirectoryStream<Path> $$5 = Files.newDirectoryStream(p_248794_);){
            for (Path $$6 : $$5) {
                try {
                    ArrayList<ForbiddenSymlinkInfo> $$7 = new ArrayList<ForbiddenSymlinkInfo>();
                    Pack.ResourcesSupplier $$8 = (Pack.ResourcesSupplier)$$4.m_293433_($$6, $$7);
                    if (!$$7.isEmpty()) {
                        f_244616_.warn("Ignoring potential pack entry: {}", (Object)ContentValidationException.m_289907_($$6, $$7));
                        continue;
                    }
                    if ($$8 != null) {
                        p_248580_.accept($$6, $$8);
                        continue;
                    }
                    f_244616_.info("Found non-pack entry '{}', ignoring", (Object)$$6);
                }
                catch (IOException $$9) {
                    f_244616_.warn("Failed to read properties of '{}', ignoring", (Object)$$6, (Object)$$9);
                }
            }
        }
    }

    static class FolderPackDetector
    extends PackDetector<Pack.ResourcesSupplier> {
        private final boolean f_291528_;

        protected FolderPackDetector(DirectoryValidator p_301187_, boolean p_300568_) {
            super(p_301187_);
            this.f_291528_ = p_300568_;
        }

        @Override
        @Nullable
        protected Pack.ResourcesSupplier m_292901_(Path p_299114_) {
            FileSystem $$1 = p_299114_.getFileSystem();
            if ($$1 == FileSystems.getDefault() || $$1 instanceof LinkFileSystem) {
                return new FilePackResources.FileResourcesSupplier(p_299114_, this.f_291528_);
            }
            f_244616_.info("Can't open pack archive at {}", (Object)p_299114_);
            return null;
        }

        @Override
        protected Pack.ResourcesSupplier m_293354_(Path p_300765_) {
            return new PathPackResources.PathResourcesSupplier(p_300765_, this.f_291528_);
        }

        @Override
        protected /* synthetic */ Object m_293354_(Path path) throws IOException {
            return this.m_293354_(path);
        }

        @Override
        @Nullable
        protected /* synthetic */ Object m_292901_(Path path) throws IOException {
            return this.m_292901_(path);
        }
    }
}

