/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.CompositePackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.IoSupplier;
import org.slf4j.Logger;

public class PathPackResources
extends AbstractPackResources {
    private static final Logger f_244043_ = LogUtils.getLogger();
    private static final Joiner f_244478_ = Joiner.on((String)"/");
    private final Path f_243919_;

    public PathPackResources(String p_255754_, Path p_256025_, boolean p_256260_) {
        super(p_255754_, p_256260_);
        this.f_243919_ = p_256025_;
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... p_249041_) {
        FileUtil.m_245411_(p_249041_);
        Path $$1 = FileUtil.m_245247_(this.f_243919_, List.of(p_249041_));
        if (Files.exists($$1, new LinkOption[0])) {
            return IoSupplier.m_246697_($$1);
        }
        return null;
    }

    public static boolean m_246877_(Path p_249579_) {
        return true;
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType p_249352_, ResourceLocation p_251715_) {
        Path $$2 = this.f_243919_.resolve(p_249352_.m_10305_()).resolve(p_251715_.m_135827_());
        return PathPackResources.m_247113_(p_251715_, $$2);
    }

    public static IoSupplier<InputStream> m_247113_(ResourceLocation p_250145_, Path p_251046_) {
        return (IoSupplier)FileUtil.m_245538_(p_250145_.m_135815_()).get().map(p_251647_ -> {
            Path $$2 = FileUtil.m_245247_(p_251046_, p_251647_);
            return PathPackResources.m_246992_($$2);
        }, p_248714_ -> {
            f_244043_.error("Invalid path {}: {}", (Object)p_250145_, (Object)p_248714_.message());
            return null;
        });
    }

    @Nullable
    private static IoSupplier<InputStream> m_246992_(Path p_250506_) {
        if (Files.exists(p_250506_, new LinkOption[0]) && PathPackResources.m_246877_(p_250506_)) {
            return IoSupplier.m_246697_(p_250506_);
        }
        return null;
    }

    @Override
    public void m_8031_(PackType p_251452_, String p_249854_, String p_248650_, PackResources.ResourceOutput p_248572_) {
        FileUtil.m_245538_(p_248650_).get().ifLeft(p_250225_ -> {
            Path $$4 = this.f_243919_.resolve(p_251452_.m_10305_()).resolve(p_249854_);
            PathPackResources.m_246914_(p_249854_, $$4, p_250225_, p_248572_);
        }).ifRight(p_252338_ -> f_244043_.error("Invalid path {}: {}", (Object)p_248650_, (Object)p_252338_.message()));
    }

    public static void m_246914_(String p_249455_, Path p_249514_, List<String> p_251918_, PackResources.ResourceOutput p_249964_) {
        Path $$4 = FileUtil.m_245247_(p_249514_, p_251918_);
        try (Stream<Path> $$52 = Files.find($$4, Integer.MAX_VALUE, (p_250060_, p_250796_) -> p_250796_.isRegularFile(), new FileVisitOption[0]);){
            $$52.forEach(p_249092_ -> {
                String $$4 = f_244478_.join((Iterable)p_249514_.relativize((Path)p_249092_));
                ResourceLocation $$5 = ResourceLocation.m_214293_(p_249455_, $$4);
                if ($$5 == null) {
                    Util.m_143785_(String.format(Locale.ROOT, "Invalid path in pack: %s:%s, ignoring", p_249455_, $$4));
                } else {
                    p_249964_.accept($$5, IoSupplier.m_246697_(p_249092_));
                }
            });
        }
        catch (NoSuchFileException | NotDirectoryException $$52) {
        }
        catch (IOException $$6) {
            f_244043_.error("Failed to list path {}", (Object)$$4, (Object)$$6);
        }
    }

    @Override
    public Set<String> m_5698_(PackType p_251896_) {
        HashSet $$1 = Sets.newHashSet();
        Path $$2 = this.f_243919_.resolve(p_251896_.m_10305_());
        try (DirectoryStream<Path> $$32 = Files.newDirectoryStream($$2);){
            for (Path $$4 : $$32) {
                String $$5 = $$4.getFileName().toString();
                if (ResourceLocation.m_135843_($$5)) {
                    $$1.add($$5);
                    continue;
                }
                f_244043_.warn("Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring", (Object)$$5, (Object)this.f_243919_);
            }
        }
        catch (NoSuchFileException | NotDirectoryException $$32) {
        }
        catch (IOException $$6) {
            f_244043_.error("Failed to list path {}", (Object)$$2, (Object)$$6);
        }
        return $$1;
    }

    @Override
    public void close() {
    }

    public static class PathResourcesSupplier
    implements Pack.ResourcesSupplier {
        private final Path f_290684_;
        private final boolean f_290837_;

        public PathResourcesSupplier(Path p_298516_, boolean p_298378_) {
            this.f_290684_ = p_298516_;
            this.f_290837_ = p_298378_;
        }

        @Override
        public PackResources m_293078_(String p_298945_) {
            return new PathPackResources(p_298945_, this.f_290684_, this.f_290837_);
        }

        @Override
        public PackResources m_247679_(String p_299991_, Pack.Info p_300582_) {
            PackResources $$2 = this.m_293078_(p_299991_);
            List<String> $$3 = p_300582_.f_291122_();
            if ($$3.isEmpty()) {
                return $$2;
            }
            ArrayList<PackResources> $$4 = new ArrayList<PackResources>($$3.size());
            for (String $$5 : $$3) {
                Path $$6 = this.f_290684_.resolve($$5);
                $$4.add(new PathPackResources(p_299991_, $$6, this.f_290837_));
            }
            return new CompositePackResources($$2, $$4);
        }
    }
}

