/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerFunctionManager;

public class CommandFunction {
    private final Entry[] f_77976_;
    final ResourceLocation f_77977_;

    public CommandFunction(ResourceLocation p_77979_, Entry[] p_77980_) {
        this.f_77977_ = p_77979_;
        this.f_77976_ = p_77980_;
    }

    public ResourceLocation m_77981_() {
        return this.f_77977_;
    }

    public Entry[] m_77989_() {
        return this.f_77976_;
    }

    public CommandFunction m_295804_(@Nullable CompoundTag p_300636_, CommandDispatcher<CommandSourceStack> p_300698_, CommandSourceStack p_298553_) throws FunctionInstantiationException {
        return this;
    }

    private static boolean m_292799_(CharSequence p_298962_) {
        int $$1 = p_298962_.length();
        return $$1 > 0 && p_298962_.charAt($$1 - 1) == '\\';
    }

    public static CommandFunction m_77984_(ResourceLocation p_77985_, CommandDispatcher<CommandSourceStack> p_77986_, CommandSourceStack p_77987_, List<String> p_77988_) {
        ArrayList<Entry> $$4 = new ArrayList<Entry>(p_77988_.size());
        ObjectArraySet $$5 = new ObjectArraySet();
        for (int $$6 = 0; $$6 < p_77988_.size(); ++$$6) {
            String $$12;
            int $$7 = $$6 + 1;
            String $$8 = p_77988_.get($$6).trim();
            if (CommandFunction.m_292799_($$8)) {
                StringBuilder $$9 = new StringBuilder($$8);
                do {
                    if (++$$6 == p_77988_.size()) {
                        throw new IllegalArgumentException("Line continuation at end of file");
                    }
                    $$9.deleteCharAt($$9.length() - 1);
                    String $$10 = p_77988_.get($$6).trim();
                    $$9.append($$10);
                } while (CommandFunction.m_292799_($$9));
                String $$11 = $$9.toString();
            } else {
                $$12 = $$8;
            }
            StringReader $$13 = new StringReader($$12);
            if (!$$13.canRead() || $$13.peek() == '#') continue;
            if ($$13.peek() == '/') {
                $$13.skip();
                if ($$13.peek() == '/') {
                    throw new IllegalArgumentException("Unknown or invalid command '" + $$12 + "' on line " + $$7 + " (if you intended to make a comment, use '#' not '//')");
                }
                String $$14 = $$13.readUnquotedString();
                throw new IllegalArgumentException("Unknown or invalid command '" + $$12 + "' on line " + $$7 + " (did you mean '" + $$14 + "'? Do not use a preceding forwards slash.)");
            }
            if ($$13.peek() == '$') {
                MacroEntry $$15 = CommandFunction.m_295539_($$12.substring(1), $$7);
                $$4.add($$15);
                $$5.addAll($$15.m_294914_());
                continue;
            }
            try {
                ParseResults $$16 = p_77986_.parse($$13, (Object)p_77987_);
                if ($$16.getReader().canRead()) {
                    throw Commands.m_82097_($$16);
                }
                $$4.add(new CommandEntry((ParseResults<CommandSourceStack>)$$16));
                continue;
            }
            catch (CommandSyntaxException $$17) {
                throw new IllegalArgumentException("Whilst parsing command on line " + $$7 + ": " + $$17.getMessage());
            }
        }
        if ($$5.isEmpty()) {
            return new CommandFunction(p_77985_, (Entry[])$$4.toArray(Entry[]::new));
        }
        return new CommandMacro(p_77985_, (Entry[])$$4.toArray(Entry[]::new), List.copyOf($$5));
    }

    @VisibleForTesting
    public static MacroEntry m_295539_(String p_301200_, int p_300045_) {
        ImmutableList.Builder $$2 = ImmutableList.builder();
        ImmutableList.Builder $$3 = ImmutableList.builder();
        int $$4 = p_301200_.length();
        int $$5 = 0;
        int $$6 = p_301200_.indexOf(36);
        while ($$6 != -1) {
            if ($$6 == $$4 - 1 || p_301200_.charAt($$6 + 1) != '(') {
                $$6 = p_301200_.indexOf(36, $$6 + 1);
                continue;
            }
            $$2.add((Object)p_301200_.substring($$5, $$6));
            int $$7 = p_301200_.indexOf(41, $$6 + 1);
            if ($$7 == -1) {
                throw new IllegalArgumentException("Unterminated macro variable in macro '" + p_301200_ + "' on line " + p_300045_);
            }
            String $$8 = p_301200_.substring($$6 + 2, $$7);
            if (!CommandFunction.m_295505_($$8)) {
                throw new IllegalArgumentException("Invalid macro variable name '" + $$8 + "' on line " + p_300045_);
            }
            $$3.add((Object)$$8);
            $$5 = $$7 + 1;
            $$6 = p_301200_.indexOf(36, $$5);
        }
        if ($$5 == 0) {
            throw new IllegalArgumentException("Macro without variables on line " + p_300045_);
        }
        if ($$5 != $$4) {
            $$2.add((Object)p_301200_.substring($$5));
        }
        return new MacroEntry((List<String>)$$2.build(), (List<String>)$$3.build());
    }

    private static boolean m_295505_(String p_299170_) {
        for (int $$1 = 0; $$1 < p_299170_.length(); ++$$1) {
            char $$2 = p_299170_.charAt($$1);
            if (Character.isLetterOrDigit($$2) || $$2 == '_') continue;
            return false;
        }
        return true;
    }

    @FunctionalInterface
    public static interface Entry {
        public void m_142134_(ServerFunctionManager var1, CommandSourceStack var2, Deque<ServerFunctionManager.QueuedCommand> var3, int var4, int var5, @Nullable ServerFunctionManager.TraceCallbacks var6) throws CommandSyntaxException;
    }

    public static class MacroEntry
    implements Entry {
        private final List<String> f_291090_;
        private final List<String> f_290994_;

        public MacroEntry(List<String> p_299524_, List<String> p_299522_) {
            this.f_291090_ = p_299524_;
            this.f_290994_ = p_299522_;
        }

        public List<String> m_294914_() {
            return this.f_290994_;
        }

        public String m_293396_(List<String> p_300217_) {
            StringBuilder $$1 = new StringBuilder();
            for (int $$2 = 0; $$2 < this.f_290994_.size(); ++$$2) {
                $$1.append(this.f_291090_.get($$2)).append(p_300217_.get($$2));
            }
            if (this.f_291090_.size() > this.f_290994_.size()) {
                $$1.append(this.f_291090_.get(this.f_291090_.size() - 1));
            }
            return $$1.toString();
        }

        @Override
        public void m_142134_(ServerFunctionManager p_299564_, CommandSourceStack p_298428_, Deque<ServerFunctionManager.QueuedCommand> p_299632_, int p_298690_, int p_299006_, @Nullable ServerFunctionManager.TraceCallbacks p_297793_) throws CommandSyntaxException {
            throw new IllegalStateException("Tried to execute an uninstantiated macro");
        }
    }

    public static class CommandEntry
    implements Entry {
        private final ParseResults<CommandSourceStack> f_78004_;

        public CommandEntry(ParseResults<CommandSourceStack> p_78006_) {
            this.f_78004_ = p_78006_;
        }

        @Override
        public void m_142134_(ServerFunctionManager p_164879_, CommandSourceStack p_164880_, Deque<ServerFunctionManager.QueuedCommand> p_164881_, int p_164882_, int p_164883_, @Nullable ServerFunctionManager.TraceCallbacks p_164884_) throws CommandSyntaxException {
            if (p_164884_ != null) {
                String $$6 = this.f_78004_.getReader().getString();
                p_164884_.m_142256_(p_164883_, $$6);
                int $$7 = this.m_164875_(p_164879_, p_164880_);
                p_164884_.m_142279_(p_164883_, $$6, $$7);
            } else {
                this.m_164875_(p_164879_, p_164880_);
            }
        }

        private int m_164875_(ServerFunctionManager p_164876_, CommandSourceStack p_164877_) throws CommandSyntaxException {
            return p_164876_.m_136127_().execute(Commands.m_242611_(this.f_78004_, p_242934_ -> p_164877_));
        }

        public String toString() {
            return this.f_78004_.getReader().getString();
        }
    }

    static class CommandMacro
    extends CommandFunction {
        private static final DecimalFormat f_301426_ = new DecimalFormat("#");
        private final List<String> f_291038_;
        private static final int f_291845_ = 8;
        private final Object2ObjectLinkedOpenHashMap<List<String>, CommandFunction> f_291458_ = new Object2ObjectLinkedOpenHashMap(8, 0.25f);

        public CommandMacro(ResourceLocation p_297380_, Entry[] p_300955_, List<String> p_300316_) {
            super(p_297380_, p_300955_);
            this.f_291038_ = p_300316_;
        }

        @Override
        public CommandFunction m_295804_(@Nullable CompoundTag p_300836_, CommandDispatcher<CommandSourceStack> p_297591_, CommandSourceStack p_298828_) throws FunctionInstantiationException {
            CommandFunction $$6;
            if (p_300836_ == null) {
                throw new FunctionInstantiationException(Component.m_237110_("commands.function.error.missing_arguments", this.m_77981_()));
            }
            ArrayList<String> $$3 = new ArrayList<String>(this.f_291038_.size());
            for (String $$4 : this.f_291038_) {
                if (!p_300836_.m_128441_($$4)) {
                    throw new FunctionInstantiationException(Component.m_237110_("commands.function.error.missing_argument", this.m_77981_(), $$4));
                }
                $$3.add(CommandMacro.m_294916_(p_300836_.m_128423_($$4)));
            }
            CommandFunction $$5 = (CommandFunction)this.f_291458_.getAndMoveToLast($$3);
            if ($$5 != null) {
                return $$5;
            }
            if (this.f_291458_.size() >= 8) {
                this.f_291458_.removeFirst();
            }
            if (($$6 = this.m_295572_($$3, p_297591_, p_298828_)) != null) {
                this.f_291458_.put($$3, (Object)$$6);
            }
            return $$6;
        }

        private static String m_294916_(Tag p_298736_) {
            if (p_298736_ instanceof FloatTag) {
                FloatTag $$1 = (FloatTag)p_298736_;
                return f_301426_.format($$1.m_7057_());
            }
            if (p_298736_ instanceof DoubleTag) {
                DoubleTag $$2 = (DoubleTag)p_298736_;
                return f_301426_.format($$2.m_7061_());
            }
            if (p_298736_ instanceof ByteTag) {
                ByteTag $$3 = (ByteTag)p_298736_;
                return String.valueOf($$3.m_7063_());
            }
            if (p_298736_ instanceof ShortTag) {
                ShortTag $$4 = (ShortTag)p_298736_;
                return String.valueOf($$4.m_7053_());
            }
            if (p_298736_ instanceof LongTag) {
                LongTag $$5 = (LongTag)p_298736_;
                return String.valueOf($$5.m_7046_());
            }
            return p_298736_.m_7916_();
        }

        private CommandFunction m_295572_(List<String> p_300530_, CommandDispatcher<CommandSourceStack> p_299533_, CommandSourceStack p_301159_) throws FunctionInstantiationException {
            Entry[] $$3 = this.m_77989_();
            Entry[] $$4 = new Entry[$$3.length];
            for (int $$5 = 0; $$5 < $$3.length; ++$$5) {
                Entry $$6 = $$3[$$5];
                if ($$6 instanceof MacroEntry) {
                    MacroEntry $$7 = (MacroEntry)$$6;
                    List<String> $$8 = $$7.m_294914_();
                    ArrayList<String> $$9 = new ArrayList<String>($$8.size());
                    for (String $$10 : $$8) {
                        $$9.add(p_300530_.get(this.f_291038_.indexOf($$10)));
                    }
                    String $$11 = $$7.m_293396_($$9);
                    try {
                        ParseResults $$12 = p_299533_.parse($$11, (Object)p_301159_);
                        if ($$12.getReader().canRead()) {
                            throw Commands.m_82097_($$12);
                        }
                        $$4[$$5] = new CommandEntry((ParseResults<CommandSourceStack>)$$12);
                        continue;
                    }
                    catch (CommandSyntaxException $$13) {
                        throw new FunctionInstantiationException(Component.m_237110_("commands.function.error.parse", this.m_77981_(), $$11, $$13.getMessage()));
                    }
                }
                $$4[$$5] = $$6;
            }
            ResourceLocation $$14 = this.m_77981_();
            return new CommandFunction(new ResourceLocation($$14.m_135827_(), $$14.m_135815_() + "/" + p_300530_.hashCode()), $$4);
        }

        static {
            f_301426_.setMaximumFractionDigits(15);
            f_301426_.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.US));
        }
    }

    public static class CacheableFunction {
        public static final CacheableFunction f_77990_ = new CacheableFunction((ResourceLocation)null);
        @Nullable
        private final ResourceLocation f_77991_;
        private boolean f_77992_;
        private Optional<CommandFunction> f_77993_ = Optional.empty();

        public CacheableFunction(@Nullable ResourceLocation p_77998_) {
            this.f_77991_ = p_77998_;
        }

        public CacheableFunction(CommandFunction p_77996_) {
            this.f_77992_ = true;
            this.f_77991_ = null;
            this.f_77993_ = Optional.of(p_77996_);
        }

        public Optional<CommandFunction> m_78002_(ServerFunctionManager p_78003_) {
            if (!this.f_77992_) {
                if (this.f_77991_ != null) {
                    this.f_77993_ = p_78003_.m_136118_(this.f_77991_);
                }
                this.f_77992_ = true;
            }
            return this.f_77993_;
        }

        @Nullable
        public ResourceLocation m_77999_() {
            return this.f_77993_.map(p_78001_ -> p_78001_.f_77977_).orElse(this.f_77991_);
        }
    }

    public static class FunctionEntry
    implements Entry {
        private final CacheableFunction f_78017_;

        public FunctionEntry(CommandFunction p_78019_) {
            this.f_78017_ = new CacheableFunction(p_78019_);
        }

        @Override
        public void m_142134_(ServerFunctionManager p_164902_, CommandSourceStack p_164903_, Deque<ServerFunctionManager.QueuedCommand> p_164904_, int p_164905_, int p_164906_, @Nullable ServerFunctionManager.TraceCallbacks p_164907_) {
            Util.m_137521_(this.f_78017_.m_78002_(p_164902_), p_164900_ -> {
                Entry[] $$6 = p_164900_.m_77989_();
                if (p_164907_ != null) {
                    p_164907_.m_142147_(p_164906_, p_164900_.m_77981_(), $$6.length);
                }
                int $$7 = p_164905_ - p_164904_.size();
                int $$8 = Math.min($$6.length, $$7);
                for (int $$9 = $$8 - 1; $$9 >= 0; --$$9) {
                    p_164904_.addFirst(new ServerFunctionManager.QueuedCommand(p_164903_, p_164906_ + 1, $$6[$$9]));
                }
            }, () -> {
                if (p_164907_ != null) {
                    p_164907_.m_142147_(p_164906_, this.f_78017_.m_77999_(), -1);
                }
            });
        }

        public String toString() {
            return "function " + this.f_78017_.m_77999_();
        }
    }
}

