/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.universalshops.gui.setup;

import eu.pb4.sgui.api.GuiHelpers;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.AnvilInputGui;
import eu.pb4.sgui.api.gui.GuiInterface;
import eu.pb4.universalshops.gui.GuiElements;
import eu.pb4.universalshops.gui.ShopGui;
import eu.pb4.universalshops.other.TextUtil;
import eu.pb4.universalshops.registry.TradeShopBlockEntity;
import eu.pb4.universalshops.trade.PriceHandler;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class VirtualBalanceValueGui
extends AnvilInputGui
implements ShopGui {
    private final PriceHandler.VirtualBalance handler;
    private final TradeShopBlockEntity be;
    private final GuiInterface previousGui;
    private boolean valid;

    public VirtualBalanceValueGui(class_3222 player, TradeShopBlockEntity be) {
        super(player, false);
        this.be = be;
        this.handler = (PriceHandler.VirtualBalance)be.priceHandler;
        this.setSlot(1, (GuiElementInterface)GuiElements.FILLER);
        this.setSlot(2, (GuiElementInterface)GuiElements.BACK);
        String x = this.handler.getCurrency().formatValue(this.handler.cost, true);
        this.setDefaultInputValue(x);
        this.onInput(x);
        this.previousGui = GuiHelpers.getCurrentGui((class_3222)player);
        this.open();
    }

    public void onInput(String input) {
        this.setDefaultInputValue(input);
        try {
            this.handler.cost = this.handler.getCurrency().parseValue(input);
            this.markDirty();
            if (!this.valid) {
                this.setTitle((class_2561)TextUtil.gui("virtual_balance.cost.title", new Object[0]));
            }
            this.valid = true;
        }
        catch (Throwable e) {
            if (!(e instanceof NumberFormatException)) {
                e.printStackTrace();
            }
            if (this.valid) {
                this.setTitle((class_2561)TextUtil.gui("virtual_balance.cost.invalid_input", new Object[0]).method_27692(class_124.field_1061));
            }
            this.valid = false;
        }
    }

    public void close() {
        if (this.previousGui != null) {
            this.previousGui.open();
        } else {
            super.close();
        }
    }

    @Override
    public TradeShopBlockEntity getBE() {
        return this.be;
    }
}

