/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.universalshops.gui.setup;

import eu.pb4.polymer.core.api.item.PolymerItemGroupUtils;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.GuiHelpers;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.GuiInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.universalshops.gui.ExtraGui;
import eu.pb4.universalshops.gui.GuiBackground;
import eu.pb4.universalshops.gui.GuiElements;
import eu.pb4.universalshops.gui.setup.ItemModificatorGui;
import eu.pb4.universalshops.other.TextUtil;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1713;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import net.minecraft.class_7708;
import net.minecraft.server.MinecraftServer;

public class SelectItemGui
extends SimpleGui
implements ExtraGui {
    private static final Map<class_1761, List<class_1799>> ITEM_GROUP_ITEMS = new IdentityHashMap<class_1761, List<class_1799>>();
    private static final List<class_1761> ITEM_GROUPS = new ArrayList<class_1761>();
    private final ItemModificatorGui.ItemStackHolder holder;
    private final GuiInterface previousGui;
    private class_1761 currentGroup = class_7706.method_47344();
    private List<class_1799> currentItems = ITEM_GROUP_ITEMS.get(this.currentGroup);
    private int page;

    public SelectItemGui(class_3222 player, ItemModificatorGui.ItemStackHolder holder) {
        super(class_3917.field_17327, player, false);
        this.holder = holder;
        this.previousGui = GuiHelpers.getCurrentGui((class_3222)player);
        if (!this.hasTexture()) {
            for (int i = 0; i < 9; ++i) {
                this.setSlot(45 + i, (GuiElementInterface)GuiElements.FILLER);
            }
        }
        this.updateItemsVisual();
        this.setSlot(45, (GuiElementInterface)new GuiElementBuilder(class_1802.field_8106).setName((class_2561)TextUtil.gui("modifying_item.change_item.select_item_group.title", new Object[0]).method_27692(class_124.field_1068)).setCallback((a, b, c, d) -> {
            this.playClickSound();
            this.close(true);
            new SelectItemGroup();
        }).build());
        this.setSlot(47, (GuiElementInterface)GuiElements.previousPage(() -> {
            this.playClickSound();
            int pages = (int)Math.ceil((double)this.currentItems.size() / 45.0);
            this.page = (pages + this.page - 1) % pages;
            this.updateItemsVisual();
        }));
        this.setSlot(49, (GuiElementInterface)GuiElements.BACK);
        this.setSlot(51, (GuiElementInterface)GuiElements.nextPage(() -> {
            this.playClickSound();
            int pages = (int)Math.ceil((double)this.currentItems.size() / 45.0);
            this.page = (this.page + 1) % pages;
            this.updateItemsVisual();
        }));
        this.setTitle((class_2561)this.texture(GuiBackground.SELECTOR_BIG).method_10852((class_2561)TextUtil.gui("modifying_item.change_item.title", new Object[0])));
        this.open();
    }

    private void updateItemsVisual() {
        for (int x = 0; x < 45; ++x) {
            int i = this.page * 9 * 5 + x;
            this.setSlot(x, (GuiElementInterface)(i < this.currentItems.size() ? GuiElementBuilder.from((class_1799)this.currentItems.get(i)).setCallback(this::setStack).build() : GuiElement.EMPTY));
        }
    }

    private void setStack(int i, ClickType type, class_1713 slotActionType) {
        this.holder.setItemStack(this.currentItems.get(i + this.page * 9 * 5).method_7972());
        this.playClickSound();
        this.close();
    }

    public void close() {
        if (this.previousGui != null) {
            this.previousGui.open();
        } else {
            super.close();
        }
    }

    public static void updateCachedItems(MinecraftServer server) {
        PolymerItemGroupUtils.Contents contents;
        ITEM_GROUP_ITEMS.clear();
        ITEM_GROUPS.clear();
        ITEM_GROUPS.add(class_7706.method_47344());
        Set items = class_7708.method_47572();
        for (class_1761 group : class_7706.method_47341()) {
            if (group.method_47312() != class_1761.class_7916.field_41052) continue;
            contents = PolymerItemGroupUtils.getContentsFor((class_1761)group, (class_7225.class_7874)server.method_30611().method_40316(), (class_7699)server.method_30002().method_45162(), (boolean)false);
            if (contents.main().size() > 0) {
                ITEM_GROUP_ITEMS.put(group, new ArrayList(contents.main()));
                ITEM_GROUPS.add(group);
            }
            items.addAll(contents.search());
        }
        for (class_1761 group : PolymerItemGroupUtils.REGISTRY) {
            contents = PolymerItemGroupUtils.getContentsFor((class_1761)group, (class_7225.class_7874)server.method_30611().method_40316(), (class_7699)server.method_30002().method_45162(), (boolean)false);
            if (contents.main().size() > 0) {
                ITEM_GROUP_ITEMS.put(group, new ArrayList(contents.main()));
                ITEM_GROUPS.add(group);
            }
            items.addAll(contents.search());
        }
        ITEM_GROUP_ITEMS.put(class_7706.method_47344(), new ArrayList(items));
    }

    private class SelectItemGroup
    extends SimpleGui {
        private int page;

        public SelectItemGroup() {
            super(class_3917.field_17327, SelectItemGui.this.player, false);
            this.updateItemsVisual();
            if (!SelectItemGui.this.hasTexture()) {
                for (int i = 0; i < 9; ++i) {
                    this.setSlot(45 + i, (GuiElementInterface)GuiElements.FILLER);
                }
            }
            this.updateItemsVisual();
            this.setSlot(47, (GuiElementInterface)GuiElements.previousPage(() -> {
                SelectItemGui.this.playClickSound();
                int pages = (int)Math.ceil((double)ITEM_GROUPS.size() / 45.0);
                this.page = (pages + this.page - 1) % pages;
                this.updateItemsVisual();
            }));
            this.setSlot(49, (GuiElementInterface)GuiElements.BACK);
            this.setSlot(51, (GuiElementInterface)GuiElements.nextPage(() -> {
                SelectItemGui.this.playClickSound();
                int pages = (int)Math.ceil((double)ITEM_GROUPS.size() / 45.0);
                this.page = (this.page + 1) % pages;
                this.updateItemsVisual();
            }));
            this.setTitle((class_2561)SelectItemGui.this.texture(GuiBackground.SELECTOR_BIG).method_10852((class_2561)TextUtil.gui("modifying_item.change_item.select_item_group.title", new Object[0])));
            this.open();
        }

        private void updateItemsVisual() {
            for (int x = 0; x < 45; ++x) {
                int i = this.page * 9 * 5 + x;
                if (i < ITEM_GROUPS.size()) {
                    class_1761 group = ITEM_GROUPS.get(i);
                    GuiElementBuilder b = GuiElementBuilder.from((class_1799)group.method_7747().method_7972()).setName(group.method_7737()).hideFlags();
                    if (group == SelectItemGui.this.currentGroup) {
                        b.glow();
                    }
                    this.setSlot(x, (GuiElementInterface)b.setCallback(this::setItemGroup).build());
                    continue;
                }
                this.setSlot(x, (GuiElementInterface)GuiElement.EMPTY);
            }
        }

        public void onClose() {
            SelectItemGui.this.open();
        }

        private void setItemGroup(int i, ClickType type, class_1713 slotActionType) {
            class_1761 group = ITEM_GROUPS.get(this.page * 9 * 5 + i);
            SelectItemGui.this.playClickSound();
            if (SelectItemGui.this.currentGroup != group) {
                SelectItemGui.this.page = 0;
                SelectItemGui.this.currentGroup = group;
                SelectItemGui.this.currentItems = ITEM_GROUP_ITEMS.get(group);
                SelectItemGui.this.updateItemsVisual();
            }
            SelectItemGui.this.open();
        }
    }
}

