/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_2561;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.config.BackgroundConfig;
import net.puffish.skillsmod.config.IconConfig;

public class GeneralConfig {
    private final class_2561 title;
    private final IconConfig icon;
    private final BackgroundConfig background;
    private final JsonElement colors;
    private final boolean unlockedByDefault;
    private final int startingPoints;
    private final boolean exclusiveRoot;
    private final int spentPointsLimit;

    private GeneralConfig(class_2561 title, IconConfig icon, BackgroundConfig background, JsonElement colors, boolean unlockedByDefault, int startingPoints, boolean exclusiveRoot, int spentPointsLimit) {
        this.title = title;
        this.icon = icon;
        this.background = background;
        this.colors = colors;
        this.unlockedByDefault = unlockedByDefault;
        this.startingPoints = startingPoints;
        this.exclusiveRoot = exclusiveRoot;
        this.spentPointsLimit = spentPointsLimit;
    }

    public static Result<GeneralConfig, Problem> parse(net.puffish.skillsmod.api.json.JsonElement rootElement) {
        return rootElement.getAsObject().andThen(GeneralConfig::parse);
    }

    public static Result<GeneralConfig, Problem> parse(net.puffish.skillsmod.api.json.JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional optTitle = rootObject.get("title").andThen(BuiltinJson::parseText).ifFailure(problems::add).getSuccess();
        Optional optIcon = rootObject.get("icon").andThen(IconConfig::parse).ifFailure(problems::add).getSuccess();
        Optional optBackground = rootObject.get("background").andThen(BackgroundConfig::parse).ifFailure(problems::add).getSuccess();
        JsonElement colors = rootObject.get("colors").getSuccess().map(net.puffish.skillsmod.api.json.JsonElement::getJson).orElse((JsonElement)new JsonObject());
        Boolean unlockedByDefault = rootObject.get("unlocked_by_default").getSuccess().flatMap(element -> element.getAsBoolean().ifFailure(problems::add).getSuccess()).orElse(true);
        Integer startingPoints = rootObject.get("starting_points").getSuccess().flatMap(element -> element.getAsInt().ifFailure(problems::add).getSuccess()).orElse(0);
        Boolean exclusiveRoot = rootObject.get("exclusive_root").getSuccess().flatMap(element -> element.getAsBoolean().ifFailure(problems::add).getSuccess()).orElse(false);
        Integer spentPointsLimit = rootObject.get("spent_points_limit").getSuccess().flatMap(element -> element.getAsInt().ifFailure(problems::add).getSuccess()).orElse(Integer.MAX_VALUE);
        if (problems.isEmpty()) {
            return Result.success(new GeneralConfig((class_2561)optTitle.orElseThrow(), (IconConfig)optIcon.orElseThrow(), (BackgroundConfig)optBackground.orElseThrow(), colors, unlockedByDefault, startingPoints, exclusiveRoot, spentPointsLimit));
        }
        return Result.failure(Problem.combine(problems));
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public boolean isUnlockedByDefault() {
        return this.unlockedByDefault;
    }

    public int getStartingPoints() {
        return this.startingPoints;
    }

    public boolean isExclusiveRoot() {
        return this.exclusiveRoot;
    }

    public IconConfig getIcon() {
        return this.icon;
    }

    public BackgroundConfig getBackground() {
        return this.background;
    }

    public JsonElement getColors() {
        return this.colors;
    }

    public int getSpentPointsLimit() {
        return this.spentPointsLimit;
    }
}

