/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.network.packets.in;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.client.config.ClientBackgroundConfig;
import net.puffish.skillsmod.client.config.ClientCategoryConfig;
import net.puffish.skillsmod.client.config.ClientFrameConfig;
import net.puffish.skillsmod.client.config.ClientIconConfig;
import net.puffish.skillsmod.client.config.colors.ClientColorsConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillConnectionConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillDefinitionConfig;
import net.puffish.skillsmod.client.data.ClientCategoryData;
import net.puffish.skillsmod.network.InPacket;

public class ShowCategoryInPacket
implements InPacket {
    private final ClientCategoryData category;

    private ShowCategoryInPacket(ClientCategoryData category) {
        this.category = category;
    }

    public static ShowCategoryInPacket read(class_2540 buf) {
        ClientCategoryData category = ShowCategoryInPacket.readCategory(buf);
        return new ShowCategoryInPacket(category);
    }

    public static ClientCategoryData readCategory(class_2540 buf) {
        class_2960 id = buf.method_10810();
        class_2561 title = buf.method_10808();
        ClientIconConfig icon = ShowCategoryInPacket.readSkillIcon(buf);
        ClientBackgroundConfig background = ShowCategoryInPacket.readBackground(buf);
        ClientColorsConfig colors = ShowCategoryInPacket.readColors(buf);
        boolean exclusiveRoot = buf.readBoolean();
        int spentPointsLimit = buf.readInt();
        Map<String, ClientSkillDefinitionConfig> definitions = buf.method_34066(ShowCategoryInPacket::readDefinition).stream().collect(Collectors.toMap(ClientSkillDefinitionConfig::id, definition -> definition));
        Map<String, ClientSkillConfig> skills = buf.method_34066(ShowCategoryInPacket::readSkill).stream().collect(Collectors.toMap(ClientSkillConfig::id, skill -> skill));
        List normalConnections = buf.method_34066(ShowCategoryInPacket::readSkillConnection);
        List exclusiveConnections = buf.method_34066(ShowCategoryInPacket::readSkillConnection);
        Map skillsStates = buf.method_34067(class_2540::method_19772, buf1 -> (Skill.State)buf1.method_10818(Skill.State.class));
        int spentPoints = buf.readInt();
        int earnedPoints = buf.readInt();
        int currentLevel = Integer.MIN_VALUE;
        int currentExperience = Integer.MIN_VALUE;
        int requiredExperience = Integer.MIN_VALUE;
        if (buf.readBoolean()) {
            currentLevel = buf.readInt();
            currentExperience = buf.readInt();
            requiredExperience = buf.readInt();
        }
        ClientCategoryConfig category = new ClientCategoryConfig(id, title, icon, background, colors, exclusiveRoot, spentPointsLimit, definitions, skills, normalConnections, exclusiveConnections);
        return new ClientCategoryData(category, skillsStates, spentPoints, earnedPoints, currentLevel, currentExperience, requiredExperience);
    }

    public static ClientSkillDefinitionConfig readDefinition(class_2540 buf) {
        String id = buf.method_19772();
        class_2561 title = buf.method_10808();
        class_2561 description = buf.method_10808();
        class_2561 extraDescription = buf.method_10808();
        ClientFrameConfig frame = ShowCategoryInPacket.readFrameIcon(buf);
        ClientIconConfig icon = ShowCategoryInPacket.readSkillIcon(buf);
        float size = buf.readFloat();
        int cost = buf.readInt();
        int requiredSkills = buf.readInt();
        int requiredPoints = buf.readInt();
        int requiredSpentPoints = buf.readInt();
        return new ClientSkillDefinitionConfig(id, title, description, extraDescription, icon, frame, size, cost, requiredSkills, requiredPoints, requiredSpentPoints);
    }

    public static ClientIconConfig readSkillIcon(class_2540 buf) {
        String type = buf.method_19772();
        return (ClientIconConfig)((Object)buf.method_37436(class_2540::method_19772).flatMap(data -> JsonElement.parseString(data, JsonPath.create("Client Skill Icon")).getSuccess()).flatMap(rootElement -> switch (type) {
            case "item" -> ClientIconConfig.ItemIconConfig.parse(rootElement).getSuccess();
            case "effect" -> ClientIconConfig.EffectIconConfig.parse(rootElement).getSuccess();
            case "texture" -> ClientIconConfig.TextureIconConfig.parse(rootElement).getSuccess();
            default -> Optional.empty();
        }).orElseGet(ClientIconConfig.TextureIconConfig::createMissing));
    }

    public static ClientFrameConfig readFrameIcon(class_2540 buf) {
        String type = buf.method_19772();
        return (ClientFrameConfig)((Object)buf.method_37436(class_2540::method_19772).flatMap(data -> JsonElement.parseString(data, JsonPath.create("Client Frame Icon")).getSuccess()).flatMap(rootElement -> switch (type) {
            case "advancement" -> ClientFrameConfig.AdvancementFrameConfig.parse(rootElement).getSuccess();
            case "texture" -> ClientFrameConfig.TextureFrameConfig.parse(rootElement).getSuccess();
            default -> Optional.empty();
        }).orElseGet(ClientFrameConfig.TextureFrameConfig::createMissing));
    }

    public static ClientBackgroundConfig readBackground(class_2540 buf) {
        return buf.method_37436(class_2540::method_19772).flatMap(data -> JsonElement.parseString(data, JsonPath.create("Client Background")).getSuccess()).flatMap(rootElement -> ClientBackgroundConfig.parse(rootElement).getSuccess()).orElseGet(ClientBackgroundConfig::createMissing);
    }

    public static ClientColorsConfig readColors(class_2540 buf) {
        return buf.method_37436(class_2540::method_19772).flatMap(data -> JsonElement.parseString(data, JsonPath.create("Client Colors")).getSuccess()).flatMap(rootElement -> ClientColorsConfig.parse(rootElement).getSuccess()).orElseGet(ClientColorsConfig::createDefault);
    }

    public static ClientSkillConfig readSkill(class_2540 buf) {
        String id = buf.method_19772();
        int x = buf.readInt();
        int y = buf.readInt();
        String definition = buf.method_19772();
        boolean isRoot = buf.readBoolean();
        return new ClientSkillConfig(id, x, y, definition, isRoot);
    }

    public static ClientSkillConnectionConfig readSkillConnection(class_2540 buf) {
        String skillAId = buf.method_19772();
        String skillBId = buf.method_19772();
        boolean bidirectional = buf.readBoolean();
        return new ClientSkillConnectionConfig(skillAId, skillBId, bidirectional);
    }

    public ClientCategoryData getCategory() {
        return this.category;
    }
}

