/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.config.colors;

import java.util.ArrayList;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.client.config.colors.ClientColorConfig;

public record ClientFillStrokeColorsConfig(ClientColorConfig fill, ClientColorConfig stroke) {
    public static Result<ClientFillStrokeColorsConfig, Problem> parse(JsonElement rootElement, ClientFillStrokeColorsConfig defaultColors) {
        return ClientColorConfig.parse(rootElement).mapSuccess(fill -> new ClientFillStrokeColorsConfig((ClientColorConfig)fill, defaultColors.stroke)).orElse(failure -> rootElement.getAsObject().andThen(rootObject -> ClientFillStrokeColorsConfig.parse(rootObject, defaultColors)));
    }

    private static Result<ClientFillStrokeColorsConfig, Problem> parse(JsonObject rootObject, ClientFillStrokeColorsConfig defaultColors) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        ClientColorConfig fill = rootObject.get("fill").getSuccess().flatMap(element -> ClientColorConfig.parse(element).ifFailure(problems::add).getSuccess()).orElse(defaultColors.fill);
        ClientColorConfig stroke = rootObject.get("stroke").getSuccess().flatMap(element -> ClientColorConfig.parse(element).ifFailure(problems::add).getSuccess()).orElse(defaultColors.stroke);
        if (problems.isEmpty()) {
            return Result.success(new ClientFillStrokeColorsConfig(fill, stroke));
        }
        return Result.failure(Problem.combine(problems));
    }
}

