/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.config;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1060;
import net.minecraft.class_189;
import net.minecraft.class_2960;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClientFrameConfig {

    public record TextureFrameConfig(Optional<class_2960> lockedTexture, class_2960 availableTexture, Optional<class_2960> affordableTexture, class_2960 unlockedTexture, Optional<class_2960> excludedTexture) implements ClientFrameConfig
    {
        public static Result<TextureFrameConfig, Problem> parse(JsonElement rootElement) {
            return rootElement.getAsObject().andThen(TextureFrameConfig::parse);
        }

        private static Result<TextureFrameConfig, Problem> parse(JsonObject rootObject) {
            ArrayList<Problem> problems = new ArrayList<Problem>();
            Optional<class_2960> optAffordableTexture = rootObject.get("affordable").getSuccess().flatMap(element -> BuiltinJson.parseIdentifier(element).ifFailure(problems::add).getSuccess());
            Optional optAvailableTexture = rootObject.get("available").andThen(BuiltinJson::parseIdentifier).ifFailure(problems::add).getSuccess();
            Optional<class_2960> optLockedTexture = rootObject.get("locked").getSuccess().flatMap(element -> BuiltinJson.parseIdentifier(element).ifFailure(problems::add).getSuccess());
            Optional optUnlockedTexture = rootObject.get("unlocked").andThen(BuiltinJson::parseIdentifier).ifFailure(problems::add).getSuccess();
            Optional<class_2960> optExcludedTexture = rootObject.get("excluded").getSuccess().flatMap(element -> BuiltinJson.parseIdentifier(element).ifFailure(problems::add).getSuccess());
            if (problems.isEmpty()) {
                return Result.success(new TextureFrameConfig(optLockedTexture, (class_2960)optAvailableTexture.orElseThrow(), optAffordableTexture, (class_2960)optUnlockedTexture.orElseThrow(), optExcludedTexture));
            }
            return Result.failure(Problem.combine(problems));
        }

        public static TextureFrameConfig createMissing() {
            return new TextureFrameConfig(Optional.of(class_1060.field_5285), class_1060.field_5285, Optional.of(class_1060.field_5285), class_1060.field_5285, Optional.of(class_1060.field_5285));
        }
    }

    public record AdvancementFrameConfig(class_189 frame) implements ClientFrameConfig
    {
        public static Result<AdvancementFrameConfig, Problem> parse(JsonElement rootElement) {
            return rootElement.getAsObject().andThen(rootObject -> rootObject.get("frame")).andThen(BuiltinJson::parseFrame).mapSuccess(AdvancementFrameConfig::new);
        }
    }
}

