/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import immersive_aircraft.cobalt.registration.CobaltFuelRegistry;
import immersive_aircraft.config.Config;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1746;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2573;
import net.minecraft.class_2582;
import net.minecraft.class_6880;
import net.minecraft.class_7446;
import net.minecraft.class_7923;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class Utils {
    public static double cosNoise(double time) {
        return Utils.cosNoise(time, 5);
    }

    public static double cosNoise(double time, int layers) {
        double value = 0.0;
        for (int i = 0; i < layers; ++i) {
            value += Math.cos(time);
            time *= 1.3;
        }
        return value;
    }

    public static List<Pair<class_6880<class_2582>, class_1767>> parseBannerItem(class_1799 banner) {
        class_1767 baseColor = ((class_1746)banner.method_7909()).method_7706();
        class_2487 nbtCompound = class_1747.method_38072((class_1799)banner);
        if (nbtCompound == null || !nbtCompound.method_10545("Patterns")) {
            return List.of(Pair.of((Object)class_7923.field_41165.method_40290(class_7446.field_39151), (Object)baseColor));
        }
        class_2499 nbtList = nbtCompound.method_10554("Patterns", 10);
        return class_2573.method_24280((class_1767)baseColor, (class_2499)nbtList);
    }

    public static int getFuelTime(class_1799 fuel) {
        int fuelTime;
        if (fuel.method_7960()) {
            return 0;
        }
        Map<String, Integer> fuelList = Config.getInstance().fuelList;
        String identifier = class_7923.field_41178.method_10221((Object)fuel.method_7909()).toString();
        if (fuelList.containsKey(identifier)) {
            return fuelList.get(identifier);
        }
        if (Config.getInstance().acceptVanillaFuel && (fuelTime = CobaltFuelRegistry.INSTANCE.get(fuel)) > 0) {
            return fuelTime;
        }
        return 0;
    }

    public static boolean getBooleanElement(JsonObject object, String member) {
        JsonPrimitive element = object.getAsJsonPrimitive(member);
        if (element == null) {
            return false;
        }
        return element.getAsBoolean();
    }

    public static boolean isNull(JsonObject object, String member) {
        return object.has(member) && object.get(member).isJsonNull();
    }

    public static int getIntElement(JsonObject object, String member) {
        return Utils.getIntElement(object, member, 0);
    }

    public static int getIntElement(JsonObject object, String member, int defaultValue) {
        JsonPrimitive element = object.getAsJsonPrimitive(member);
        if (element == null) {
            return defaultValue;
        }
        return element.getAsInt();
    }

    public static float getFloatElement(JsonObject object, String member) {
        return Utils.getFloatElement(object, member, 0.0f);
    }

    public static float getFloatElement(JsonObject object, String member, float defaultValue) {
        JsonPrimitive element = object.getAsJsonPrimitive(member);
        if (element == null) {
            return defaultValue;
        }
        return element.getAsFloat();
    }

    public static Vector3f parseVector(JsonObject element, String member) {
        JsonArray array = element.getAsJsonArray(member);
        if (array == null) {
            return new Vector3f();
        }
        return new Vector3f(array.get(0).getAsFloat(), array.get(1).getAsFloat(), array.get(2).getAsFloat());
    }

    public static Quaternionf fromXYZ(float pitch, float yaw, float roll) {
        Quaternionf quaternion = new Quaternionf();
        quaternion.rotationZYX(roll, yaw, pitch);
        return quaternion;
    }

    public static Quaternionf fromXYZ(Vector3f rotation) {
        return Utils.fromXYZ(rotation.x, rotation.y, rotation.z);
    }
}

