/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.network.s2c;

import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.item.upgrade.VehicleStat;
import immersive_aircraft.item.upgrade.VehicleUpgrade;
import immersive_aircraft.item.upgrade.VehicleUpgradeRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2540;
import net.minecraft.class_7923;

public class VehicleUpgradesMessage
extends Message {
    private final Map<class_1792, VehicleUpgrade> upgrades;

    public VehicleUpgradesMessage() {
        this.upgrades = VehicleUpgradeRegistry.INSTANCE.getAll();
    }

    public VehicleUpgradesMessage(class_2540 buffer) {
        this.upgrades = new HashMap<class_1792, VehicleUpgrade>();
        int upgradeCount = buffer.readInt();
        for (int i = 0; i < upgradeCount; ++i) {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(buffer.method_10810());
            this.upgrades.put(item, this.readUpgrade(buffer));
        }
    }

    @Override
    public void encode(class_2540 buffer) {
        Map<class_1792, VehicleUpgrade> upgrades = VehicleUpgradeRegistry.INSTANCE.getAll();
        buffer.writeInt(upgrades.size());
        for (class_1792 item : upgrades.keySet()) {
            buffer.method_10812(class_7923.field_41178.method_10221((Object)item));
            this.writeUpgrade(buffer, upgrades.get(item));
        }
    }

    protected void writeUpgrade(class_2540 buffer, VehicleUpgrade upgrade) {
        Map<VehicleStat, Float> upgradeMap = upgrade.getAll();
        buffer.writeInt(upgradeMap.size());
        for (VehicleStat stat : upgradeMap.keySet()) {
            buffer.method_10814(stat.name());
            buffer.writeFloat(upgradeMap.get(stat).floatValue());
        }
    }

    protected VehicleUpgrade readUpgrade(class_2540 buffer) {
        VehicleUpgrade upgrade = new VehicleUpgrade();
        int statCount = buffer.readInt();
        for (int j = 0; j < statCount; ++j) {
            upgrade.set(VehicleStat.STATS.get(buffer.method_19772()), buffer.readFloat());
        }
        return upgrade;
    }

    @Override
    public void receive(class_1657 player) {
        VehicleUpgradeRegistry.INSTANCE.replace(this.upgrades);
    }
}

