/*
 * Decompiled with CFR 0.152.
 */
package dev.fulmineo.guild.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.fulmineo.guild.Guild;
import dev.fulmineo.guild.data.Quest;
import dev.fulmineo.guild.data.QuestProfession;
import dev.fulmineo.guild.screen.QuestsScreenHandler;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import net.minecraft.class_7923;

public class QuestsScreen
extends class_465<QuestsScreenHandler> {
    private static final class_2960 TEXTURE = new class_2960("guild", "textures/gui/container/guild.png");
    private ProfessionButton[] professions = new ProfessionButton[7];
    private List<QuestButton> available = new ArrayList<QuestButton>();
    private List<QuestButton> accepted = new ArrayList<QuestButton>();
    private List<Quest> professionQuests = new ArrayList<Quest>();
    int indexStartOffset;
    private String professionName;
    private QuestsScreenHandler.ProfessionData professionData;
    private boolean deleteMode;

    public QuestsScreen(QuestsScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_2792 = 276;
        this.field_2779 = 200;
        this.field_25268 = 4;
    }

    protected void method_25426() {
        super.method_25426();
        int w = (this.field_22789 - this.field_2792) / 2;
        int h = (this.field_22790 - this.field_2779) / 2;
        this.method_37063((class_364)new InfoButton(w + 6, h + 16, button -> {}));
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.guild.quest.delete"), button -> {
            this.deleteMode = !this.deleteMode;
            button.method_25355((class_2561)(this.deleteMode ? class_2561.method_43471((String)"button.guild.quest.cancel") : class_2561.method_43471((String)"button.guild.quest.delete")));
            for (int i = 0; i < this.available.size(); ++i) {
                this.available.get((int)i).field_22763 = this.deleteMode ? true : ((QuestsScreenHandler)this.field_2797).acceptedQuests.size() < ((QuestsScreenHandler)this.field_2797).maxAcceptedQuests;
            }
        }).method_46434(w + this.field_2792 - 56, h + 16, 50, 20).method_46431());
        int y = h + 41;
        int profNum = ((QuestsScreenHandler)this.field_2797).professions.size();
        int x = this.field_22789 / 2 - (profNum * 20 + (profNum - 1) * 2) / 2;
        for (int i = 0; i < profNum; ++i) {
            this.professions[i] = (ProfessionButton)this.method_37063((class_364)new ProfessionButton(x, y - 25, i, button -> {
                if (!button.field_22763) {
                    return;
                }
                this.selectProfession(((ProfessionButton)button).index);
            }));
            x += 22;
        }
        if (((QuestsScreenHandler)this.field_2797).professions.size() > 0) {
            this.selectProfession(0);
        }
    }

    private void initButtons() {
        QuestButton btn;
        int i;
        int w = (this.field_22789 - this.field_2792) / 2;
        int h = (this.field_22790 - this.field_2779) / 2;
        int y = h + 52;
        for (i = 0; i < ((QuestsScreenHandler)this.field_2797).professions.size(); ++i) {
            this.professions[i].field_22763 = ((QuestsScreenHandler)this.field_2797).professions.get((int)i).name != this.professionName;
        }
        for (i = 0; i < this.available.size(); ++i) {
            this.method_37066((class_364)this.available.get(i));
        }
        for (i = 0; i < this.accepted.size(); ++i) {
            this.method_37066((class_364)this.accepted.get(i));
        }
        this.available.clear();
        this.accepted.clear();
        for (i = 0; i < this.professionQuests.size(); ++i) {
            this.professionQuests.get(i).updateTasksAndRewards();
            btn = (AvailableQuestButton)this.method_37063((class_364)new AvailableQuestButton(w + 6, y, i, button -> {
                int index = ((AvailableQuestButton)button).index;
                if (this.deleteMode) {
                    ((QuestsScreenHandler)this.field_2797).deleteAvailableQuest(this.professionName, index);
                } else {
                    if (!button.field_22763 || ((QuestsScreenHandler)this.field_2797).acceptedQuests.size() == ((QuestsScreenHandler)this.field_2797).maxAcceptedQuests) {
                        return;
                    }
                    ((QuestsScreenHandler)this.field_2797).acceptQuest(this.professionName, index);
                    this.professionQuests = ((QuestsScreenHandler)this.field_2797).availableQuests.get(this.professionName);
                }
                this.initButtons();
            }));
            btn.field_22763 = ((QuestsScreenHandler)this.field_2797).acceptedQuests.size() < ((QuestsScreenHandler)this.field_2797).maxAcceptedQuests;
            this.available.add(btn);
            y += 20;
        }
        y = h + 52;
        for (i = 0; i < ((QuestsScreenHandler)this.field_2797).acceptedQuests.size(); ++i) {
            ((QuestsScreenHandler)this.field_2797).acceptedQuests.get(i).updateTasksAndRewards();
            btn = (AcceptedQuestButton)this.method_37063((class_364)new AcceptedQuestButton(w + 143, y, i, button -> {
                int index = ((AcceptedQuestButton)button).index;
                if (this.deleteMode) {
                    ((QuestsScreenHandler)this.field_2797).deleteAcceptedQuest(index);
                } else if (((QuestsScreenHandler)this.field_2797).acceptedQuests.size() > index) {
                    ((QuestsScreenHandler)this.field_2797).tryCompleteQuest(index);
                }
                this.initButtons();
            }));
            this.accepted.add(btn);
            y += 20;
        }
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        int x = (70 - this.field_22793.method_27525((class_5348)this.field_22785)) / 2;
        context.method_51439(this.field_22793, this.field_22785, x, this.field_25268, 0x404040, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"screen.guild.quests.available"), 6, 40, 0x404040, false);
        class_5250 accepted = class_2561.method_43471((String)"screen.guild.quests.accepted");
        context.method_51439(this.field_22793, (class_2561)accepted, this.field_2792 - 6 - this.field_22793.method_27525((class_5348)accepted), 40, 0x404040, false);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        context.method_25290(TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, 512, 256);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        this.drawLevelInfo(context, i, j);
    }

    private void drawLevelInfo(class_332 context, int x, int y) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        context.method_25290(TEXTURE, x + 85, y + 44, 0.0f, 216.0f, 102, 5, 512, 256);
        context.method_25290(TEXTURE, x + 85, y + 44, 0.0f, 221.0f, this.professionData.levelPerc + 1, 5, 512, 256);
        int tx = x + 138;
        int ty = y + 38;
        String val = String.valueOf(this.professionData.level + 1);
        context.method_51433(this.field_22793, val, (tx -= this.field_22793.method_1727(val) / 2) + 1, ty, 0, false);
        context.method_51433(this.field_22793, val, tx - 1, ty, 0, false);
        context.method_51433(this.field_22793, val, tx, ty + 1, 0, false);
        context.method_51433(this.field_22793, val, tx, ty - 1, 0, false);
        context.method_51433(this.field_22793, val, tx, ty, 8453920, false);
    }

    private void selectProfession(int index) {
        QuestProfession profession = ((QuestsScreenHandler)this.field_2797).professions.get(index);
        this.professionName = profession.name;
        this.professionQuests = ((QuestsScreenHandler)this.field_2797).availableQuests.get(this.professionName);
        if (this.professionQuests == null) {
            this.professionQuests = new ArrayList<Quest>();
        }
        this.professionData = ((QuestsScreenHandler)this.field_2797).professionsData.get(this.professionName);
        this.initButtons();
    }

    @Environment(value=EnvType.CLIENT)
    class ProfessionButton
    extends class_4185 {
        final int index;
        private class_1792 item;

        public ProfessionButton(int x, int y, int index, class_4185.class_4241 onPress) {
            super(x, y, 20, 20, (class_2561)class_2561.method_43473(), onPress, class_4185.field_40754);
            this.index = index;
        }

        public QuestProfession getQuestProfession() {
            return ((QuestsScreenHandler)((QuestsScreen)QuestsScreen.this).field_2797).professions.get(this.index);
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            QuestProfession profession = this.getQuestProfession();
            if (profession == null) {
                return;
            }
            super.method_48579(context, mouseX, mouseY, delta);
            if (this.item == null) {
                this.item = (class_1792)class_7923.field_41178.method_10223(new class_2960(profession.icon));
            }
            class_1799 stack = new class_1799((class_1935)this.item);
            context.method_51427(stack, this.method_46426() + 2, this.method_46427() + 2);
            this.renderTooltip(context, mouseX, mouseY);
        }

        public void renderTooltip(class_332 context, int mouseX, int mouseY) {
            if (this.field_22762) {
                ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
                QuestProfession profession = this.getQuestProfession();
                tooltip.add(QuestProfession.getTranslatedText(profession.name).method_27692(class_124.field_1065));
                context.method_51434(QuestsScreen.this.field_22793, tooltip, mouseX, mouseY);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    class InfoButton
    extends class_4185 {
        public InfoButton(int x, int y, class_4185.class_4241 onPress) {
            super(x, y, 20, 20, (class_2561)class_2561.method_43470((String)"?"), onPress, class_4185.field_40754);
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_48579(context, mouseX, mouseY, delta);
            if (this.field_22762) {
                ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
                tooltip.add(class_2561.method_43471((String)"screen.guild.quests.legend").method_27692(class_124.field_1075));
                if (Guild.CONFIG.expirationTicks != 0) {
                    tooltip.add(class_2561.method_43470((String)"\u231a").method_27692(class_124.field_1062).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"screen.guild.quests.quest_expiration")));
                    tooltip.add(class_2561.method_43469((String)"screen.guild.quests.quest_expiration.description", (Object[])new Object[]{Guild.CONFIG.expirationTicks / 60 / 20}).method_27692(class_124.field_1063));
                }
                tooltip.add(class_2561.method_43470((String)"\u231a").method_27692(class_124.field_1080).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"screen.guild.quests.time_available")));
                tooltip.add(class_2561.method_43471((String)"screen.guild.quests.time_available.description").method_27692(class_124.field_1063));
                tooltip.add(class_2561.method_43471((String)"screen.guild.quests.time_available.description2").method_27692(class_124.field_1063));
                tooltip.add(class_2561.method_43471((String)"screen.guild.quests.time_available.description3").method_27692(class_124.field_1063));
                tooltip.add(class_2561.method_43470((String)"\u2709").method_27692(class_124.field_1080).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"screen.guild.quests.item")));
                tooltip.add(class_2561.method_43471((String)"screen.guild.quests.item.description").method_27692(class_124.field_1063));
                tooltip.add(class_2561.method_43471((String)"screen.guild.quests.item.description2").method_27692(class_124.field_1063));
                tooltip.add(class_2561.method_43470((String)"\ud83d\udde1").method_27692(class_124.field_1080).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"screen.guild.quests.slay")));
                tooltip.add(class_2561.method_43471((String)"screen.guild.quests.slay.description").method_27692(class_124.field_1063));
                tooltip.add(class_2561.method_43470((String)"\u2719").method_27692(class_124.field_1080).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"screen.guild.quests.cure")));
                tooltip.add(class_2561.method_43471((String)"screen.guild.quests.cure.description").method_27692(class_124.field_1063));
                tooltip.add(class_2561.method_43470((String)"\u2726").method_27692(class_124.field_1080).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"screen.guild.quests.summon")));
                tooltip.add(class_2561.method_43471((String)"screen.guild.quests.summon.description").method_27692(class_124.field_1063));
                tooltip.add(class_2561.method_43470((String)"\u2666").method_27692(class_124.field_1077).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"screen.guild.quests.player_exp")));
                tooltip.add(class_2561.method_43471((String)"screen.guild.quests.player_exp.description").method_27692(class_124.field_1063));
                tooltip.add(class_2561.method_43470((String)"\u2666").method_27692(class_124.field_1080).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"screen.guild.quests.exp")));
                tooltip.add(class_2561.method_43471((String)"screen.guild.quests.exp.description").method_27692(class_124.field_1063));
                context.method_51434(QuestsScreen.this.field_22793, tooltip, mouseX, mouseY);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    class AvailableQuestButton
    extends QuestButton {
        public AvailableQuestButton(int x, int y, int index, class_4185.class_4241 onPress) {
            super(x, y, index, onPress);
        }

        @Override
        public Quest getQuest() {
            return QuestsScreen.this.professionQuests.size() > this.index ? QuestsScreen.this.professionQuests.get(this.index) : null;
        }
    }

    @Environment(value=EnvType.CLIENT)
    class AcceptedQuestButton
    extends QuestButton {
        public AcceptedQuestButton(int x, int y, int index, class_4185.class_4241 onPress) {
            super(x, y, index, onPress);
        }

        @Override
        public Quest getQuest() {
            return ((QuestsScreenHandler)((QuestsScreen)QuestsScreen.this).field_2797).acceptedQuests.size() > this.index ? ((QuestsScreenHandler)((QuestsScreen)QuestsScreen.this).field_2797).acceptedQuests.get(this.index) : null;
        }

        @Override
        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            Quest quest = this.getQuest();
            if (quest == null) {
                return;
            }
            super.method_48579(context, mouseX, mouseY, delta);
        }
    }

    @Environment(value=EnvType.CLIENT)
    abstract class QuestButton
    extends class_4185 {
        final int index;

        public QuestButton(int x, int y, int index, class_4185.class_4241 onPress) {
            super(x, y, 126, 20, (class_2561)class_2561.method_43473(), onPress, class_4185.field_40754);
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public Quest getQuest() {
            return null;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            Quest quest = this.getQuest();
            if (quest == null) {
                return;
            }
            super.method_48579(context, mouseX, mouseY, delta);
            int xi = this.method_46426() + 3;
            int yi = this.method_46427() + 1;
            for (Quest.QuestData data : quest.tasks) {
                context.method_51427(data.stack, xi, yi);
                this.renderGuiItemOverlay(context, QuestsScreen.this.field_22793, data.stack, xi, yi, data.needed - data.count);
                xi += 20;
            }
            xi = this.method_46426() + 108;
            for (Quest.QuestData data : quest.rewards) {
                context.method_51427(data.stack, xi, yi);
                this.renderGuiItemOverlay(context, QuestsScreen.this.field_22793, data.stack, xi, yi, data.count);
                xi -= 18;
            }
            this.renderTooltip(context, mouseX, mouseY);
        }

        protected void renderGuiItemOverlay(class_332 context, class_327 renderer, class_1799 stack, int x, int y, int val) {
            context.method_51432(QuestsScreen.this.field_22793, stack, x, y, val > 0 ? String.valueOf(val) : "\u2714");
        }

        public void renderTooltip(class_332 context, int mouseX, int mouseY) {
            if (this.field_22762) {
                Quest quest = this.getQuest();
                if (quest == null) {
                    return;
                }
                ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
                class_5250 text = class_2561.method_43471((String)"screen.guild.quests.tasks").method_27692(class_124.field_1078).method_27693("      ");
                long time = ((QuestsScreenHandler)((QuestsScreen)QuestsScreen.this).field_2797).world.method_8510();
                int timeLen = 2;
                String accTime = quest.getAcceptationTime(time);
                String remTime = quest.getRemainingTime(time);
                if (accTime.length() > 0) {
                    text.method_10852((class_2561)class_2561.method_43470((String)("\u231a " + accTime)).method_27692(accTime == "00:00" ? class_124.field_1061 : class_124.field_1062));
                    timeLen += 2 + accTime.length();
                } else {
                    text.method_27693("           ");
                    timeLen += 8;
                }
                if (remTime.length() > 0) {
                    if (accTime.length() > 0) {
                        text.method_27693(" ");
                        ++timeLen;
                    }
                    text.method_10852((class_2561)class_2561.method_43470((String)("\u231a " + remTime)).method_27692(remTime == "00:00" ? class_124.field_1061 : class_124.field_1080));
                    timeLen += 2 + remTime.length();
                }
                tooltip.add(text);
                for (Quest.QuestData task : quest.tasks) {
                    tooltip.add(class_2561.method_43470((String)task.icon).method_27692(class_124.field_1080).method_27693(" ").method_10852(task.stack.method_7964()).method_27693(" ").method_27693(String.valueOf(task.count)).method_27693(" / ").method_27693(String.valueOf(task.needed)));
                }
                text = class_2561.method_43471((String)"screen.guild.quests.rewards").method_27692(class_124.field_1060).method_27693("    ");
                class_2487 nbt = quest.getNbt();
                int exp = nbt.method_10550("Exp");
                int playerExp = nbt.method_10550("PlayerExp");
                if (exp > 0) {
                    if (playerExp > 0) {
                        --timeLen;
                    }
                    timeLen -= 2 + String.valueOf(exp).length();
                }
                if (playerExp > 0) {
                    timeLen -= 2 + String.valueOf(playerExp).length();
                }
                while (timeLen > 0) {
                    text.method_27693(" ");
                    --timeLen;
                }
                if (playerExp > 0) {
                    text.method_10852((class_2561)class_2561.method_43470((String)("\u2666 " + playerExp)).method_27692(class_124.field_1077));
                }
                if (exp > 0) {
                    if (playerExp > 0) {
                        text.method_27693(" ");
                    }
                    text.method_10852((class_2561)class_2561.method_43470((String)("\u2666 " + exp)).method_27692(class_124.field_1080));
                }
                tooltip.add(text);
                for (Quest.QuestData reward : quest.rewards) {
                    tooltip.add(class_2561.method_43470((String)"").method_27692(class_124.field_1080).method_10852(reward.stack.method_7964()).method_27693(" ").method_27693(String.valueOf(reward.count)));
                }
                context.method_51434(QuestsScreen.this.field_22793, tooltip, mouseX, mouseY);
            }
        }
    }
}

