/*
 * Decompiled with CFR 0.152.
 */
package dev.fulmineo.guild.network;

import dev.fulmineo.guild.Guild;
import dev.fulmineo.guild.data.GuildServerPlayerEntity;
import dev.fulmineo.guild.data.Quest;
import dev.fulmineo.guild.data.QuestHelper;
import dev.fulmineo.guild.data.QuestLevel;
import dev.fulmineo.guild.data.QuestPoolData;
import dev.fulmineo.guild.data.QuestProfession;
import dev.fulmineo.guild.data.QuestProfessionRequirement;
import dev.fulmineo.guild.data.ServerDataManager;
import dev.fulmineo.guild.screen.QuestsScreenHandler;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ServerNetworkManager {
    public static void registerClientReceiver() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Guild.OPEN_QUESTS_SCREEN_PACKET_ID, (server, player, handler, buf, responseSender) -> server.execute(new Runnable(){

            @Override
            public void run() {
                if (Guild.errors.size() > 0) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"lang.guild.errors"), false);
                    for (String error : Guild.errors) {
                        player.method_7353((class_2561)class_2561.method_43470((String)" - ").method_27693(error), false);
                    }
                    player.method_7353((class_2561)class_2561.method_43471((String)"lang.guild.errors_info"), false);
                    return;
                }
                final GuildServerPlayerEntity guildPlayer = (GuildServerPlayerEntity)player;
                if (guildPlayer.getQuestProfessions().size() == 0) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"profession.missing"), false);
                    return;
                }
                player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

                    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
                        List<QuestProfession> professions = guildPlayer.getQuestProfessions();
                        QuestHelper.refreshAvailableQuests(professions, (class_1657)player);
                        class_2487 nbt = QuestHelper.writeMapNbt(new class_2487(), guildPlayer.getAvailableQuests());
                        nbt = QuestHelper.writeNbt(nbt, guildPlayer.getAcceptedQuests());
                        class_2499 professionsInfo = new class_2499();
                        for (QuestProfession profession : professions) {
                            class_2487 tag = new class_2487();
                            tag.method_10582("Name", profession.name);
                            tag.method_10582("Icon", profession.icon);
                            professionsInfo.add((Object)QuestHelper.writeProfessionData(tag, guildPlayer, profession));
                        }
                        nbt.method_10566("Professions", (class_2520)professionsInfo);
                        nbt.method_10569("MaxAcceptedQuests", Guild.CONFIG.getMaxAcceptedQuests());
                        packetByteBuf.method_10794(nbt);
                    }

                    public class_2561 method_5476() {
                        return class_2561.method_43471((String)"screen.guild.quests");
                    }

                    @Nullable
                    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                        return new QuestsScreenHandler(syncId, inv);
                    }
                });
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Guild.ACCEPT_QUEST_PACKET_ID, (server, player, handler, buf, responseSender) -> {
            GuildServerPlayerEntity guildPlayer = (GuildServerPlayerEntity)player;
            List<Quest> acceptedQuests = guildPlayer.getAcceptedQuests();
            if (acceptedQuests.size() < Guild.CONFIG.getMaxAcceptedQuests()) {
                String profession = buf.method_19772();
                int index = buf.readInt();
                Map<String, List<Quest>> availableQuests = guildPlayer.getAvailableQuests();
                List<Quest> quests = availableQuests.get(profession);
                Quest quest = quests.remove(index);
                quest.accept(player.method_37908().method_8510());
                acceptedQuests.add(quest);
            }
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Guild.TRY_COMPLETE_QUEST_PACKET_ID, (server, player, handler, buf, responseSender) -> {
            int newLevel;
            int index = buf.readInt();
            GuildServerPlayerEntity guildPlayer = (GuildServerPlayerEntity)player;
            List<Quest> acceptedQuests = guildPlayer.getAcceptedQuests();
            Quest quest = acceptedQuests.get(index);
            int level = 0;
            String professionName = quest.getProfessionName();
            QuestProfession profession = ServerDataManager.professions.get(professionName);
            List<QuestLevel> levels = ServerDataManager.levels.get(profession.levelsPool);
            if (profession != null) {
                level = QuestHelper.getCurrentLevel(levels, guildPlayer.getProfessionExp(professionName));
            }
            boolean ok = quest.tryComplete(player);
            if (profession != null && level != (newLevel = QuestHelper.getCurrentLevel(levels, guildPlayer.getProfessionExp(professionName)))) {
                player.method_7353((class_2561)class_2561.method_43469((String)"profession.level_up", (Object[])new Object[]{++newLevel, QuestProfession.getTranslatedText(professionName)}), false);
                if (Guild.CONFIG.displayUnlockedPools) {
                    boolean sentDescription = false;
                    for (QuestPoolData task : profession.tasks) {
                        if (task.level == null || task.level.min != newLevel) continue;
                        if (!sentDescription) {
                            sentDescription = true;
                            player.method_7353((class_2561)class_2561.method_43471((String)"profession.unlocked_tasks"), false);
                        }
                        String icon = "";
                        String translationKey = "";
                        switch (task.type) {
                            case "item": {
                                icon = "\u2709";
                                translationKey = ((class_1792)class_7923.field_41178.method_10223(new class_2960(task.name))).method_7876();
                                break;
                            }
                            case "slay": {
                                icon = "\ud83d\udde1";
                                translationKey = ((class_1299)class_7923.field_41177.method_10223(new class_2960(task.name))).method_5882();
                                break;
                            }
                            case "cure": {
                                icon = "\u2719";
                                translationKey = ((class_1299)class_7923.field_41177.method_10223(new class_2960(task.name))).method_5882();
                                break;
                            }
                            case "summon": {
                                icon = "\u2726";
                                translationKey = ((class_1299)class_7923.field_41177.method_10223(new class_2960(task.name))).method_5882();
                            }
                        }
                        player.method_7353((class_2561)class_2561.method_43470((String)(" " + icon + " ")).method_10852((class_2561)class_2561.method_43471((String)translationKey)), false);
                    }
                    sentDescription = false;
                    for (QuestPoolData reward : profession.rewards) {
                        if (reward.level == null || reward.level.min != newLevel) continue;
                        if (!sentDescription) {
                            sentDescription = true;
                            player.method_7353((class_2561)class_2561.method_43471((String)"profession.unlocked_rewards"), false);
                        }
                        player.method_7353((class_2561)class_2561.method_43471((String)((class_1792)class_7923.field_41178.method_10223(new class_2960(reward.name))).method_7876()), false);
                    }
                }
            }
            class_2540 buffer = PacketByteBufs.create();
            buffer.writeBoolean(ok);
            if (ok) {
                acceptedQuests.remove(index);
                if (profession != null) {
                    buffer.method_10794(QuestHelper.writeProfessionData(new class_2487(), guildPlayer, profession));
                }
            }
            responseSender.sendPacket(Guild.TRY_COMPLETE_QUEST_PACKET_ID, buffer);
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Guild.DELETE_ACCEPTED_QUEST_PACKET_ID, (server, player, handler, buf, responseSender) -> ((GuildServerPlayerEntity)player).getAcceptedQuests().remove(buf.readInt()));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Guild.DELETE_AVAILABLE_QUEST_PACKET_ID, (server, player, handler, buf, responseSender) -> ((GuildServerPlayerEntity)player).getAvailableQuests().get(buf.method_19772()).remove(buf.readInt()));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Guild.REQUEST_CLIENT_DATA_ID, (server, player, handler, buf, responseSender) -> ServerNetworkManager.sendDataToClient(player, ServerNetworkManager.getClientDataNbt()));
    }

    public static class_2487 getClientDataNbt() {
        class_2487 nbt = new class_2487();
        class_2487 professionLabels = new class_2487();
        class_2487 professionRequirements = new class_2487();
        for (QuestProfession profession : ServerDataManager.professions.values()) {
            if (profession.label != null) {
                professionLabels.method_10566(profession.name, (class_2520)class_2519.method_23256((String)profession.label));
            }
            if (profession.requirements == null) continue;
            class_2499 requirements = new class_2499();
            for (QuestProfessionRequirement req : profession.requirements) {
                class_2487 requirement = new class_2487();
                if (req.profession != null) {
                    requirement.method_10582("Profession", req.profession);
                }
                if (req.level != null) {
                    class_2487 level = new class_2487();
                    if (req.level.min != null) {
                        level.method_10569("Min", req.level.min.intValue());
                    }
                    if (req.level.max != null) {
                        level.method_10569("Max", req.level.max.intValue());
                    }
                    requirement.method_10566("Level", (class_2520)level);
                }
                requirements.add((Object)requirement);
            }
            professionRequirements.method_10566(profession.name, (class_2520)requirements);
        }
        nbt.method_10566("Labels", (class_2520)professionLabels);
        nbt.method_10566("Requirements", (class_2520)professionRequirements);
        return nbt;
    }

    public static void sendDataToClient(class_3222 player, class_2487 nbt) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10794(nbt);
        ServerPlayNetworking.send((class_3222)player, (class_2960)Guild.TRANSFER_CLIENT_DATA_ID, (class_2540)buf);
    }
}

