/*
 * Decompiled with CFR 0.152.
 */
package dev.fulmineo.guild.mixin;

import com.mojang.authlib.GameProfile;
import dev.fulmineo.guild.data.GuildServerPlayerEntity;
import dev.fulmineo.guild.data.Quest;
import dev.fulmineo.guild.data.QuestHelper;
import dev.fulmineo.guild.data.QuestProfession;
import dev.fulmineo.guild.data.ServerDataManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends class_1657
implements GuildServerPlayerEntity {
    protected List<Quest> acceptedQuests = new ArrayList<Quest>();
    protected Map<String, List<Quest>> availableQuests = new HashMap<String, List<Quest>>();
    protected long lastQuestGenTime = this.method_37908().method_8510();
    protected List<String> professions = new ArrayList<String>();
    protected Map<String, Integer> professionsExp = new HashMap<String, Integer>();

    public ServerPlayerEntityMixin(MinecraftServer server, class_3218 world, GameProfile profile) {
        super((class_1937)world, world.method_43126(), world.method_43127(), profile);
    }

    public boolean method_5874(class_3218 world, class_1309 killedEntity) {
        boolean result = super.method_5874(world, killedEntity);
        QuestHelper.updateQuestSlay(this, killedEntity);
        return result;
    }

    @Override
    public List<Quest> getAcceptedQuests() {
        return this.acceptedQuests;
    }

    @Override
    public void acceptQuest(Quest quest) {
        this.acceptedQuests.add(quest);
    }

    @Override
    public Map<String, List<Quest>> getAvailableQuests() {
        return this.availableQuests;
    }

    @Override
    public void setAvailableQuests(Map<String, List<Quest>> availableQuests) {
        this.availableQuests = availableQuests;
    }

    @Override
    public void addAvailableQuest(String professionName, Quest quest) {
        List<Quest> quests = new ArrayList<Quest>();
        if (this.availableQuests.containsKey(professionName)) {
            quests = this.availableQuests.get(professionName);
        }
        quests.add(quest);
        this.availableQuests.put(professionName, quests);
    }

    @Override
    public long getLastQuestGenTime() {
        return this.lastQuestGenTime;
    }

    @Override
    public void setLastQuestGenTime(long time) {
        this.lastQuestGenTime = time;
    }

    @Override
    public List<String> getProfessions() {
        return this.professions;
    }

    @Override
    public List<QuestProfession> getQuestProfessions() {
        ArrayList<QuestProfession> professions = new ArrayList<QuestProfession>();
        Iterator<String> iterator = this.professions.iterator();
        while (iterator.hasNext()) {
            String professionName = iterator.next();
            QuestProfession profession = ServerDataManager.professions.get(professionName);
            if (profession == null) {
                iterator.remove();
                continue;
            }
            professions.add(profession);
        }
        return professions;
    }

    @Override
    public boolean addQuestProfession(String professionName) {
        boolean found = this.professions.contains(professionName);
        if (!found) {
            this.professions.add(professionName);
        }
        return !found;
    }

    @Override
    public boolean removeQuestProfession(String professionName) {
        boolean found = this.professions.contains(professionName);
        if (found) {
            this.professions.remove(professionName);
        }
        return found;
    }

    @Override
    public Map<String, Integer> getProfessionExp() {
        return this.professionsExp;
    }

    @Override
    public int getProfessionExp(String professionName) {
        Integer val = this.professionsExp.get(professionName);
        return val != null ? val : 0;
    }

    @Override
    public void setProfessionExp(String professionName, int exp) {
        this.professionsExp.put(professionName, exp);
    }

    @Override
    public void resetQuestsAndProfessions() {
        this.clearQuests();
        this.professions.clear();
        this.professionsExp.clear();
    }

    @Override
    public void clearQuests() {
        this.acceptedQuests.clear();
        this.availableQuests.clear();
    }

    @Inject(at={@At(value="TAIL")}, method={"copyFrom(Lnet/minecraft/server/network/ServerPlayerEntity;Z)V"})
    public void copyFromMixin(class_3222 oldPlayer, boolean alive, CallbackInfo info) {
        GuildServerPlayerEntity guildPlayer = (GuildServerPlayerEntity)oldPlayer;
        this.lastQuestGenTime = guildPlayer.getLastQuestGenTime();
        this.acceptedQuests = guildPlayer.getAcceptedQuests();
        this.availableQuests = guildPlayer.getAvailableQuests();
        this.professions = guildPlayer.getProfessions();
        this.professionsExp = guildPlayer.getProfessionExp();
    }

    @Inject(at={@At(value="TAIL")}, method={"writeCustomDataToNbt(Lnet/minecraft/nbt/NbtCompound;)V"})
    public void writeCustomDataToNbtMixin(class_2487 nbt, CallbackInfo info) {
        QuestHelper.writeMapNbt(nbt, this.availableQuests);
        QuestHelper.writeNbt(nbt, this.acceptedQuests);
        class_2499 professions = new class_2499();
        for (String profession : this.professions) {
            professions.add((Object)class_2519.method_23256((String)profession));
        }
        nbt.method_10566("Professions", (class_2520)professions);
        class_2487 professionsExp = new class_2487();
        Iterator<Map.Entry<String, Integer>> iterator = this.professionsExp.entrySet().iterator();
        while (iterator.hasNext()) {
            Integer val;
            Map.Entry<String, Integer> entry;
            professionsExp.method_10569(entry.getKey(), (val = (entry = iterator.next()).getValue()) != null ? val : 0);
        }
        nbt.method_10566("ProfessionsExp", (class_2520)professionsExp);
    }

    @Inject(at={@At(value="TAIL")}, method={"readCustomDataFromNbt(Lnet/minecraft/nbt/NbtCompound;)V"})
    public void readCustomDataFromNbtMixin(class_2487 nbt, CallbackInfo info) {
        this.availableQuests = QuestHelper.fromMapNbt(nbt);
        this.acceptedQuests = QuestHelper.fromNbt(nbt);
        this.professions.clear();
        this.professionsExp.clear();
        class_2499 professions = nbt.method_10554("Professions", 8);
        for (class_2520 professionName : professions) {
            class_2519 name = (class_2519)professionName;
            this.professions.add(name.method_10714());
        }
        class_2487 professionsExp = nbt.method_10562("ProfessionsExp");
        for (String key : professionsExp.method_10541()) {
            this.professionsExp.put(key, professionsExp.method_10550(key));
        }
    }
}

