/*
 * Decompiled with CFR 0.152.
 */
package dev.fulmineo.guild.init;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.fulmineo.guild.Guild;
import dev.fulmineo.guild.data.GuildServerPlayerEntity;
import dev.fulmineo.guild.data.Quest;
import dev.fulmineo.guild.data.QuestHelper;
import dev.fulmineo.guild.data.QuestProfession;
import dev.fulmineo.guild.data.ServerDataManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class CommandInit {
    public static ProfessionsSuggestionProvider PROFESSION_SUGGESTION_PROVIDER = new ProfessionsSuggestionProvider();

    public static void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated, environment) -> {
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"guild").then(class_2170.method_9247((String)"reset").executes(context -> {
                class_2168 source = (class_2168)context.getSource();
                if (source != null) {
                    class_3222 player = source.method_9207();
                    ((GuildServerPlayerEntity)player).resetQuestsAndProfessions();
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.guild.reset.success"), false);
                }
                return 1;
            })));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"guild").then(class_2170.method_9247((String)"clear").executes(context -> {
                class_2168 source = (class_2168)context.getSource();
                if (source != null) {
                    class_3222 player = source.method_9207();
                    ((GuildServerPlayerEntity)player).clearQuests();
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.guild.clear.success"), false);
                }
                return 1;
            })));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"guild").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"licence").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"profession", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)PROFESSION_SUGGESTION_PROVIDER).executes(context -> {
                class_2168 source = (class_2168)context.getSource();
                if (source != null) {
                    class_3222 player = source.method_9207();
                    String professionName = StringArgumentType.getString((CommandContext)context, (String)"profession");
                    QuestProfession profession = ServerDataManager.professions.get(professionName);
                    if (profession == null) {
                        source.method_9226(() -> class_2561.method_43469((String)"command.guild.licence.invalid_profession", (Object[])new Object[]{professionName}), false);
                    } else {
                        class_1799 stack = new class_1799((class_1935)Guild.QUEST_PROFESSION_LICENCE_ITEM);
                        class_2487 nbt = stack.method_7948();
                        nbt.method_10582("Profession", professionName);
                        stack.method_7980(nbt);
                        if (!player.method_7270(stack)) {
                            player.method_7328(stack, false);
                        }
                    }
                }
                return 1;
            }))));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"guild").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"quest").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"profession", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)PROFESSION_SUGGESTION_PROVIDER).executes(context -> {
                class_2168 source = (class_2168)context.getSource();
                if (source != null) {
                    class_3222 player = source.method_9207();
                    String professionName = StringArgumentType.getString((CommandContext)context, (String)"profession");
                    QuestProfession profession = ServerDataManager.professions.get(professionName);
                    if (profession == null) {
                        source.method_9226(() -> class_2561.method_43469((String)"command.guild.licence.invalid_profession", (Object[])new Object[]{professionName}), false);
                    } else {
                        List<Quest> professionQuests = ((GuildServerPlayerEntity)player).getAvailableQuests().get(professionName);
                        if (professionQuests == null || professionQuests.size() < Guild.CONFIG.getMaxQuestsPerProfession()) {
                            ArrayList<QuestProfession> availableProfessions = new ArrayList<QuestProfession>();
                            availableProfessions.add(profession);
                            QuestHelper.generateQuests((class_1657)player, availableProfessions, 1);
                        }
                    }
                }
                return 1;
            }))));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"guild").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"exp").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"profession", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)PROFESSION_SUGGESTION_PROVIDER).then(class_2170.method_9244((String)"exp", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
                class_2168 source = (class_2168)context.getSource();
                if (source != null) {
                    class_3222 player = source.method_9207();
                    String professionName = StringArgumentType.getString((CommandContext)context, (String)"profession");
                    QuestProfession profession = ServerDataManager.professions.get(professionName);
                    if (profession == null) {
                        source.method_9226(() -> class_2561.method_43469((String)"command.guild.licence.invalid_profession", (Object[])new Object[]{professionName}), false);
                    } else {
                        int exp = IntegerArgumentType.getInteger((CommandContext)context, (String)"exp");
                        ((GuildServerPlayerEntity)player).setProfessionExp(professionName, exp);
                    }
                }
                return 1;
            })))));
        });
    }

    public static class ProfessionsSuggestionProvider
    implements SuggestionProvider<class_2168> {
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
            for (String professionName : ServerDataManager.professions.keySet()) {
                builder.suggest("\"" + professionName + "\"");
            }
            return builder.buildFuture();
        }
    }
}

