/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.util;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.server.DeactivateCamerasInHandC2SP;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CameraInHand {
    public static final CameraInHand EMPTY = new CameraInHand(null, null);
    @Nullable
    private ItemAndStack<CameraItem> camera;
    @Nullable
    private class_1268 hand;

    public CameraInHand(@Nullable ItemAndStack<CameraItem> camera, @Nullable class_1268 hand) {
        this.camera = camera;
        this.hand = hand;
    }

    public CameraInHand(@NotNull class_1657 player) {
        for (class_1268 hand : class_1268.values()) {
            class_1799 itemInHand = player.method_5998(hand);
            if (!(itemInHand.method_7909() instanceof CameraItem)) continue;
            this.camera = new ItemAndStack(itemInHand);
            this.hand = hand;
            return;
        }
    }

    public static void deactivate(class_1657 player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        for (class_1268 hand : class_1268.values()) {
            class_1799 itemInHand = player.method_5998(hand);
            class_1792 class_17922 = itemInHand.method_7909();
            if (!(class_17922 instanceof CameraItem)) continue;
            CameraItem cameraItem = (CameraItem)class_17922;
            cameraItem.deactivate(player, itemInHand);
        }
        if (player.method_37908().field_9236) {
            Packets.sendToServer(new DeactivateCamerasInHandC2SP());
        }
    }

    @Nullable
    public static class_1268 getActiveHand(class_1657 player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player should not be null.");
        for (class_1268 hand : class_1268.values()) {
            CameraItem cameraItem;
            class_1799 itemInHand = player.method_5998(hand);
            class_1792 class_17922 = itemInHand.method_7909();
            if (!(class_17922 instanceof CameraItem) || !(cameraItem = (CameraItem)class_17922).isActive(itemInHand)) continue;
            return hand;
        }
        return null;
    }

    public static boolean isActive(class_1657 player) {
        return CameraInHand.getActiveHand(player) != null;
    }

    public static CameraInHand getActive(class_1657 player) {
        @Nullable class_1268 activeHand = CameraInHand.getActiveHand(player);
        if (activeHand == null) {
            return EMPTY;
        }
        return new CameraInHand(new ItemAndStack<CameraItem>(player.method_5998(activeHand)), activeHand);
    }

    public boolean isEmpty() {
        return this.equals(EMPTY) || this.camera == null || this.hand == null;
    }

    public ItemAndStack<CameraItem> getCamera() {
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (Object)"getCamera should not be called before checking isEmpty first.");
        return this.camera;
    }

    public CameraItem getItem() {
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (Object)"getItem should not be called before checking isEmpty first.");
        Preconditions.checkState((this.camera != null ? 1 : 0) != 0, (Object)"getItem should not be called before checking isEmpty first.");
        return this.camera.getItem();
    }

    public class_1799 getStack() {
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (Object)"getStack should not be called before checking isEmpty first.");
        Preconditions.checkState((this.camera != null ? 1 : 0) != 0, (Object)"getStack should not be called before checking isEmpty first.");
        return this.camera.getStack();
    }

    public class_1268 getHand() {
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (Object)"getHand should not be called before checking isEmpty first.");
        return this.hand;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CameraInHand that = (CameraInHand)o;
        return Objects.equals(this.camera, that.camera) && this.hand == that.hand;
    }

    public int hashCode() {
        return Objects.hash(this.camera, this.hand);
    }

    public String toString() {
        return "CameraInHand{camera=" + (this.camera != null ? this.camera.getStack() : "null") + ", hand=" + this.hand + "}";
    }
}

