/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.recipe.AbstractNbtTransferringRecipe;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_1843;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;

public class PhotographCopyingRecipe
extends AbstractNbtTransferringRecipe {
    public PhotographCopyingRecipe(class_2960 id, class_1856 transferIngredient, class_2371<class_1856> ingredients, class_1799 result) {
        super(id, transferIngredient, ingredients, result);
    }

    @NotNull
    public class_1865<?> method_8119() {
        return Exposure.RecipeSerializers.PHOTOGRAPH_CLONING.get();
    }

    @Override
    @NotNull
    public class_1799 transferNbt(class_1799 photographStack, class_1799 recipeResultStack) {
        if (photographStack.method_7909() instanceof PhotographItem && photographStack.method_7985() && class_1843.method_8052((class_1799)photographStack) < 2) {
            class_1799 result = super.transferNbt(photographStack, recipeResultStack);
            class_2487 resultTag = result.method_7948();
            resultTag.method_10569("generation", Math.min(class_1843.method_8052((class_1799)result) + 1, 2));
            return result;
        }
        return class_1799.field_8037;
    }

    @NotNull
    public class_2371<class_1799> getRemainingItems(class_8566 pInv) {
        class_2371 nonnulllist = class_2371.method_10213((int)pInv.method_5439(), (Object)class_1799.field_8037);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            class_1799 itemstack = pInv.method_5438(i);
            if (itemstack.method_7909().method_7857()) {
                nonnulllist.set(i, (Object)new class_1799((class_1935)Objects.requireNonNull(itemstack.method_7909().method_7858())));
                continue;
            }
            if (!(itemstack.method_7909() instanceof PhotographItem)) continue;
            class_1799 itemstack1 = itemstack.method_7972();
            itemstack1.method_7939(1);
            nonnulllist.set(i, (Object)itemstack1);
        }
        return nonnulllist;
    }

    public static class Serializer
    implements class_1865<PhotographCopyingRecipe> {
        @NotNull
        public PhotographCopyingRecipe fromJson(class_2960 recipeId, JsonObject serializedRecipe) {
            class_1856 photographIngredient = class_1856.method_52177((JsonElement)class_3518.method_52226((JsonObject)serializedRecipe, (String)"photograph"));
            class_2371<class_1856> ingredients = this.getIngredients(class_3518.method_15261((JsonObject)serializedRecipe, (String)"ingredients"));
            class_1799 result = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)serializedRecipe, (String)"result"));
            if (photographIngredient.method_8103()) {
                throw new JsonParseException("Recipe should have 'photograph' ingredient.");
            }
            return new PhotographCopyingRecipe(recipeId, photographIngredient, ingredients, result);
        }

        @NotNull
        public PhotographCopyingRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            class_1856 transferredIngredient = class_1856.method_8086((class_2540)buffer);
            int ingredientsCount = buffer.method_10816();
            class_2371 ingredients = class_2371.method_10213((int)ingredientsCount, (Object)class_1856.field_9017);
            ingredients.replaceAll(ignored -> class_1856.method_8086((class_2540)buffer));
            class_1799 result = buffer.method_10819();
            return new PhotographCopyingRecipe(recipeId, transferredIngredient, (class_2371<class_1856>)ingredients, result);
        }

        public void toNetwork(class_2540 buffer, PhotographCopyingRecipe recipe) {
            recipe.getTransferIngredient().method_8088(buffer);
            buffer.method_10804(recipe.method_8117().size());
            for (class_1856 ingredient : recipe.method_8117()) {
                ingredient.method_8088(buffer);
            }
            buffer.method_10793(recipe.getResult());
        }

        private class_2371<class_1856> getIngredients(JsonArray jsonArray) {
            class_2371 ingredients = class_2371.method_10211();
            for (int i = 0; i < jsonArray.size(); ++i) {
                class_1856 ingredient = class_1856.method_52177((JsonElement)jsonArray.get(i));
                if (ingredient.method_8103()) continue;
                ingredients.add((Object)ingredient);
            }
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for a recipe.");
            }
            if (ingredients.size() > 9) {
                throw new JsonParseException("Too many ingredients for a recipe. The maximum is 9.");
            }
            return ingredients;
        }
    }
}

