/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.packet.server;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure.network.PacketDirection;
import io.github.mortuusars.exposure.network.packet.IPacket;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public record QueryExposureDataC2SP(String id) implements IPacket
{
    public static final class_2960 ID = Exposure.resource("query_exposure_data");

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public class_2540 toBuffer(class_2540 buffer) {
        buffer.method_10814(this.id);
        return buffer;
    }

    public static QueryExposureDataC2SP fromBuffer(class_2540 buffer) {
        return new QueryExposureDataC2SP(buffer.method_19772());
    }

    @Override
    public boolean handle(PacketDirection direction, @Nullable class_1657 player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Cannot handle QueryExposureDataPacket: Player was null");
        Optional<ExposureSavedData> exposureSavedData = ExposureServer.getExposureStorage().getOrQuery(this.id);
        if (exposureSavedData.isEmpty()) {
            LogUtils.getLogger().error("Cannot get exposure data with an id '" + this.id + "'. Result is null.");
        } else {
            ExposureServer.getExposureSender().sendTo(player, this.id, exposureSavedData.get());
        }
        return true;
    }
}

