/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.item;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.entity.PhotographEntity;
import io.github.mortuusars.exposure.gui.ClientGUI;
import io.github.mortuusars.exposure.gui.component.PhotographTooltip;
import io.github.mortuusars.exposure.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3544;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhotographItem
extends class_1792 {
    public PhotographItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Nullable
    public Either<String, class_2960> getIdOrTexture(class_1799 stack) {
        if (stack.method_7969() == null) {
            return null;
        }
        String id = stack.method_7969().method_10558("Id");
        if (!id.isEmpty()) {
            return Either.left((Object)id);
        }
        String resource = stack.method_7969().method_10558("Texture");
        if (!resource.isEmpty()) {
            return Either.right((Object)new class_2960(resource));
        }
        return null;
    }

    public void setId(class_1799 stack, @NotNull String id) {
        Preconditions.checkState((!class_3544.method_15438((String)id) ? 1 : 0) != 0, (Object)"'id' cannot be null or empty.");
        stack.method_7948().method_10582("Id", id);
    }

    public void setTexture(class_1799 stack, @NotNull class_2960 resourceLocation) {
        stack.method_7948().method_10582("Texture", resourceLocation.toString());
    }

    @NotNull
    public Optional<class_5632> method_32346(@NotNull class_1799 stack) {
        return this.getIdOrTexture(stack) != null ? Optional.of(new PhotographTooltip(stack)) : Optional.empty();
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 level, @NotNull List<class_2561> tooltipComponents, @NotNull class_1836 isAdvanced) {
        if (stack.method_7969() != null) {
            Either<String, class_2960> idOrTexture;
            String photographerName;
            int generation = stack.method_7969().method_10550("generation");
            if (generation > 0) {
                tooltipComponents.add((class_2561)class_2561.method_43471((String)("item.exposure.photograph.generation." + generation)).method_27692(class_124.field_1080));
            }
            if (!(photographerName = stack.method_7969().method_10558("Photographer")).isEmpty() && ((Boolean)Config.Client.PHOTOGRAPH_SHOW_PHOTOGRAPHER_IN_TOOLTIP.get()).booleanValue()) {
                tooltipComponents.add((class_2561)class_2561.method_43469((String)"item.exposure.photograph.photographer_tooltip", (Object[])new Object[]{class_2561.method_43470((String)photographerName).method_27692(class_124.field_1068)}).method_27692(class_124.field_1080));
            }
            if (generation < 2 && !PlatformHelper.isModLoaded("jei") && ((Boolean)Config.Client.RECIPE_TOOLTIPS_WITHOUT_JEI.get()).booleanValue()) {
                ClientGUI.addPhotographCopyingTooltip(stack, level, tooltipComponents, isAdvanced);
            }
            if (isAdvanced.method_8035() && (idOrTexture = this.getIdOrTexture(stack)) != null) {
                String text = (String)idOrTexture.map(id -> "Exposure Id: " + id, texture -> "Texture: " + texture);
                tooltipComponents.add((class_2561)class_2561.method_43470((String)text).method_27692(class_124.field_1063));
            }
        }
    }

    @NotNull
    public class_1269 method_7884(class_1838 context) {
        class_2338 clickedPos = context.method_8037();
        class_2350 direction = context.method_8038();
        class_2338 resultPos = clickedPos.method_10093(direction);
        class_1657 player = context.method_8036();
        class_1799 itemStack = context.method_8041();
        if (player == null || player.method_37908().method_31606(resultPos) || !player.method_7343(resultPos, direction, itemStack)) {
            return class_1269.field_5814;
        }
        class_1937 level = context.method_8045();
        PhotographEntity photographEntity = new PhotographEntity(level, resultPos, direction, itemStack.method_7972());
        if (photographEntity.method_6888()) {
            if (!level.field_9236) {
                photographEntity.method_6894();
                level.method_43275((class_1297)player, class_5712.field_28738, photographEntity.method_19538());
                level.method_8649((class_1297)photographEntity);
            }
            itemStack.method_7934(1);
            return class_1269.method_29236((boolean)level.field_9236);
        }
        return class_1269.field_5814;
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, class_1657 player, @NotNull class_1268 hand) {
        class_1799 itemInHand = player.method_5998(hand);
        if (this.getIdOrTexture(itemInHand) == null) {
            LogUtils.getLogger().warn("No Id or Texture is defined. - " + itemInHand);
        }
        if (level.field_9236) {
            ClientGUI.openPhotographScreen(List.of(new ItemAndStack(itemInHand)));
            player.method_5783(Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), 0.6f, 1.1f);
        }
        return class_1271.method_22427((Object)itemInHand);
    }

    public boolean method_31566(@NotNull class_1799 stack, @NotNull class_1799 other, @NotNull class_1735 slot, @NotNull class_5536 action, @NotNull class_1657 player, @NotNull class_5630 access) {
        if (action != class_5536.field_27014) {
            return false;
        }
        if (other.method_7909() instanceof PhotographItem) {
            StackedPhotographsItem stackedPhotographsItem = Exposure.Items.STACKED_PHOTOGRAPHS.get();
            class_1799 stackedPhotographsStack = new class_1799((class_1935)stackedPhotographsItem);
            stackedPhotographsItem.addPhotographOnTop(stackedPhotographsStack, stack);
            stackedPhotographsItem.addPhotographOnTop(stackedPhotographsStack, other);
            slot.method_7673(stackedPhotographsStack);
            access.method_32332(class_1799.field_8037);
            StackedPhotographsItem.playAddSoundClientside(player);
            return true;
        }
        return false;
    }
}

