/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.item;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.gui.ClientGUI;
import io.github.mortuusars.exposure.item.IFilmItem;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilmRollItem
extends class_1792
implements IFilmItem {
    private final FilmType filmType;
    private final int barColor;

    public FilmRollItem(FilmType filmType, int barColor, class_1792.class_1793 properties) {
        super(properties);
        this.filmType = filmType;
        this.barColor = barColor;
    }

    @Override
    public FilmType getType() {
        return this.filmType;
    }

    public boolean method_31567(@NotNull class_1799 stack) {
        return this.getExposedFramesCount(stack) > 0;
    }

    public int method_31569(@NotNull class_1799 stack) {
        return Math.min(1 + 12 * this.getExposedFramesCount(stack) / this.getMaxFrameCount(stack), 13);
    }

    public int method_31571(@NotNull class_1799 stack) {
        return this.barColor;
    }

    public void addFrame(class_1799 filmStack, class_2487 frame) {
        class_2499 listTag;
        class_2487 tag = filmStack.method_7948();
        if (!tag.method_10573("Frames", 9)) {
            tag.method_10566("Frames", (class_2520)new class_2499());
        }
        if ((listTag = tag.method_10554("Frames", 10)).size() >= this.getMaxFrameCount(filmStack)) {
            throw new IllegalStateException("Cannot add more frames than film could fit. Size: " + listTag.size());
        }
        listTag.add((Object)frame);
        tag.method_10566("Frames", (class_2520)listTag);
    }

    public boolean canAddFrame(class_1799 filmStack) {
        if (!filmStack.method_7985() || !filmStack.method_7948().method_10573("Frames", 9)) {
            return true;
        }
        return filmStack.method_7948().method_10554("Frames", 10).size() < this.getMaxFrameCount(filmStack);
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 level, @NotNull List<class_2561> tooltipComponents, @NotNull class_1836 isAdvanced) {
        int developingStep;
        int frameSize;
        int exposedFrames = this.getExposedFramesCount(stack);
        if (exposedFrames > 0) {
            int totalFrames = this.getMaxFrameCount(stack);
            tooltipComponents.add((class_2561)class_2561.method_43469((String)"item.exposure.film_roll.tooltip.frame_count", (Object[])new Object[]{exposedFrames, totalFrames}).method_27692(class_124.field_1080));
        }
        if ((frameSize = this.getFrameSize(stack)) != this.getDefaultFrameSize()) {
            tooltipComponents.add((class_2561)class_2561.method_43469((String)"item.exposure.film_roll.tooltip.frame_size", (Object[])new Object[]{class_2561.method_43470((String)String.format("%.1f", Float.valueOf((float)frameSize / 10.0f)))}).method_27692(class_124.field_1080));
        }
        int n = developingStep = stack.method_7969() != null ? stack.method_7969().method_10550("CurrentDevelopingStep") : 0;
        if (((Boolean)Config.Common.CREATE_SPOUT_DEVELOPING_ENABLED.get()).booleanValue() && developingStep > 0) {
            int i;
            List totalSteps = (List)Config.Common.spoutDevelopingSequence(this.getType()).get();
            class_5250 stepsComponent = class_2561.method_43470((String)"");
            for (i = 0; i < developingStep; ++i) {
                stepsComponent.method_10852((class_2561)class_2561.method_43470((String)"I").method_27692(class_124.field_1065));
            }
            for (i = developingStep; i < totalSteps.size(); ++i) {
                stepsComponent.method_10852((class_2561)class_2561.method_43470((String)"I").method_27692(class_124.field_1063));
            }
            tooltipComponents.add((class_2561)class_2561.method_43469((String)"item.exposure.film_roll.tooltip.developing_step", (Object[])new Object[]{stepsComponent}).method_27692(class_124.field_1065));
        }
        if (exposedFrames > 0 && !PlatformHelper.isModLoaded("jei") && ((Boolean)Config.Client.RECIPE_TOOLTIPS_WITHOUT_JEI.get()).booleanValue()) {
            ClientGUI.addFilmRollDevelopingTooltip(stack, level, tooltipComponents, isAdvanced);
        }
    }
}

