/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.item;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.camera.capture.processing.FloydDither;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.client.WaitForExposureChangeS2CP;
import io.github.mortuusars.exposure.util.ColorChannel;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3620;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChromaticSheetItem
extends class_1792 {
    public static final String EXPOSURES_TAG = "Exposures";

    public ChromaticSheetItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public List<class_2487> getExposures(class_1799 stack) {
        if (stack.method_7969() == null || !stack.method_7969().method_10573(EXPOSURES_TAG, 9)) {
            return Collections.emptyList();
        }
        class_2499 channelsList = stack.method_7969().method_10554(EXPOSURES_TAG, 10);
        return channelsList.stream().map(t -> (class_2487)t).collect(Collectors.toList());
    }

    public void addExposure(class_1799 stack, class_2487 frame) {
        class_2499 channelsList = this.getOrCreateExposuresTag(stack);
        channelsList.add((Object)frame);
        stack.method_7948().method_10566(EXPOSURES_TAG, (class_2520)channelsList);
    }

    private class_2499 getOrCreateExposuresTag(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        class_2499 list = tag.method_10554(EXPOSURES_TAG, 10);
        tag.method_10566(EXPOSURES_TAG, (class_2520)list);
        return list;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        List<class_2487> exposures = this.getExposures(stack);
        if (!exposures.isEmpty()) {
            class_5250 component = class_2561.method_43471((String)"gui.exposure.channel.red").method_27696(class_2583.field_24360.method_36139(ColorChannel.RED.getRepresentationColor()));
            if (exposures.size() >= 2) {
                component.method_10852((class_2561)class_2561.method_43471((String)"gui.exposure.channel.separator").method_27692(class_124.field_1080));
                component.method_10852((class_2561)class_2561.method_43471((String)"gui.exposure.channel.green").method_27696(class_2583.field_24360.method_36139(ColorChannel.GREEN.getRepresentationColor())));
            }
            if (exposures.size() >= 3) {
                component.method_10852((class_2561)class_2561.method_43471((String)"gui.exposure.channel.separator").method_27692(class_124.field_1080));
                component.method_10852((class_2561)class_2561.method_43471((String)"gui.exposure.channel.blue").method_27696(class_2583.field_24360.method_36139(ColorChannel.BLUE.getRepresentationColor())));
            }
            tooltipComponents.add((class_2561)component);
            if (exposures.size() >= 3) {
                tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.exposure.chromatic_sheet.use_tooltip").method_27692(class_124.field_1080));
            }
        }
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1799 stack = player.method_5998(usedHand);
        if (!level.field_9236 && this.getExposures(stack).size() >= 3) {
            class_1799 result = this.finalize(level, stack);
            player.method_6122(usedHand, result);
            return class_1271.method_22427((Object)result);
        }
        return super.method_7836(level, player, usedHand);
    }

    public class_1799 finalize(@NotNull class_1937 level, class_1799 stack) {
        Preconditions.checkState((!level.field_9236 ? 1 : 0) != 0, (Object)"Can only finalize server-side.");
        List<class_2487> exposures = this.getExposures(stack);
        Preconditions.checkState((exposures.size() >= 3 ? 1 : 0) != 0, (Object)("Finalizing Chromatic Fragment requires 3 exposures. " + stack));
        class_2487 redTag = exposures.get(0);
        String redId = redTag.method_10558("Id");
        Optional<ExposureSavedData> redOpt = ExposureServer.getExposureStorage().getOrQuery(redId);
        if (redOpt.isEmpty()) {
            LogUtils.getLogger().error("Cannot create Chromatic Photograph: Red channel exposure '" + redId + "' is not found.");
            return stack;
        }
        class_2487 greenTag = exposures.get(1);
        String greenId = greenTag.method_10558("Id");
        Optional<ExposureSavedData> greenOpt = ExposureServer.getExposureStorage().getOrQuery(greenId);
        if (greenOpt.isEmpty()) {
            LogUtils.getLogger().error("Cannot create Chromatic Photograph: Green channel exposure '" + greenId + "' is not found.");
            return stack;
        }
        class_2487 blueTag = exposures.get(2);
        String blueId = blueTag.method_10558("Id");
        Optional<ExposureSavedData> blueOpt = ExposureServer.getExposureStorage().getOrQuery(blueId);
        if (blueOpt.isEmpty()) {
            LogUtils.getLogger().error("Cannot create Chromatic Photograph: Blue channel exposure '" + blueId + "' is not found.");
            return stack;
        }
        int underscoreIndex = redId.lastIndexOf("_");
        String name = underscoreIndex != -1 ? redId.substring(0, underscoreIndex) : Integer.toString(redId.hashCode());
        String id = String.format("%s_chromatic_%s", name, level.method_8510());
        class_1799 photograph = new class_1799((class_1935)Exposure.Items.PHOTOGRAPH.get());
        class_2487 tag = redTag.method_10553();
        tag = tag.method_10543(greenTag);
        tag = tag.method_10543(blueTag);
        tag.method_10551("ChromaticChannel");
        tag.method_10582("Id", id);
        tag.method_10556("Chromatic", true);
        tag.method_10582("RedChannel", redId);
        tag.method_10582("GreenChannel", greenId);
        tag.method_10582("BlueChannel", blueId);
        tag.method_10582("Type", FilmType.COLOR.method_15434());
        photograph.method_7980(tag);
        Packets.sendToAllClients(new WaitForExposureChangeS2CP(id));
        new Thread(() -> {
            try {
                this.processAndSaveTrichrome((ExposureSavedData)((Object)((Object)redOpt.get())), (ExposureSavedData)((Object)((Object)greenOpt.get())), (ExposureSavedData)((Object)((Object)blueOpt.get())), id);
            }
            catch (Exception e) {
                LogUtils.getLogger().error("Cannot process and save Chromatic Photograph: " + e);
            }
        }).start();
        return photograph;
    }

    protected void processAndSaveTrichrome(ExposureSavedData red, ExposureSavedData green, ExposureSavedData blue, String id) {
        int width = Math.min(red.getWidth(), Math.min(green.getWidth(), blue.getWidth()));
        int height = Math.min(red.getHeight(), Math.min(green.getHeight(), blue.getHeight()));
        if (width <= 0 || height <= 0) {
            LogUtils.getLogger().error("Cannot create Chromatic Photograph: Width and Height should be larger than 0. Width '{}', Height: '{}'.", (Object)width, (Object)height);
            return;
        }
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int r = class_3620.method_38480((int)red.getPixel(x, y)) >> 16 & 0xFF;
                int g = class_3620.method_38480((int)green.getPixel(x, y)) >> 8 & 0xFF;
                int b = class_3620.method_38480((int)blue.getPixel(x, y)) & 0xFF;
                int rgb = 0xFF000000 | r << 16 | g << 8 | b;
                image.setRGB(x, y, rgb);
            }
        }
        byte[] mapColorPixels = FloydDither.ditherWithMapColors(image);
        class_2487 properties = new class_2487();
        properties.method_10582("Type", FilmType.COLOR.method_15434());
        long unixTime = System.currentTimeMillis() / 1000L;
        properties.method_10544("Timestamp", unixTime);
        ExposureSavedData resultData = new ExposureSavedData(image.getWidth(), image.getHeight(), mapColorPixels, properties);
        ExposureServer.getExposureStorage().put(id, resultData);
        ExposureServer.getExposureStorage().sendExposureChanged(id);
    }
}

