/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.integration.jei;

import com.google.common.collect.ImmutableList;
import dev.architectury.injectables.annotations.ExpectPlatform;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.gui.screen.album.AlbumScreen;
import io.github.mortuusars.exposure.integration.jei.category.PhotographPrintingCategory;
import io.github.mortuusars.exposure.integration.jei.category.PhotographStackingCategory;
import io.github.mortuusars.exposure.integration.jei.fabric.ExposureJeiPluginImpl;
import io.github.mortuusars.exposure.integration.jei.recipe.NbtTransferringShapelessExtension;
import io.github.mortuusars.exposure.integration.jei.recipe.PhotographPrintingJeiRecipe;
import io.github.mortuusars.exposure.integration.jei.recipe.PhotographStackingJeiRecipe;
import io.github.mortuusars.exposure.recipe.FilmDevelopingRecipe;
import io.github.mortuusars.exposure.recipe.PhotographAgingRecipe;
import io.github.mortuusars.exposure.recipe.PhotographCopyingRecipe;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_768;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class ExposureJeiPlugin
implements IModPlugin {
    public static final RecipeType<PhotographPrintingJeiRecipe> PHOTOGRAPH_PRINTING_RECIPE_TYPE = RecipeType.create((String)"exposure", (String)"photograph_printing", PhotographPrintingJeiRecipe.class);
    public static final RecipeType<PhotographStackingJeiRecipe> PHOTOGRAPH_STACKING_RECIPE_TYPE = RecipeType.create((String)"exposure", (String)"photograph_stacking", PhotographStackingJeiRecipe.class);
    private static final class_2960 ID = Exposure.resource("jei_plugin");

    @NotNull
    public class_2960 getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new PhotographPrintingCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new PhotographStackingCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new class_1799((class_1935)Exposure.Items.LIGHTROOM.get()), new RecipeType[]{PHOTOGRAPH_PRINTING_RECIPE_TYPE});
        registration.addRecipeCatalyst(new class_1799((class_1935)Exposure.Items.STACKED_PHOTOGRAPHS.get()), new RecipeType[]{PHOTOGRAPH_STACKING_RECIPE_TYPE});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        registration.addRecipes(PHOTOGRAPH_PRINTING_RECIPE_TYPE, (List)ImmutableList.of((Object)new PhotographPrintingJeiRecipe(FilmType.BLACK_AND_WHITE), (Object)new PhotographPrintingJeiRecipe(FilmType.COLOR)));
        registration.addRecipes(PHOTOGRAPH_STACKING_RECIPE_TYPE, (List)ImmutableList.of((Object)new PhotographStackingJeiRecipe(0), (Object)new PhotographStackingJeiRecipe(1)));
        if (PlatformHelper.isModLoaded("create")) {
            ExposureJeiPlugin.addSequencedDevelopingRecipes(registration);
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addSequencedDevelopingRecipes(@NotNull IRecipeRegistration registration) {
        ExposureJeiPluginImpl.addSequencedDevelopingRecipes(registration);
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addCategoryExtension(FilmDevelopingRecipe.class, NbtTransferringShapelessExtension::new);
        registration.getCraftingCategory().addCategoryExtension(PhotographCopyingRecipe.class, NbtTransferringShapelessExtension::new);
        registration.getCraftingCategory().addCategoryExtension(PhotographAgingRecipe.class, NbtTransferringShapelessExtension::new);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(AlbumScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<AlbumScreen>(){

            @NotNull
            public List<class_768> getGuiExtraAreas(@NotNull AlbumScreen containerScreen) {
                return List.of(new class_768(0, 0, class_310.method_1551().method_22683().method_4486(), class_310.method_1551().method_22683().method_4502()));
            }
        });
    }
}

