/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure.gui.screen.PhotographScreen;
import io.github.mortuusars.exposure.gui.screen.ZoomableScreen;
import io.github.mortuusars.exposure.gui.screen.element.Pager;
import io.github.mortuusars.exposure.render.ExposureImage;
import io.github.mortuusars.exposure.render.ExposureTexture;
import io.github.mortuusars.exposure.render.modifiers.ExposurePixelModifiers;
import io.github.mortuusars.exposure.util.GuiUtil;
import io.github.mortuusars.exposure.util.PagingDirection;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4264;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NegativeExposureScreen
extends ZoomableScreen {
    public static final class_2960 TEXTURE = Exposure.resource("textures/gui/film_frame_inspect.png");
    public static final int BG_SIZE = 78;
    public static final int FRAME_SIZE = 54;
    private final Pager pager = new Pager(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get());
    private final List<Either<String, class_2960>> exposures;

    public NegativeExposureScreen(List<Either<String, class_2960>> exposures) {
        super((class_2561)class_2561.method_43473());
        this.exposures = exposures;
        Preconditions.checkArgument((exposures != null && !exposures.isEmpty() ? 1 : 0) != 0);
        this.zoom.step = 2.0f;
        this.zoom.defaultZoom = 1.0f;
        this.zoom.targetZoom = 1.0f;
        this.zoom.minZoom = this.zoom.defaultZoom / (float)Math.pow(this.zoom.step, 1.0);
        this.zoom.maxZoom = this.zoom.defaultZoom * (float)Math.pow(this.zoom.step, 5.0);
    }

    public boolean method_25421() {
        return false;
    }

    protected void method_25426() {
        super.method_25426();
        this.zoomFactor = 1.0f / (float)((Integer)this.minecraft.field_1690.method_42474().method_41753() + 1);
        class_344 previousButton = new class_344(0, (int)((float)this.field_22790 / 2.0f - 8.0f), 16, 16, 0, 0, 16, PhotographScreen.WIDGETS_TEXTURE, 256, 256, button -> this.pager.changePage(PagingDirection.PREVIOUS), (class_2561)class_2561.method_43471((String)"gui.exposure.previous_page"));
        this.method_37063((class_364)previousButton);
        class_344 nextButton = new class_344(this.field_22789 - 16, (int)((float)this.field_22790 / 2.0f - 8.0f), 16, 16, 16, 0, 16, PhotographScreen.WIDGETS_TEXTURE, 256, 256, button -> this.pager.changePage(PagingDirection.NEXT), (class_2561)class_2561.method_43471((String)"gui.exposure.next_page"));
        this.method_37063((class_364)nextButton);
        this.pager.init(this.exposures.size(), true, (class_4264)previousButton, (class_4264)nextButton);
    }

    @Override
    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        ExposureImage exposure;
        this.pager.update();
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        Either<String, class_2960> idOrTexture = this.exposures.get(this.pager.getCurrentPage());
        @Nullable FilmType type = (FilmType)((Object)idOrTexture.map(id -> ExposureClient.getExposureStorage().getOrQuery((String)id).map(ExposureSavedData::getType).orElse(FilmType.BLACK_AND_WHITE), texture -> texture.method_12832().endsWith("_black_and_white") || texture.method_12832().endsWith("_bw") ? FilmType.COLOR : FilmType.BLACK_AND_WHITE));
        if (type == null) {
            type = FilmType.BLACK_AND_WHITE;
        }
        if ((exposure = (ExposureImage)idOrTexture.map(id -> ExposureClient.getExposureStorage().getOrQuery((String)id).map(data -> new ExposureImage((String)id, (ExposureSavedData)((Object)((Object)data)))).orElse(null), texture -> {
            @Nullable ExposureTexture exposureTexture = ExposureTexture.getTexture(texture);
            if (exposureTexture != null) {
                return new ExposureImage(texture.toString(), exposureTexture);
            }
            return null;
        })) == null) {
            return;
        }
        int width = exposure.getWidth();
        int height = exposure.getHeight();
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(this.x + (float)this.field_22789 / 2.0f, this.y + (float)this.field_22790 / 2.0f, 0.0f);
        guiGraphics.method_51448().method_22905(this.scale, this.scale, this.scale);
        guiGraphics.method_51448().method_46416((float)(-width) / 2.0f, (float)(-height) / 2.0f, 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        guiGraphics.method_51448().method_22903();
        float scale = Math.max((float)width / 54.0f, (float)height / 54.0f);
        guiGraphics.method_51448().method_22905(scale, scale, scale);
        guiGraphics.method_51448().method_46416(-12.0f, -12.0f, 0.0f);
        GuiUtil.blit(guiGraphics.method_51448(), 0.0f, 0.0f, 78.0f, 78.0f, 0, 0, 256, 256, 0.0f);
        RenderSystem.setShaderColor((float)type.filmR, (float)type.filmG, (float)type.filmB, (float)type.filmA);
        GuiUtil.blit(guiGraphics.method_51448(), 0.0f, 0.0f, 78.0f, 78.0f, 0, 78, 256, 256, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_51448().method_22909();
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        ExposureClient.getExposureRenderer().render(idOrTexture, ExposurePixelModifiers.NEGATIVE_FILM, guiGraphics.method_51448(), (class_4597)bufferSource, 0.0f, 0.0f, width, height, 0.0f, 0.0f, 1.0f, 1.0f, 0xF000F0, type.frameR, type.frameG, type.frameB, 255);
        bufferSource.method_22993();
        guiGraphics.method_51448().method_22909();
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.pager.handleKeyPressed(keyCode, scanCode, modifiers) || super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        return this.pager.handleKeyReleased(keyCode, scanCode, modifiers) || super.method_16803(keyCode, scanCode, modifiers);
    }
}

