/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.component;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.render.PhotographRenderer;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import org.jetbrains.annotations.NotNull;

public class PhotographTooltip
implements class_5684,
class_5632 {
    public static final int SIZE = 72;
    private final List<ItemAndStack<PhotographItem>> photographs;

    public PhotographTooltip(class_1799 photographStack) {
        Preconditions.checkArgument((boolean)(photographStack.method_7909() instanceof PhotographItem), (Object)(photographStack + " is not a PhotographItem."));
        this.photographs = List.of(new ItemAndStack(photographStack));
    }

    public PhotographTooltip(ItemAndStack<StackedPhotographsItem> stackedPhotographs) {
        this.photographs = stackedPhotographs.getItem().getPhotographs(stackedPhotographs.getStack());
    }

    public int method_32664(@NotNull class_327 font) {
        return 72;
    }

    public int method_32661() {
        return 74;
    }

    public void method_32666(@NotNull class_327 font, int mouseX, int mouseY, class_332 guiGraphics) {
        int photographsCount = this.photographs.size();
        int additionalPhotographs = Math.min(2, photographsCount - 1);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)mouseX, (float)mouseY, 5.0f);
        float scale = 72.0f / (float)ExposureClient.getExposureRenderer().getSize();
        float nextPhotographOffset = PhotographRenderer.getStackedPhotographOffset() / (float)ExposureClient.getExposureRenderer().getSize();
        guiGraphics.method_51448().method_22905(scale *= 1.0f - (float)additionalPhotographs * nextPhotographOffset, scale, 1.0f);
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        PhotographRenderer.renderStackedPhotographs(this.photographs, guiGraphics.method_51448(), (class_4597)bufferSource, 0xF000F0, 255, 255, 255, 255);
        bufferSource.method_22993();
        guiGraphics.method_51448().method_22909();
        if (photographsCount > 1) {
            guiGraphics.method_51448().method_22903();
            String count = Integer.toString(photographsCount);
            int fontWidth = class_310.method_1551().field_1772.method_1727(count);
            float fontScale = 1.6f;
            guiGraphics.method_51448().method_46416((float)mouseX + (float)ExposureClient.getExposureRenderer().getSize() * scale - 2.0f - (float)fontWidth * fontScale, (float)mouseY + (float)ExposureClient.getExposureRenderer().getSize() * scale - 2.0f - 8.0f * fontScale, 10.0f);
            guiGraphics.method_51448().method_22905(fontScale, fontScale, fontScale);
            guiGraphics.method_25303(font, count, 0, 0, -1);
            guiGraphics.method_51448().method_22909();
        }
    }
}

