/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.data.storage;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExposureSavedData
extends class_18 {
    public static final String TYPE_PROPERTY = "Type";
    public static final String WAS_PRINTED_PROPERTY = "WasPrinted";
    public static final String TIMESTAMP_PROPERTY = "Timestamp";
    private final int width;
    private final int height;
    private final byte[] pixels;
    private final class_2487 properties;

    public ExposureSavedData(int width, int height, byte[] pixels, class_2487 properties) {
        Preconditions.checkArgument((width >= 0 ? 1 : 0) != 0, (Object)"Width cannot be negative.");
        Preconditions.checkArgument((height >= 0 ? 1 : 0) != 0, (Object)"Height cannot be negative.");
        if (pixels.length > width * height) {
            LogUtils.getLogger().warn("Pixel count was larger that it supposed to be. This shouldn't happen.");
        }
        this.width = width;
        this.height = height;
        this.pixels = pixels;
        this.properties = properties;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getPixels() {
        return this.pixels;
    }

    public byte getPixel(int x, int y) {
        return this.pixels[y * this.width + x];
    }

    public void setPixel(int x, int y, byte value) {
        Preconditions.checkArgument((x >= 0 && x < this.width ? 1 : 0) != 0, (Object)("X=" + x + " is out of bounds for Width=" + this.width));
        Preconditions.checkArgument((y >= 0 && y < this.height ? 1 : 0) != 0, (Object)("Y=" + x + " is out of bounds for Height=" + this.height));
        this.pixels[y * this.width + x] = value;
    }

    public class_2487 getProperties() {
        return this.properties;
    }

    @Nullable
    public FilmType getType() {
        String typeString = this.properties.method_10558(TYPE_PROPERTY);
        return FilmType.byName(typeString);
    }

    @NotNull
    public class_2487 method_75(class_2487 compoundTag) {
        compoundTag.method_10569("width", this.width);
        compoundTag.method_10569("height", this.height);
        compoundTag.method_10570("pixels", this.pixels);
        compoundTag.method_10566("properties", (class_2520)this.properties);
        return compoundTag;
    }

    public static ExposureSavedData load(class_2487 compoundTag) {
        class_2487 properties = compoundTag.method_10562("properties");
        if (!properties.method_10545(TYPE_PROPERTY)) {
            properties.method_10582(TYPE_PROPERTY, compoundTag.method_10577("black_and_white") ? "black_and_white" : "color");
        }
        if (!properties.method_10545(WAS_PRINTED_PROPERTY)) {
            properties.method_10556(WAS_PRINTED_PROPERTY, compoundTag.method_10577("printed"));
        }
        return new ExposureSavedData(compoundTag.method_10550("width"), compoundTag.method_10550("height"), compoundTag.method_10547("pixels"), properties);
    }
}

