/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.advancement.predicate;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import io.github.mortuusars.exposure.advancement.BooleanPredicate;
import io.github.mortuusars.exposure.advancement.predicate.EntityInFramePredicate;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_2096;
import net.minecraft.class_2105;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Nullable;

public class ExposurePredicate {
    public static final ExposurePredicate ANY = new ExposurePredicate(BooleanPredicate.ANY, class_2096.class_2099.field_9705, class_2096.class_2099.field_9705, class_2105.field_9716, class_2096.class_2100.field_9708, class_2096.class_2100.field_9708, EntityInFramePredicate.ANY);
    private final BooleanPredicate owner;
    private final class_2096.class_2099 shutterSpeedMS;
    private final class_2096.class_2099 focalLength;
    private final class_2105 nbt;
    private final class_2096.class_2100 lightLevel;
    private final class_2096.class_2100 entitiesInFrameCount;
    private final EntityInFramePredicate entityInFrame;

    public ExposurePredicate(BooleanPredicate ownerPredicate, class_2096.class_2099 shutterSpeedMS, class_2096.class_2099 focalLength, class_2105 nbtPredicate, class_2096.class_2100 lightLevel, class_2096.class_2100 entitiesInFrameCount, EntityInFramePredicate entityInFramePredicate) {
        this.owner = ownerPredicate;
        this.shutterSpeedMS = shutterSpeedMS;
        this.focalLength = focalLength;
        this.nbt = nbtPredicate;
        this.lightLevel = lightLevel;
        this.entitiesInFrameCount = entitiesInFrameCount;
        this.entityInFrame = entityInFramePredicate;
    }

    public boolean matches(class_3222 player, class_2487 tag) {
        if (!this.ownerMatches(player, tag)) {
            return false;
        }
        if (!this.shutterSpeedMS.method_9047((double)tag.method_10583("ShutterSpeedMS"))) {
            return false;
        }
        if (!this.focalLength.method_9047((double)tag.method_10583("FocalLength"))) {
            return false;
        }
        if (!this.nbt.method_9077((class_2520)tag)) {
            return false;
        }
        if (!this.lightLevel.method_9054(tag.method_10550("LightLevel"))) {
            return false;
        }
        return this.entitiesMatch(player, tag);
    }

    private boolean ownerMatches(class_3222 player, class_2487 tag) {
        if (this.owner.equals(BooleanPredicate.ANY)) {
            return true;
        }
        if (!tag.method_10573("PhotographerId", 11)) {
            return false;
        }
        UUID photographerId = tag.method_25926("PhotographerId");
        UUID playerId = player.method_5667();
        return this.owner.matches(photographerId.equals(playerId));
    }

    private boolean entitiesMatch(class_3222 player, class_2487 tag) {
        if (tag.method_10573("Entities", 9)) {
            class_2499 entities = tag.method_10554("Entities", 10);
            if (!this.entitiesInFrameCount.method_9054(entities.size())) {
                return false;
            }
            for (int i = 0; i < entities.size(); ++i) {
                if (!this.entityInFrame.matches(player, entities.method_10602(i))) continue;
                return true;
            }
        } else {
            return this.entityInFrame.equals(EntityInFramePredicate.ANY) && this.entitiesInFrameCount.method_9054(0);
        }
        return false;
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject json = new JsonObject();
        if (!this.owner.equals(BooleanPredicate.ANY)) {
            json.add("owner", this.owner.serializeToJson());
        }
        if (!this.shutterSpeedMS.method_9041()) {
            json.add("shutter_speed_ms", this.shutterSpeedMS.method_9036());
        }
        if (!this.focalLength.method_9041()) {
            json.add("focal_length", this.focalLength.method_9036());
        }
        if (!this.nbt.equals(class_2105.field_9716)) {
            json.add("nbt", this.nbt.method_9075());
        }
        if (!this.lightLevel.method_9041()) {
            json.add("light_level", this.lightLevel.method_9036());
        }
        if (!this.entitiesInFrameCount.method_9041()) {
            json.add("entities_count", this.entitiesInFrameCount.method_9036());
        }
        if (!this.entityInFrame.equals(EntityInFramePredicate.ANY)) {
            json.add("entity_in_frame", this.entityInFrame.serializeToJson());
        }
        return json;
    }

    public static ExposurePredicate fromJson(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return ANY;
        }
        JsonObject jsonobject = class_3518.method_15295((JsonElement)json, (String)"exposure");
        return new ExposurePredicate(BooleanPredicate.fromJson(jsonobject.get("owner")), class_2096.class_2099.method_9051((JsonElement)jsonobject.get("shutter_speed_ms")), class_2096.class_2099.method_9051((JsonElement)jsonobject.get("focal_length")), class_2105.method_9073((JsonElement)jsonobject.get("nbt")), class_2096.class_2100.method_9056((JsonElement)jsonobject.get("light_level")), class_2096.class_2100.method_9056((JsonElement)jsonobject.get("entities_count")), EntityInFramePredicate.fromJson(jsonobject.get("entity_in_frame")));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExposurePredicate that = (ExposurePredicate)o;
        return Objects.equals(this.owner, that.owner) && Objects.equals(this.shutterSpeedMS, that.shutterSpeedMS) && Objects.equals(this.focalLength, that.focalLength) && Objects.equals(this.nbt, that.nbt) && Objects.equals(this.entitiesInFrameCount, that.entitiesInFrameCount) && Objects.equals(this.entityInFrame, that.entityInFrame);
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.shutterSpeedMS, this.focalLength, this.nbt, this.entitiesInFrameCount, this.entityInFrame);
    }
}

