/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.advancement.predicate;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.class_2090;
import net.minecraft.class_2096;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Nullable;

public class EntityInFramePredicate {
    public static final EntityInFramePredicate ANY = new EntityInFramePredicate(null, class_2090.field_9685, class_2096.class_2099.field_9705);
    @Nullable
    private final String id;
    private final class_2090 location;
    private final class_2096.class_2099 distance;

    public EntityInFramePredicate(@Nullable class_2960 id, class_2090 location, class_2096.class_2099 distance) {
        this.id = id != null ? id.toString() : null;
        this.location = location;
        this.distance = distance;
    }

    public boolean matches(class_3222 player, class_2487 entityInfoTag) {
        if (this.equals(ANY)) {
            return true;
        }
        if (this.id != null && !this.id.equals(entityInfoTag.method_10558("Id"))) {
            return false;
        }
        if (!this.locationMatches(player, entityInfoTag)) {
            return false;
        }
        return this.distance.method_9047((double)entityInfoTag.method_10583("Distance"));
    }

    private boolean locationMatches(class_3222 player, class_2487 entityInfoTag) {
        class_2499 posList = entityInfoTag.method_10554("Pos", 3);
        if (posList.size() < 3) {
            return false;
        }
        int x = posList.method_10600(0);
        int y = posList.method_10600(1);
        int z = posList.method_10600(2);
        return this.location.method_9018(player.method_51469(), (double)x, (double)y, (double)z);
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject json = new JsonObject();
        if (this.id != null) {
            json.addProperty("id", this.id);
        }
        if (!this.location.equals(class_2090.field_9685)) {
            json.add("location", this.location.method_9019());
        }
        if (!this.distance.method_9041()) {
            json.add("distance", this.distance.method_9036());
        }
        return json;
    }

    public static EntityInFramePredicate fromJson(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return ANY;
        }
        JsonObject jsonobject = class_3518.method_15295((JsonElement)json, (String)"entity");
        String id = null;
        if (jsonobject.has("id")) {
            id = jsonobject.get("id").getAsString();
        }
        class_2090 location = class_2090.method_9021((JsonElement)jsonobject.getAsJsonObject("location"));
        class_2096.class_2099 distance = class_2096.class_2099.method_9051((JsonElement)jsonobject.getAsJsonObject("distance"));
        return new EntityInFramePredicate(id != null ? new class_2960(id) : null, location, distance);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityInFramePredicate that = (EntityInFramePredicate)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.location, that.location) && Objects.equals(this.distance, that.distance);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.location, this.distance);
    }
}

