/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.viewfinder.ViewfinderClient;
import io.github.mortuusars.exposure.data.storage.ClientsideExposureStorage;
import io.github.mortuusars.exposure.data.storage.IClientsideExposureStorage;
import io.github.mortuusars.exposure.data.transfer.ExposureReceiver;
import io.github.mortuusars.exposure.data.transfer.ExposureSender;
import io.github.mortuusars.exposure.data.transfer.IExposureReceiver;
import io.github.mortuusars.exposure.data.transfer.IExposureSender;
import io.github.mortuusars.exposure.gui.screen.camera.ViewfinderControlsScreen;
import io.github.mortuusars.exposure.item.AlbumItem;
import io.github.mortuusars.exposure.item.CameraItemClientExtensions;
import io.github.mortuusars.exposure.item.ChromaticSheetItem;
import io.github.mortuusars.exposure.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.render.ExposureRenderer;
import io.github.mortuusars.exposure.util.CameraInHand;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5272;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class ExposureClient {
    private static final IClientsideExposureStorage exposureStorage = new ClientsideExposureStorage();
    private static final ExposureRenderer exposureRenderer = new ExposureRenderer();
    private static IExposureSender exposureSender;
    private static IExposureReceiver exposureReceiver;
    @Nullable
    private static class_304 openCameraControlsKey;

    public static void init() {
        exposureSender = new ExposureSender((packet, player) -> Packets.sendToServer(packet));
        exposureReceiver = new ExposureReceiver(exposureStorage);
        class_5272.method_27879((class_1792)Exposure.Items.CAMERA.get(), (class_2960)new class_2960("camera_state"), CameraItemClientExtensions::itemPropertyFunction);
        class_5272.method_27879((class_1792)Exposure.Items.CHROMATIC_SHEET.get(), (class_2960)new class_2960("channels"), (stack, clientLevel, livingEntity, seed) -> {
            float f;
            class_1792 patt2475$temp = stack.method_7909();
            if (patt2475$temp instanceof ChromaticSheetItem) {
                ChromaticSheetItem chromaticSheet = (ChromaticSheetItem)patt2475$temp;
                f = (float)chromaticSheet.getExposures(stack).size() / 10.0f;
            } else {
                f = 0.0f;
            }
            return f;
        });
        class_5272.method_27879((class_1792)Exposure.Items.STACKED_PHOTOGRAPHS.get(), (class_2960)new class_2960("count"), (stack, clientLevel, livingEntity, seed) -> {
            float f;
            class_1792 patt2810$temp = stack.method_7909();
            if (patt2810$temp instanceof StackedPhotographsItem) {
                StackedPhotographsItem stackedPhotographsItem = (StackedPhotographsItem)patt2810$temp;
                f = (float)stackedPhotographsItem.getPhotographsCount(stack) / 100.0f;
            } else {
                f = 0.0f;
            }
            return f;
        });
        class_5272.method_27879((class_1792)Exposure.Items.ALBUM.get(), (class_2960)new class_2960("photos"), (stack, clientLevel, livingEntity, seed) -> {
            float f;
            class_1792 patt3161$temp = stack.method_7909();
            if (patt3161$temp instanceof AlbumItem) {
                AlbumItem albumItem = (AlbumItem)patt3161$temp;
                f = (float)albumItem.getPhotographsCount(stack) / 100.0f;
            } else {
                f = 0.0f;
            }
            return f;
        });
    }

    public static IClientsideExposureStorage getExposureStorage() {
        return exposureStorage;
    }

    public static IExposureSender getExposureSender() {
        return exposureSender;
    }

    public static IExposureReceiver getExposureReceiver() {
        return exposureReceiver;
    }

    public static ExposureRenderer getExposureRenderer() {
        return exposureRenderer;
    }

    public static void registerKeymappings(Function<class_304, class_304> registerFunction) {
        class_304 keyMapping = new class_304("key.exposure.camera_controls", class_3675.field_16237.method_1444(), "category.exposure");
        openCameraControlsKey = registerFunction.apply(keyMapping);
    }

    public static void onScreenAdded(class_437 screen) {
        class_746 player;
        if (ViewfinderClient.isOpen() && !(screen instanceof ViewfinderControlsScreen) && (player = class_310.method_1551().field_1724) != null) {
            CameraInHand.deactivate((class_1657)player);
        }
    }

    public static class_304 getCameraControlsKey() {
        Preconditions.checkState((openCameraControlsKey != null ? 1 : 0) != 0, (Object)"Viewfinder Controls key mapping was not registered");
        return openCameraControlsKey.method_1415() ? class_310.method_1551().field_1690.field_1832 : openCameraControlsKey;
    }

    static {
        openCameraControlsKey = null;
    }
}

