/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.other;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jesz.createdieselgenerators.CreateDieselGenerators;
import com.jesz.createdieselgenerators.blocks.DieselGeneratorBlock;
import com.jesz.createdieselgenerators.other.CDGFuelType;
import com.simibubi.create.AllTags;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3611;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;

public class FuelTypeManager {
    public static Map<class_3611, CDGFuelType> fuelTypes = new HashMap<class_3611, CDGFuelType>();
    static Map<String, CDGFuelType> fuelTags = new HashMap<String, CDGFuelType>();

    public static void tryPopulateTags() {
        if (fuelTags.isEmpty()) {
            return;
        }
        if (class_7923.field_41173.method_40272().toList().isEmpty()) {
            return;
        }
        for (Map.Entry<String, CDGFuelType> entry : Map.copyOf(fuelTags).entrySet()) {
            class_7923.field_41173.method_40266(AllTags.optionalTag((class_2378)class_7923.field_41173, (class_2960)new class_2960(entry.getKey()))).stream().distinct().toList().forEach(fluid -> {
                fuelTypes.put((class_3611)fluid.method_40240(0).comp_349(), (CDGFuelType)entry.getValue());
                fuelTags.remove(entry.getKey(), entry.getValue());
            });
        }
    }

    public static CDGFuelType getType(class_3611 fluid) {
        return fuelTypes.get(fluid);
    }

    public static float getGeneratedSpeed(class_2586 be, class_3611 fluid) {
        FuelTypeManager.tryPopulateTags();
        if (fuelTypes.containsKey(fluid)) {
            return ((Float)fuelTypes.get(fluid).getGenerated(be).getFirst()).floatValue();
        }
        return 0.0f;
    }

    public static float getGeneratedStress(class_2586 be, class_3611 fluid) {
        FuelTypeManager.tryPopulateTags();
        if (fuelTypes.containsKey(fluid)) {
            return ((Float)fuelTypes.get(fluid).getGenerated(be).getSecond()).floatValue();
        }
        return 0.0f;
    }

    public static float getGeneratedSpeed(DieselGeneratorBlock.EngineTypes engine, class_3611 fluid) {
        FuelTypeManager.tryPopulateTags();
        if (fuelTypes.containsKey(fluid)) {
            if (engine == DieselGeneratorBlock.EngineTypes.NORMAL) {
                return ((Float)fuelTypes.get(fluid).getGeneratedNormal().getFirst()).floatValue();
            }
            if (engine == DieselGeneratorBlock.EngineTypes.MODULAR) {
                return ((Float)fuelTypes.get(fluid).getGeneratedModular().getFirst()).floatValue();
            }
            if (engine == DieselGeneratorBlock.EngineTypes.HUGE) {
                return ((Float)fuelTypes.get(fluid).getGeneratedHuge().getFirst()).floatValue();
            }
        }
        return 0.0f;
    }

    public static float getGeneratedStress(DieselGeneratorBlock.EngineTypes engine, class_3611 fluid) {
        FuelTypeManager.tryPopulateTags();
        if (fuelTypes.containsKey(fluid)) {
            if (engine == DieselGeneratorBlock.EngineTypes.NORMAL) {
                return ((Float)fuelTypes.get(fluid).getGeneratedNormal().getSecond()).floatValue();
            }
            if (engine == DieselGeneratorBlock.EngineTypes.MODULAR) {
                return ((Float)fuelTypes.get(fluid).getGeneratedModular().getSecond()).floatValue();
            }
            if (engine == DieselGeneratorBlock.EngineTypes.HUGE) {
                return ((Float)fuelTypes.get(fluid).getGeneratedHuge().getSecond()).floatValue();
            }
        }
        return 0.0f;
    }

    public static int getBurnRate(DieselGeneratorBlock.EngineTypes engine, class_3611 fluid) {
        FuelTypeManager.tryPopulateTags();
        if (fuelTypes.containsKey(fluid)) {
            if (engine == DieselGeneratorBlock.EngineTypes.NORMAL) {
                return fuelTypes.get(fluid).getBurnNormal();
            }
            if (engine == DieselGeneratorBlock.EngineTypes.MODULAR) {
                return fuelTypes.get(fluid).getBurnModular();
            }
            if (engine == DieselGeneratorBlock.EngineTypes.HUGE) {
                return fuelTypes.get(fluid).getBurnHuge();
            }
        }
        return 0;
    }

    public static float getGeneratedSpeed(class_3611 fluid) {
        FuelTypeManager.tryPopulateTags();
        if (fuelTypes.containsKey(fluid)) {
            return ((Float)fuelTypes.get(fluid).getGeneratedNormal().getFirst()).floatValue();
        }
        return 0.0f;
    }

    public static float getGeneratedStress(class_3611 fluid) {
        FuelTypeManager.tryPopulateTags();
        if (fuelTypes.containsKey(fluid)) {
            return ((Float)fuelTypes.get(fluid).getGeneratedNormal().getSecond()).floatValue();
        }
        return 0.0f;
    }

    public static int getBurnRate(class_2586 be, class_3611 fluid) {
        FuelTypeManager.tryPopulateTags();
        if (fuelTypes.containsKey(fluid)) {
            return fuelTypes.get(fluid).getBurn(be);
        }
        return 0;
    }

    public static int getBurnRate(class_3611 fluid) {
        FuelTypeManager.tryPopulateTags();
        if (fuelTypes.containsKey(fluid)) {
            return fuelTypes.get(fluid).getBurnNormal();
        }
        return 0;
    }

    public static int getSoundSpeed(class_3611 fluid) {
        FuelTypeManager.tryPopulateTags();
        if (fuelTypes.containsKey(fluid)) {
            return fuelTypes.get(fluid).getSoundSpeed();
        }
        return 1;
    }

    public static class ReloadListener
    extends class_4309
    implements IdentifiableResourceReloadListener {
        private static final Gson GSON = new Gson();
        public static final ReloadListener INSTANCE = new ReloadListener();

        public ReloadListener() {
            super(GSON, "diesel_engine_fuel_types");
        }

        public class_2960 getFabricId() {
            return CreateDieselGenerators.asResource("diesel_engine_fuel_types");
        }

        protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
            fuelTypes.clear();
            for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
                JsonElement element = entry.getValue();
                if (!element.isJsonObject()) {
                    return;
                }
                JsonObject normalEngineObject = element.getAsJsonObject().get("normal").getAsJsonObject();
                JsonObject modularEngineObject = element.getAsJsonObject().has("modular") ? element.getAsJsonObject().get("modular").getAsJsonObject() : normalEngineObject;
                JsonObject hugeEngineObject = element.getAsJsonObject().has("huge") ? element.getAsJsonObject().get("huge").getAsJsonObject() : normalEngineObject;
                String fluidId = element.getAsJsonObject().get("fluid").getAsString();
                if (fluidId.startsWith("#")) {
                    fuelTags.put(fluidId.substring(1), new CDGFuelType(normalEngineObject.get("speed").getAsFloat(), normalEngineObject.get("strength").getAsFloat(), normalEngineObject.get("burn_rate").getAsInt(), modularEngineObject.get("speed").getAsFloat(), modularEngineObject.get("strength").getAsFloat(), modularEngineObject.get("burn_rate").getAsInt(), hugeEngineObject.get("speed").getAsFloat(), hugeEngineObject.get("strength").getAsFloat(), hugeEngineObject.get("burn_rate").getAsInt(), element.getAsJsonObject().get("sound_speed").getAsInt()));
                    FuelTypeManager.tryPopulateTags();
                    continue;
                }
                Optional fluid = class_7923.field_41173.method_17966(new class_2960(fluidId));
                if (fluid.isEmpty()) {
                    return;
                }
                fuelTypes.put((class_3611)fluid.get(), new CDGFuelType(normalEngineObject.get("speed").getAsFloat(), normalEngineObject.get("strength").getAsFloat(), normalEngineObject.get("burn_rate").getAsInt(), modularEngineObject.get("speed").getAsFloat(), modularEngineObject.get("strength").getAsFloat(), modularEngineObject.get("burn_rate").getAsInt(), hugeEngineObject.get("speed").getAsFloat(), hugeEngineObject.get("strength").getAsFloat(), hugeEngineObject.get("burn_rate").getAsInt(), element.getAsJsonObject().get("sound_speed").getAsInt()));
            }
        }
    }
}

