/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.compat.jei;

import com.jesz.createdieselgenerators.compat.jei.AnimatedDistillationTower;
import com.jesz.createdieselgenerators.recipes.DistillationRecipe;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedBlazeBurner;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.Lang;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;

@ParametersAreNonnullByDefault
public class DistillationCategory
extends CreateRecipeCategory<DistillationRecipe> {
    private final AnimatedDistillationTower distillationTower = new AnimatedDistillationTower();
    private final AnimatedBlazeBurner heater = new AnimatedBlazeBurner();
    int height = 0;

    public DistillationCategory(CreateRecipeCategory.Info<DistillationRecipe> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DistillationRecipe recipe, IFocusGroup focuses) {
        if (recipe.getFluidIngredients().isEmpty()) {
            return;
        }
        FluidIngredient fluidIngredient = (FluidIngredient)recipe.getFluidIngredients().get(0);
        List v = fluidIngredient.getMatchingFluidStacks();
        List r = DistillationCategory.withImprovedVisibility((List)v);
        List j = DistillationCategory.toJei((List)r);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 17, 145).setBackground(DistillationCategory.getRenderedSlot(), -1, -1).addIngredients((IIngredientType)FabricTypes.FLUID_STACK, j)).addTooltipCallback(DistillationCategory.addFluidTooltip((long)fluidIngredient.getRequiredAmount()));
        int i = 1;
        int size = recipe.getRollableResults().size() + recipe.getFluidResults().size();
        for (FluidStack fluidResult : recipe.getFluidResults()) {
            int yPosition = -23 * i + 150;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 130, yPosition).setBackground(DistillationCategory.getRenderedSlot(), -1, -1).addIngredient((IIngredientType)FabricTypes.FLUID_STACK, (Object)DistillationCategory.toJei((FluidStack)DistillationCategory.withImprovedVisibility((FluidStack)fluidResult)))).addTooltipCallback(DistillationCategory.addFluidTooltip((long)fluidResult.getAmount()));
            ++i;
        }
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.NONE)) {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 134, 171).addItemStack(AllBlocks.BLAZE_BURNER.asStack());
        }
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.KINDLED)) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 153, 171).addItemStack(AllItems.BLAZE_CAKE.asStack());
        }
    }

    public void draw(DistillationRecipe recipe, IRecipeSlotsView iRecipeSlotsView, class_332 graphics, double mouseX, double mouseY) {
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        boolean noHeat = requiredHeat == HeatCondition.NONE;
        AllGuiTextures.JEI_ARROW.render(graphics, 40, 150);
        AllGuiTextures shadow = noHeat ? AllGuiTextures.JEI_SHADOW : AllGuiTextures.JEI_LIGHT;
        shadow.render(graphics, 81, 153 + (noHeat ? 10 : 30));
        this.distillationTower.draw(graphics, 91, 142, recipe.getFluidResults().size());
        if (!noHeat) {
            this.heater.withHeat(requiredHeat.visualizeAsBlazeBurner()).draw(graphics, 91, 150);
        }
        AllGuiTextures heatBar = noHeat ? AllGuiTextures.JEI_NO_HEAT_BAR : AllGuiTextures.JEI_HEAT_BAR;
        heatBar.render(graphics, 4, 170);
        graphics.method_51439(class_310.method_1551().field_1772, (class_2561)Lang.translateDirect((String)requiredHeat.getTranslationKey(), (Object[])new Object[0]), 9, 176, requiredHeat.getColor(), false);
    }
}

