/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.compat.jei;

import com.google.common.collect.ImmutableList;
import com.jesz.createdieselgenerators.blocks.BlockRegistry;
import com.jesz.createdieselgenerators.compat.jei.BasinFermentingCategory;
import com.jesz.createdieselgenerators.compat.jei.DieselEngineCategory;
import com.jesz.createdieselgenerators.compat.jei.DieselEngineJeiRecipeType;
import com.jesz.createdieselgenerators.compat.jei.DistillationCategory;
import com.jesz.createdieselgenerators.config.ConfigRegistry;
import com.jesz.createdieselgenerators.items.ItemRegistry;
import com.jesz.createdieselgenerators.other.CDGFuelType;
import com.jesz.createdieselgenerators.other.FuelTypeManager;
import com.jesz.createdieselgenerators.recipes.DistillationRecipe;
import com.jesz.createdieselgenerators.recipes.RecipeRegistry;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.CreateJEI;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.SlotMover;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.foundation.config.ConfigBase;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CRecipes;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3956;

@ParametersAreNonnullByDefault
@JeiPlugin
public class CDGJEI
implements IModPlugin {
    private static final class_2960 ID = new class_2960("createdieselgenerators", "jei_plugin");
    private final List<CreateRecipeCategory<?>> allCategories = new ArrayList();

    public class_2960 getPluginUid() {
        return ID;
    }

    private void loadCategories() {
        this.allCategories.clear();
        CreateRecipeCategory<BasinRecipe> basin_fermenting = this.builder(BasinRecipe.class).addTypedRecipes(RecipeRegistry.BASIN_FERMENTING).catalyst(() -> BlockRegistry.BASIN_LID.get()).catalyst(() -> ((BlockEntry)AllBlocks.BASIN).get()).doubleItemIcon((class_1935)AllBlocks.BASIN.get(), (class_1935)BlockRegistry.BASIN_LID.get()).emptyBackground(177, 100).build("basin_fermenting", (CreateRecipeCategory.Factory<BasinRecipe>)((CreateRecipeCategory.Factory)BasinFermentingCategory::new));
        CreateRecipeCategory<DistillationRecipe> distillation = this.builder(DistillationRecipe.class).addTypedRecipes(RecipeRegistry.DISTILLATION).catalyst(() -> ((BlockEntry)AllBlocks.FLUID_TANK).get()).catalyst(() -> ItemRegistry.DISTILLATION_CONTROLLER.get()).doubleItemIcon((class_1935)AllBlocks.FLUID_TANK.get(), (class_1935)ItemRegistry.DISTILLATION_CONTROLLER.get()).emptyBackground(177, 200).build("distillation", (CreateRecipeCategory.Factory<DistillationRecipe>)((CreateRecipeCategory.Factory)DistillationCategory::new));
    }

    private <T extends class_1860<?>> CategoryBuilder<T> builder(Class<? extends T> recipeClass) {
        return new CategoryBuilder<T>(recipeClass);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new DieselEngineCategory(registration.getJeiHelpers().getGuiHelper())});
        this.loadCategories();
        registration.addRecipeCategories((IRecipeCategory[])this.allCategories.toArray(IRecipeCategory[]::new));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.allCategories.forEach(c -> c.registerRecipes(registration));
        if (!((Boolean)ConfigRegistry.DIESEL_ENGINE_IN_JEI.get()).booleanValue()) {
            return;
        }
        FuelTypeManager.tryPopulateTags();
        for (Map.Entry<class_3611, CDGFuelType> entry : FuelTypeManager.fuelTypes.entrySet()) {
            if (!entry.getKey().method_15793(entry.getKey().method_15785())) continue;
            registration.addRecipes(DieselEngineJeiRecipeType.DIESEL_COMBUSTION, (List)ImmutableList.of((Object)new DieselEngineJeiRecipeType(entry.getKey())));
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.allCategories.forEach(c -> c.registerCatalysts(registration));
        if (((Boolean)ConfigRegistry.NORMAL_ENGINES.get()).booleanValue()) {
            registration.addRecipeCatalyst(BlockRegistry.DIESEL_ENGINE.asStack(), new RecipeType[]{DieselEngineJeiRecipeType.DIESEL_COMBUSTION});
        }
        if (((Boolean)ConfigRegistry.MODULAR_ENGINES.get()).booleanValue()) {
            registration.addRecipeCatalyst(BlockRegistry.MODULAR_DIESEL_ENGINE.asStack(), new RecipeType[]{DieselEngineJeiRecipeType.DIESEL_COMBUSTION});
        }
        if (((Boolean)ConfigRegistry.HUGE_ENGINES.get()).booleanValue()) {
            registration.addRecipeCatalyst(BlockRegistry.HUGE_DIESEL_ENGINE.asStack(), new RecipeType[]{DieselEngineJeiRecipeType.DIESEL_COMBUSTION});
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(AbstractSimiContainerScreen.class, (IGuiContainerHandler)new SlotMover());
    }

    private class CategoryBuilder<T extends class_1860<?>> {
        private final Class<? extends T> recipeClass;
        private Predicate<CRecipes> predicate = cRecipes -> true;
        private IDrawable background;
        private IDrawable icon;
        private final List<Consumer<List<T>>> recipeListConsumers = new ArrayList<Consumer<List<T>>>();
        private final List<Supplier<? extends class_1799>> catalysts = new ArrayList<Supplier<? extends class_1799>>();

        public CategoryBuilder(Class<? extends T> recipeClass) {
            this.recipeClass = recipeClass;
        }

        public CategoryBuilder<T> enableIf(Predicate<CRecipes> predicate) {
            this.predicate = predicate;
            return this;
        }

        public CategoryBuilder<T> enableWhen(Function<CRecipes, ConfigBase.ConfigBool> configValue) {
            this.predicate = c -> (Boolean)((ConfigBase.ConfigBool)configValue.apply((CRecipes)c)).get();
            return this;
        }

        public CategoryBuilder<T> addRecipeListConsumer(Consumer<List<T>> consumer) {
            this.recipeListConsumers.add(consumer);
            return this;
        }

        public CategoryBuilder<T> addRecipes(Supplier<Collection<? extends T>> collection) {
            return this.addRecipeListConsumer(recipes -> recipes.addAll((Collection)collection.get()));
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<class_1860<?>> pred) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeAllRecipes(recipe -> {
                if (pred.test((class_1860<?>)recipe)) {
                    recipes.add(recipe);
                }
            }));
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<class_1860<?>> pred, Function<class_1860<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeAllRecipes(recipe -> {
                if (pred.test((class_1860<?>)recipe)) {
                    recipes.add((class_1860)converter.apply((class_1860<?>)recipe));
                }
            }));
        }

        public CategoryBuilder<T> addTypedRecipes(IRecipeTypeInfo recipeTypeEntry) {
            return this.addTypedRecipes(() -> ((IRecipeTypeInfo)recipeTypeEntry).getType());
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<class_3956<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipes::add, (class_3956)((class_3956)recipeType.get())));
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<class_3956<? extends T>> recipeType, Function<class_1860<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipe -> recipes.add((class_1860)converter.apply((class_1860<?>)recipe)), (class_3956)((class_3956)recipeType.get())));
        }

        public CategoryBuilder<T> addTypedRecipesIf(Supplier<class_3956<? extends T>> recipeType, Predicate<class_1860<?>> pred) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipe -> {
                if (pred.test((class_1860<?>)recipe)) {
                    recipes.add(recipe);
                }
            }, (class_3956)((class_3956)recipeType.get())));
        }

        public CategoryBuilder<T> addTypedRecipesExcluding(Supplier<class_3956<? extends T>> recipeType, Supplier<class_3956<? extends T>> excluded) {
            return this.addRecipeListConsumer(recipes -> {
                List excludedRecipes = CreateJEI.getTypedRecipes((class_3956)((class_3956)excluded.get()));
                CreateJEI.consumeTypedRecipes(recipe -> {
                    for (class_1860 excludedRecipe : excludedRecipes) {
                        if (!CreateJEI.doInputsMatch((class_1860)recipe, (class_1860)excludedRecipe)) continue;
                        return;
                    }
                    recipes.add(recipe);
                }, (class_3956)((class_3956)recipeType.get()));
            });
        }

        public CategoryBuilder<T> removeRecipes(Supplier<class_3956<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> {
                List excludedRecipes = CreateJEI.getTypedRecipes((class_3956)((class_3956)recipeType.get()));
                recipes.removeIf(recipe -> {
                    for (class_1860 excludedRecipe : excludedRecipes) {
                        if (!CreateJEI.doInputsMatch((class_1860)recipe, (class_1860)excludedRecipe) || !CreateJEI.doOutputsMatch((class_1860)recipe, (class_1860)excludedRecipe)) continue;
                        return true;
                    }
                    return false;
                });
            });
        }

        public CategoryBuilder<T> catalystStack(Supplier<class_1799> supplier) {
            this.catalysts.add(supplier);
            return this;
        }

        public CategoryBuilder<T> catalyst(Supplier<class_1935> supplier) {
            return this.catalystStack(() -> new class_1799((class_1935)((class_1935)supplier.get()).method_8389()));
        }

        public CategoryBuilder<T> icon(IDrawable icon) {
            this.icon = icon;
            return this;
        }

        public CategoryBuilder<T> itemIcon(class_1935 item) {
            this.icon((IDrawable)new ItemIcon(() -> new class_1799(item)));
            return this;
        }

        public CategoryBuilder<T> doubleItemIcon(class_1935 item1, class_1935 item2) {
            this.icon((IDrawable)new DoubleItemIcon(() -> new class_1799(item1), () -> new class_1799(item2)));
            return this;
        }

        public CategoryBuilder<T> background(IDrawable background) {
            this.background = background;
            return this;
        }

        public CategoryBuilder<T> emptyBackground(int width, int height) {
            this.background((IDrawable)new EmptyBackground(width, height));
            return this;
        }

        public CreateRecipeCategory<T> build(String name, CreateRecipeCategory.Factory<T> factory) {
            Supplier<List> recipesSupplier = this.predicate.test(AllConfigs.server().recipes) ? () -> {
                ArrayList recipes = new ArrayList();
                for (Consumer consumer : this.recipeListConsumers) {
                    consumer.accept(recipes);
                }
                return recipes;
            } : () -> Collections.emptyList();
            CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(new RecipeType(new class_2960("createdieselgenerators", name), this.recipeClass), (class_2561)Components.translatable((String)("createdieselgenerators.recipe." + name)), this.background, this.icon, recipesSupplier, this.catalysts);
            CreateRecipeCategory category = factory.create(info);
            CDGJEI.this.allCategories.add(category);
            return category;
        }
    }
}

