/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.renderer;

import com.jesz.createdieselgenerators.PartialModels;
import com.jesz.createdieselgenerators.blocks.HugeDieselEngineBlock;
import com.jesz.createdieselgenerators.blocks.entity.HugeDieselEngineBlockEntity;
import com.jesz.createdieselgenerators.blocks.entity.PoweredEngineShaftBlockEntity;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public class HugeDieselEngineInstance
extends BlockEntityInstance<HugeDieselEngineBlockEntity>
implements DynamicInstance {
    protected final ModelData piston = (ModelData)this.getTransformMaterial().getModel(PartialModels.ENGINE_PISTON).createInstance();
    protected final ModelData connector = (ModelData)this.getTransformMaterial().getModel(PartialModels.ENGINE_PISTON_CONNECTOR).createInstance();
    protected final ModelData linkage = (ModelData)this.getTransformMaterial().getModel(PartialModels.ENGINE_PISTON_LINKAGE).createInstance();

    public HugeDieselEngineInstance(MaterialManager materialManager, HugeDieselEngineBlockEntity blockEntity) {
        super(materialManager, (class_2586)blockEntity);
    }

    public void beginFrame() {
        float shaftR;
        boolean roll90;
        Float angle = ((HugeDieselEngineBlockEntity)this.blockEntity).getTargetAngle();
        class_2680 state = ((HugeDieselEngineBlockEntity)this.blockEntity).method_11010();
        class_2350 facing = (class_2350)state.method_11654((class_2769)HugeDieselEngineBlock.FACING);
        class_2350.class_2351 facingAxis = facing.method_10166();
        if (angle == null) {
            this.transformed(this.piston, facing, false).translate(0.0, 0.53475, 0.0);
            this.linkage.setEmptyTransform();
            this.connector.setEmptyTransform();
            return;
        }
        PoweredEngineShaftBlockEntity shaft = ((HugeDieselEngineBlockEntity)this.blockEntity).getShaft();
        if (shaft == null) {
            this.transformed(this.piston, facing, false).translate(0.0, 0.53475, 0.0);
            this.linkage.setEmptyTransform();
            this.connector.setEmptyTransform();
            return;
        }
        class_2350.class_2351 axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)shaft);
        boolean bl = roll90 = facingAxis.method_10179() && axis == class_2350.class_2351.field_11052 || facingAxis.method_10178() && axis == class_2350.class_2351.field_11051;
        float f = facing == class_2350.field_11033 ? -90.0f : (facing == class_2350.field_11036 ? 90.0f : (facing == class_2350.field_11039 ? -90.0f : (shaftR = facing == class_2350.field_11034 ? 90.0f : 0.0f)));
        if (roll90) {
            shaftR = facing == class_2350.field_11043 ? 180.0f : (facing == class_2350.field_11035 ? 0.0f : (facing == class_2350.field_11034 ? -90.0f : (facing == class_2350.field_11039 ? 90.0f : 0.0f)));
        }
        angle = Float.valueOf(angle.floatValue() + (float)((double)shaftR * Math.PI / 180.0));
        float sine = class_3532.method_15374((float)angle.floatValue()) * (float)(((class_2350)state.method_11654((class_2769)HugeDieselEngineBlock.FACING)).method_10166() == class_2350.class_2351.field_11052 ? -1 : 1);
        float sine2 = class_3532.method_15374((float)(angle.floatValue() - 1.5707964f)) * (float)(((class_2350)state.method_11654((class_2769)HugeDieselEngineBlock.FACING)).method_10166() == class_2350.class_2351.field_11052 ? -1 : 1);
        float pistonOffset = (1.0f - sine) / 4.0f + 0.4375f;
        this.transformed(this.piston, facing, roll90).translate(0.0, (double)pistonOffset, 0.0);
        ((ModelData)((ModelData)((ModelData)this.transformed(this.linkage, facing, roll90).centre()).translate(0.0, 1.0, 0.0).unCentre()).translate(0.0, (double)pistonOffset, 0.0).translate(0.0, 0.25, 0.5).rotateX((double)(sine2 * 23.0f))).translate(0.0, -0.25, -0.5);
        if (shaft.isEngineForConnectorDisplay(((HugeDieselEngineBlockEntity)this.blockEntity).method_11016())) {
            ((ModelData)((ModelData)this.transformed(this.connector, facing, roll90).translate(0.0, 2.0, 0.0).centre()).rotateXRadians((double)(-angle.floatValue() + 1.5707964f) - (facingAxis.method_10178() ? Math.PI : 0.0))).unCentre();
        } else {
            this.connector.setEmptyTransform();
        }
    }

    protected ModelData transformed(ModelData modelData, class_2350 facing, boolean roll90) {
        return (ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)modelData.loadIdentity().translate((class_2382)this.getInstancePosition())).centre()).rotateY((double)AngleHelper.horizontalAngle((class_2350)facing))).rotateX((double)(AngleHelper.verticalAngle((class_2350)facing) + 90.0f))).rotateY(roll90 ? -90.0 : 0.0)).unCentre();
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.piston, this.connector, this.linkage});
    }

    protected void remove() {
        this.piston.delete();
        this.linkage.delete();
        this.connector.delete();
    }
}

