/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.datagen.recipes;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import org.slf4j.Logger;
import rbasamoyai.createbigcannons.datagen.recipes.BuiltUpHeatingRecipeProvider;
import rbasamoyai.createbigcannons.datagen.recipes.CannonCastRecipeProvider;
import rbasamoyai.createbigcannons.datagen.recipes.DrillBoringRecipeProvider;
import rbasamoyai.createbigcannons.datagen.recipes.FinishedBlockRecipe;

public abstract class BlockRecipeProvider
implements class_2405 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final class_7784 output;
    protected final String modid;
    protected class_2960 info;
    protected static final List<class_2405.class_7857<BlockRecipeProvider>> GENERATORS = new ArrayList<class_2405.class_7857<BlockRecipeProvider>>();

    public BlockRecipeProvider(String modid, class_7784 output) {
        this.modid = modid;
        this.output = output;
    }

    public static void registerAll(class_2403.class_7856 gen) {
        GENERATORS.add((class_2405.class_7857<BlockRecipeProvider>)((class_2405.class_7857)CannonCastRecipeProvider::new));
        GENERATORS.add((class_2405.class_7857<BlockRecipeProvider>)((class_2405.class_7857)BuiltUpHeatingRecipeProvider::new));
        GENERATORS.add((class_2405.class_7857<BlockRecipeProvider>)((class_2405.class_7857)DrillBoringRecipeProvider::new));
        gen.method_46566(output -> new class_2405(){

            public CompletableFuture<?> method_10319(class_7403 cache) {
                return CompletableFuture.allOf((CompletableFuture[])GENERATORS.stream().map(gen -> ((BlockRecipeProvider)gen.create(output)).method_10319(cache)).toArray(CompletableFuture[]::new));
            }

            public String method_10321() {
                return "Create Big Cannons Block Recipes";
            }
        });
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        Path path = this.output.method_45971();
        HashMap map = new HashMap();
        this.registerRecipes(recipe -> {
            if (map.put(recipe.id(), recipe) != null) {
                throw new IllegalStateException("Duplicate block recipe " + recipe.id());
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(e -> {
            class_2960 id = (class_2960)e.getKey();
            FinishedBlockRecipe recipe = (FinishedBlockRecipe)e.getValue();
            return class_2405.method_10320((class_7403)cache, (JsonElement)recipe.serializeRecipe(), (Path)path.resolve("data/" + id.method_12836() + "/block_recipes/" + id.method_12832() + ".json"));
        }).toArray(CompletableFuture[]::new));
    }

    private static void saveRecipe(class_7403 cache, JsonObject obj, Path path) {
        try {
            String s = GSON.toJson((JsonElement)obj);
            HashCode s1 = Hashing.sha1().hashUnencodedChars((CharSequence)s);
            cache.method_43346(path, s.getBytes(), s1);
        }
        catch (IOException e) {
            LOGGER.error("Couldn't save block recipe {}", (Object)path, (Object)e);
        }
    }

    protected abstract void registerRecipes(Consumer<FinishedBlockRecipe> var1);

    public String method_10321() {
        return "Create Big Cannons Block Recipes: " + (Comparable)((Object)(this.info == null ? "unknown id" : this.info));
    }
}

