/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.builtup;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3499;
import net.minecraft.class_7923;
import rbasamoyai.createbigcannons.base.CBCRegistries;
import rbasamoyai.createbigcannons.cannons.CannonBehavior;
import rbasamoyai.createbigcannons.cannons.ICannonBlockEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBehavior;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.IBigCannonBlockEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.material.BigCannonMaterial;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.crafting.BlockRecipe;
import rbasamoyai.createbigcannons.crafting.BlockRecipeFinder;
import rbasamoyai.createbigcannons.crafting.WandActionable;
import rbasamoyai.createbigcannons.crafting.builtup.BuiltUpHeatingRecipe;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastShape;
import rbasamoyai.createbigcannons.index.CBCBigCannonMaterials;
import rbasamoyai.createbigcannons.index.CBCBlockEntities;
import rbasamoyai.createbigcannons.index.CBCBlocks;

public class LayeredBigCannonBlockEntity
extends SmartBlockEntity
implements IBigCannonBlockEntity,
WandActionable {
    private static final class_2753 FACING = class_2741.field_12525;
    private static final Object BUILT_UP_HEATING_RECIPES_KEY = new Object();
    private BigCannonBehavior cannonBehavior;
    private BigCannonMaterial baseMaterial;
    private Map<CannonCastShape, class_2248> layeredBlocks = new HashMap<CannonCastShape, class_2248>();
    private Multimap<class_2350, CannonCastShape> layersConnectedTowards = HashMultimap.create();
    private class_2350 currentFacing;
    private TransportedItemStack clockStack = new TransportedItemStack(class_1799.field_8037);
    private int completionProgress;

    public LayeredBigCannonBlockEntity(class_2591<? extends LayeredBigCannonBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        if (state.method_28498((class_2769)FACING)) {
            this.currentFacing = (class_2350)state.method_11654((class_2769)FACING);
        }
    }

    @Override
    public BigCannonBehavior cannonBehavior() {
        return this.cannonBehavior;
    }

    public void setBaseMaterial(BigCannonMaterial material) {
        this.baseMaterial = material;
    }

    public BigCannonMaterial getBaseMaterial() {
        return this.baseMaterial;
    }

    public void tick() {
        super.tick();
        class_2680 state = this.method_11010();
        if (!this.method_10997().field_9236 && this.isEmpty()) {
            this.method_11012();
            this.method_10997().method_8652(this.field_11867, class_2246.field_10124.method_9564(), 19);
            return;
        }
        if (state.method_28498((class_2769)FACING)) {
            class_2350 previousFacing = this.currentFacing;
            this.currentFacing = (class_2350)state.method_11654((class_2769)FACING);
            if (previousFacing != null && previousFacing != this.currentFacing) {
                class_2350.class_2351 rotationAxis = LayeredBigCannonBlockEntity.getRotationAxis(previousFacing, this.currentFacing);
                class_2470 rotation = LayeredBigCannonBlockEntity.getRotationBetween(previousFacing, this.currentFacing, rotationAxis);
                HashMultimap newLayersConnected = HashMultimap.create();
                Iterator iterator = this.layersConnectedTowards.keySet().iterator();
                while (iterator.hasNext()) {
                    class_2350 dir;
                    class_2350 dc = dir = (class_2350)iterator.next();
                    for (int i = 0; i < rotation.ordinal(); ++i) {
                        dc = dc.method_35833(rotationAxis);
                    }
                    newLayersConnected.putAll((Object)dc, (Iterable)this.layersConnectedTowards.get((Object)dir));
                }
                this.layersConnectedTowards = newLayersConnected;
                this.method_5431();
            }
        }
        if (!this.method_10997().field_9236) {
            if (this.clockStack.processedBy == AllFanProcessingTypes.BLASTING) {
                this.clockStack.processedBy = AllFanProcessingTypes.NONE;
                this.clockStack.processingTime = -1;
                ++this.completionProgress;
                this.sendData();
                int cap = (Integer)CBCConfigs.SERVER.crafting.builtUpCannonHeatingTime.get();
                if (this.completionProgress >= cap) {
                    this.completionProgress = cap;
                    if (!this.tryFinishHeating()) {
                        this.completionProgress = 0;
                    }
                }
            } else if (this.completionProgress > 0) {
                --this.completionProgress;
                this.sendData();
            }
        }
    }

    private boolean tryFinishHeating() {
        List<BlockRecipe> recipes = BlockRecipeFinder.get(BUILT_UP_HEATING_RECIPES_KEY, this.method_10997(), this::matchingRecipeCache);
        if (recipes.isEmpty()) {
            return false;
        }
        Optional<BlockRecipe> recipe = recipes.stream().filter(r -> r.matches(this.method_10997(), this.field_11867)).findFirst();
        if (!recipe.isPresent()) {
            return false;
        }
        recipe.get().assembleInWorld(this.method_10997(), this.field_11867);
        return true;
    }

    @Override
    public class_1269 onWandUsed(class_1838 context) {
        if (!this.method_10997().field_9236) {
            this.tryFinishHeating();
        }
        return class_1269.method_29236((boolean)this.method_10997().field_9236);
    }

    private boolean matchingRecipeCache(BlockRecipe recipe) {
        return recipe instanceof BuiltUpHeatingRecipe;
    }

    private static class_2350.class_2351 getRotationAxis(class_2350 prev, class_2350 current) {
        EnumSet<class_2350.class_2351> axes = EnumSet.allOf(class_2350.class_2351.class);
        axes.remove(prev.method_10166());
        axes.remove(current.method_10166());
        return (class_2350.class_2351)axes.stream().findFirst().orElseThrow(() -> new IllegalStateException("Failed to find the rotation axes of two different axes"));
    }

    private static class_2470 getRotationBetween(class_2350 prev, class_2350 current, class_2350.class_2351 axis) {
        if (prev == current) {
            return class_2470.field_11467;
        }
        if (prev == current.method_10153()) {
            return class_2470.field_11464;
        }
        return prev.method_35833(axis) == current ? class_2470.field_11463 : class_2470.field_11465;
    }

    public void setLayer(CannonCastShape layer, class_2248 block) {
        this.layeredBlocks.put(layer, block);
    }

    public class_2248 getLayer(CannonCastShape layer) {
        return this.layeredBlocks.get(layer);
    }

    public void removeLayer(CannonCastShape layer) {
        this.layeredBlocks.remove(layer);
        for (class_2350 dir : Iterate.directions) {
            this.setLayerConnectedTo(dir, layer, false);
        }
    }

    public boolean hasLayer(CannonCastShape layer) {
        return this.layeredBlocks.containsKey(layer);
    }

    public Map<CannonCastShape, class_2248> getLayers() {
        return this.layeredBlocks;
    }

    public CannonCastShape getTopCannonShape() {
        if (this.layeredBlocks.isEmpty()) {
            return null;
        }
        CannonCastShape result = null;
        for (CannonCastShape shape : this.layeredBlocks.keySet()) {
            if (result != null && result.diameter() >= shape.diameter()) continue;
            result = shape;
        }
        return result;
    }

    public CannonCastShape getTopConnectedLayer(class_2350 direction) {
        if (!this.layersConnectedTowards.containsKey((Object)direction)) {
            return null;
        }
        CannonCastShape result = null;
        for (CannonCastShape shape : this.layersConnectedTowards.get((Object)direction)) {
            if (result != null && result.diameter() >= shape.diameter()) continue;
            result = shape;
        }
        return result;
    }

    public LayeredBigCannonBlockEntity getSplitBlockEntity(Collection<CannonCastShape> layers, class_2350 from, @Nullable class_2350 movementDirection) {
        boolean forced = movementDirection != null && from == movementDirection.method_10153();
        LayeredBigCannonBlockEntity newLayer = new LayeredBigCannonBlockEntity((class_2591<? extends LayeredBigCannonBlockEntity>)((class_2591)CBCBlockEntities.LAYERED_CANNON.get()), this.field_11867, this.method_11010());
        newLayer.baseMaterial = this.baseMaterial;
        newLayer.currentFacing = this.currentFacing;
        for (CannonCastShape layer : layers) {
            if (!this.layeredBlocks.containsKey(layer) || from != null && !this.isLayerConnectedTo(from, layer) && !forced) continue;
            newLayer.setLayer(layer, this.getLayer(layer));
            for (class_2350 dir : Iterate.directions) {
                newLayer.setLayerConnectedTo(dir, layer, this.isLayerConnectedTo(dir, layer));
            }
        }
        for (class_2350 dir : Iterate.directions) {
            boolean connect = this.cannonBehavior.isConnectedTo(dir);
            newLayer.cannonBehavior.setConnectedFace(dir, connect);
        }
        return newLayer;
    }

    public LayeredBigCannonBlockEntity getSplitBlockEntity(CannonCastShape fullShape, class_2350 from, @Nullable class_2350 movementDirection) {
        return this.getSplitBlockEntity(Arrays.asList(fullShape), from, movementDirection);
    }

    public void removeLayersOfOther(LayeredBigCannonBlockEntity other) {
        for (CannonCastShape layer : other.layeredBlocks.keySet()) {
            this.removeLayer(layer);
        }
    }

    public void addLayersOfOther(LayeredBigCannonBlockEntity other) {
        for (Map.Entry<CannonCastShape, class_2248> layer : other.layeredBlocks.entrySet()) {
            CannonCastShape shape = layer.getKey();
            this.setLayer(shape, layer.getValue());
            for (class_2350 dir : Iterate.directions) {
                this.setLayerConnectedTo(dir, shape, other.isLayerConnectedTo(dir, shape));
            }
        }
        this.method_5431();
    }

    public class_2248 getSimplifiedBlock() {
        return this.isEmpty() ? class_2246.field_10124 : (this.layeredBlocks.size() == 1 ? this.layeredBlocks.values().stream().findAny().get() : (class_2248)CBCBlocks.BUILT_UP_CANNON.get());
    }

    public void updateBlockstate() {
        class_2248 block = this.getSimplifiedBlock();
        if (this.method_11010().method_26204() != block) {
            class_2680 newState = block.method_9564();
            if (newState.method_28498((class_2769)FACING) && this.method_11010().method_28498((class_2769)FACING)) {
                newState = (class_2680)newState.method_11657((class_2769)FACING, (Comparable)((class_2350)this.method_11010().method_11654((class_2769)FACING)));
            }
            this.method_11012();
            this.method_10997().method_8652(this.field_11867, newState, 19);
            if (!this.method_11017().method_20526(newState)) {
                return;
            }
            class_2586 be = this.method_10997().method_8321(this.field_11867);
            if (!(be instanceof LayeredBigCannonBlockEntity)) {
                return;
            }
            LayeredBigCannonBlockEntity newLayered = (LayeredBigCannonBlockEntity)be;
            newLayered.layeredBlocks = this.layeredBlocks;
            newLayered.layersConnectedTowards = this.layersConnectedTowards;
            newLayered.baseMaterial = this.baseMaterial;
            newLayered.currentFacing = (class_2350)newState.method_11654((class_2769)FACING);
            newLayered.method_5431();
            for (class_2350 dir : Iterate.directions) {
                class_2338 pos1 = newLayered.field_11867.method_10093(dir);
                class_2586 be1 = newLayered.field_11863.method_8321(pos1);
                class_2680 state1 = newLayered.field_11863.method_8320(pos1);
                if (be1 instanceof ICannonBlockEntity) {
                    BigCannonBlock cBlock;
                    ICannonBlockEntity cbe = (ICannonBlockEntity)be1;
                    class_2248 class_22482 = state1.method_26204();
                    if (class_22482 instanceof BigCannonBlock && (cBlock = (BigCannonBlock)class_22482).getCannonMaterialInLevel((class_1936)newLayered.field_11863, state1, pos1) == newLayered.baseMaterial) {
                        boolean connect = this.cannonBehavior.isConnectedTo(dir);
                        newLayered.cannonBehavior.setConnectedFace(dir, connect);
                        ((CannonBehavior)((Object)cbe.cannonBehavior())).setConnectedFace(dir.method_10153(), connect);
                    }
                }
                if (!(be1 instanceof LayeredBigCannonBlockEntity)) continue;
                LayeredBigCannonBlockEntity layered1 = (LayeredBigCannonBlockEntity)be1;
                if (layered1.baseMaterial != this.baseMaterial) continue;
                for (CannonCastShape shape : this.getConnectedTo(dir)) {
                    layered1.setLayerConnectedTo(dir.method_10153(), shape, true);
                }
                layered1.method_5431();
            }
        }
    }

    public void setLayerConnectedTo(class_2350 direction, CannonCastShape shape, boolean connected) {
        if (!this.layeredBlocks.containsKey(shape)) {
            return;
        }
        if (connected) {
            this.layersConnectedTowards.put((Object)direction, (Object)shape);
        } else {
            this.layersConnectedTowards.remove((Object)direction, (Object)shape);
        }
    }

    public boolean isLayerConnectedTo(class_2350 direction, CannonCastShape shape) {
        return this.layersConnectedTowards.get((Object)direction).contains(shape);
    }

    public boolean isEmpty() {
        return this.layeredBlocks.isEmpty();
    }

    public Collection<CannonCastShape> getConnectedTo(class_2350 direction) {
        return this.layersConnectedTowards.get((Object)direction);
    }

    public boolean isCollidingWith(class_3499.class_3501 info, LayeredBigCannonBlockEntity other, class_2350 dir) {
        if (this.currentFacing == null || dir.method_10166() != this.currentFacing.method_10166()) {
            return true;
        }
        if (info.comp_1343() == null || !info.comp_1343().method_10545("id")) {
            return true;
        }
        if (other.baseMaterial != this.baseMaterial) {
            return true;
        }
        Set set = this.layeredBlocks.keySet().stream().map(CannonCastShape::diameter).collect(Collectors.toCollection(HashSet::new));
        Set set1 = other.layeredBlocks.keySet().stream().map(CannonCastShape::diameter).collect(Collectors.toCollection(HashSet::new));
        set.retainAll(set1);
        return !set.isEmpty();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.cannonBehavior = new BigCannonBehavior(this, this::canLoadBlock);
        behaviours.add(this.cannonBehavior);
        behaviours.add((BlockEntityBehaviour)new TransportedItemStackHandlerBehaviour((SmartBlockEntity)this, this::clockCallback));
    }

    private void clockCallback(float maxDistanceFromCenter, Function<TransportedItemStack, TransportedItemStackHandlerBehaviour.TransportedResult> func) {
        func.apply(this.clockStack);
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.baseMaterial != null) {
            tag.method_10582("Material", this.baseMaterial.name().toString());
        }
        class_2499 layerTag = new class_2499();
        class_2378<CannonCastShape> cannonCastShapeRegistry = CBCRegistries.cannonCastShapes();
        for (Map.Entry<CannonCastShape, class_2248> e : this.layeredBlocks.entrySet()) {
            class_2487 entryTag = new class_2487();
            entryTag.method_10582("Shape", cannonCastShapeRegistry.method_10221((Object)e.getKey()).toString());
            entryTag.method_10582("Block", class_7923.field_41175.method_10221((Object)e.getValue()).toString());
            layerTag.add((Object)entryTag);
        }
        tag.method_10566("Layers", (class_2520)layerTag);
        class_2487 layerConnectionTag = new class_2487();
        for (class_2350 dir : Iterate.directions) {
            if (!this.layersConnectedTowards.containsKey((Object)dir)) continue;
            layerConnectionTag.method_10566(dir.method_15434(), (class_2520)this.layersConnectedTowards.get((Object)dir).stream().map(arg_0 -> cannonCastShapeRegistry.method_10221(arg_0)).map(class_2960::toString).map(class_2519::method_23256).collect(Collectors.toCollection(class_2499::new)));
        }
        tag.method_10566("LayerConnections", (class_2520)layerConnectionTag);
        if (this.currentFacing != null) {
            tag.method_10582("Facing", this.currentFacing.method_15434());
        }
        if (this.completionProgress > 0) {
            tag.method_10569("Progress", this.completionProgress);
        }
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        boolean justBored = tag.method_10545("JustBored");
        this.layersConnectedTowards.clear();
        class_2487 layerConnectionTag = tag.method_10562("LayerConnections");
        class_2378<CannonCastShape> cannonCastShapeRegistry = CBCRegistries.cannonCastShapes();
        for (class_2350 dir : Iterate.directions) {
            if (!layerConnectionTag.method_10545(dir.method_15434())) continue;
            class_2499 connections = layerConnectionTag.method_10554(dir.method_15434(), 8);
            for (int i = 0; i < connections.size(); ++i) {
                CannonCastShape shape = (CannonCastShape)cannonCastShapeRegistry.method_10223(new class_2960(connections.method_10608(i)));
                if (shape == null) continue;
                this.layersConnectedTowards.put((Object)dir, (Object)shape);
            }
        }
        if (justBored) {
            tag.method_10551("JustBored");
            return;
        }
        BigCannonMaterial bigCannonMaterial = this.baseMaterial = tag.method_10545("Material") ? BigCannonMaterial.fromNameOrNull(new class_2960(tag.method_10558("Material"))) : null;
        if (this.baseMaterial == null) {
            this.baseMaterial = CBCBigCannonMaterials.STEEL;
        }
        this.layeredBlocks.clear();
        class_2499 layers = tag.method_10554("Layers", 10);
        for (int i = 0; i < layers.size(); ++i) {
            class_2487 entry = layers.method_10602(i);
            this.layeredBlocks.put((CannonCastShape)cannonCastShapeRegistry.method_10223(new class_2960(entry.method_10558("Shape"))), (class_2248)class_7923.field_41175.method_10223(new class_2960(entry.method_10558("Block"))));
        }
        this.currentFacing = tag.method_10545("Facing") ? class_2350.method_10168((String)tag.method_10558("Facing")) : null;
        this.completionProgress = tag.method_10550("Progress");
    }

    @Override
    public boolean canLoadBlock(class_3499.class_3501 blockInfo) {
        return false;
    }
}

