/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.builtup;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.IBigCannonBlockEntity;
import rbasamoyai.createbigcannons.crafting.BlockRecipe;
import rbasamoyai.createbigcannons.crafting.BlockRecipeIngredient;
import rbasamoyai.createbigcannons.crafting.BlockRecipeSerializer;
import rbasamoyai.createbigcannons.crafting.BlockRecipeType;
import rbasamoyai.createbigcannons.crafting.builtup.LayeredBigCannonBlockEntity;

public class BuiltUpHeatingRecipe
implements BlockRecipe {
    private final Set<BlockRecipeIngredient> layers;
    private final class_2248 result;
    private final class_2960 id;
    private static final class_2753 FACING = class_2741.field_12525;

    public BuiltUpHeatingRecipe(Set<BlockRecipeIngredient> requiredLayers, class_2248 result, class_2960 id) {
        this.layers = requiredLayers;
        this.result = result;
        this.id = id;
    }

    public Set<BlockRecipeIngredient> layers() {
        return this.layers;
    }

    public class_2248 result() {
        return this.result;
    }

    @Override
    public boolean matches(class_1937 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (!(class_25862 instanceof LayeredBigCannonBlockEntity)) {
            return false;
        }
        LayeredBigCannonBlockEntity layered = (LayeredBigCannonBlockEntity)class_25862;
        if (layered.getLayers().size() != this.layers.size()) {
            return false;
        }
        HashSet<BlockRecipeIngredient> copy = new HashSet<BlockRecipeIngredient>(this.layers);
        for (class_2248 block : layered.getLayers().values()) {
            Iterator iter = copy.iterator();
            while (iter.hasNext()) {
                BlockRecipeIngredient pred = (BlockRecipeIngredient)iter.next();
                if (!pred.test(block.method_9564())) continue;
                iter.remove();
                break;
            }
            if (!copy.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void assembleInWorld(class_1937 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (!(class_25862 instanceof LayeredBigCannonBlockEntity)) {
            return;
        }
        LayeredBigCannonBlockEntity layered = (LayeredBigCannonBlockEntity)class_25862;
        class_2680 oldState = level.method_8320(pos);
        if (!oldState.method_28498((class_2769)FACING)) {
            return;
        }
        layered.method_11012();
        class_2680 state = this.result.method_9564();
        if (state.method_28498((class_2769)FACING)) {
            state = (class_2680)state.method_11657((class_2769)FACING, (Comparable)((class_2350)oldState.method_11654((class_2769)FACING)));
        }
        level.method_8652(pos, state, 11);
        level.method_8396(null, pos, class_3417.field_21921, class_3419.field_15245, 1.0f, 2.0f);
        class_2586 class_25863 = level.method_8321(pos);
        if (!(class_25863 instanceof IBigCannonBlockEntity)) {
            return;
        }
        IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)class_25863;
        BigCannonBlock.onPlace(level, pos);
    }

    @Override
    public class_2248 getResultBlock() {
        return this.result;
    }

    @Override
    public class_2960 getId() {
        return this.id;
    }

    @Override
    public BlockRecipeSerializer<?> getSerializer() {
        return BlockRecipeSerializer.BUILT_UP_HEATING;
    }

    @Override
    public BlockRecipeType<?> getType() {
        return BlockRecipeType.BUILT_UP_HEATING;
    }

    public static class Serializer
    implements BlockRecipeSerializer<BuiltUpHeatingRecipe> {
        @Override
        public BuiltUpHeatingRecipe fromJson(class_2960 id, JsonObject obj) {
            JsonArray layerArr = obj.getAsJsonArray("layers");
            HashSet<BlockRecipeIngredient> layers = new HashSet<BlockRecipeIngredient>();
            if (layerArr != null) {
                for (JsonElement el : layerArr) {
                    layers.add(BlockRecipeIngredient.fromJson(el));
                }
            }
            class_2248 result = (class_2248)class_7923.field_41175.method_10223(new class_2960(obj.get("result").getAsString()));
            return new BuiltUpHeatingRecipe(layers, result, id);
        }

        @Override
        public BuiltUpHeatingRecipe fromNetwork(class_2960 id, class_2540 buf) {
            int sz = buf.method_10816();
            HashSet<BlockRecipeIngredient> layers = sz == 0 ? null : new HashSet<BlockRecipeIngredient>();
            for (int i = 0; i < sz; ++i) {
                layers.add(BlockRecipeIngredient.fromNetwork(buf));
            }
            class_2248 result = (class_2248)class_7923.field_41175.method_10223(buf.method_10810());
            return new BuiltUpHeatingRecipe(layers, result, id);
        }

        @Override
        public void toNetwork(class_2540 buf, BuiltUpHeatingRecipe recipe) {
            buf.method_10804(recipe.layers == null ? 0 : recipe.layers.size());
            if (recipe.layers != null && !recipe.layers.isEmpty()) {
                recipe.layers.forEach(p -> p.toNetwork(buf));
            }
            buf.method_10812(class_7923.field_41175.method_10221((Object)recipe.result));
        }
    }
}

