/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.schedule;

import com.google.common.collect.ImmutableList;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllPackets;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.GlobalRailwayManager;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.schedule.DestinationSuggestions;
import com.simibubi.create.content.trains.schedule.IScheduleInput;
import com.simibubi.create.content.trains.schedule.Schedule;
import com.simibubi.create.content.trains.schedule.ScheduleDataEntry;
import com.simibubi.create.content.trains.schedule.ScheduleEditPacket;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.ScheduleMenu;
import com.simibubi.create.content.trains.schedule.condition.ScheduleWaitCondition;
import com.simibubi.create.content.trains.schedule.condition.ScheduledDelay;
import com.simibubi.create.content.trains.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.trains.schedule.destination.ScheduleInstruction;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.ModularGuiLine;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.menu.GhostItemSubmitPacket;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Indicator;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.IntAttached;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor.ScreenAccessor;
import io.github.fabricators_of_create.porting_lib.util.KeyBindingHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import me.pepperbell.simplenetworking.C2SPacket;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_768;
import org.lwjgl.opengl.GL11;

public class ScheduleScreen
extends AbstractSimiContainerScreen<ScheduleMenu> {
    private static final int CARD_HEADER = 22;
    private static final int CARD_WIDTH = 195;
    private List<class_768> extraAreas = Collections.emptyList();
    private List<LerpedFloat> horizontalScrolls = new ArrayList<LerpedFloat>();
    private LerpedFloat scroll = LerpedFloat.linear().startWithValue(0.0);
    private Schedule schedule;
    private IconButton confirmButton;
    private IconButton cyclicButton;
    private Indicator cyclicIndicator;
    private IconButton resetProgress;
    private IconButton skipProgress;
    private ScheduleInstruction editingDestination;
    private ScheduleWaitCondition editingCondition;
    private SelectionScrollInput scrollInput;
    private Label scrollInputLabel;
    private IconButton editorConfirm;
    private IconButton editorDelete;
    private ModularGuiLine editorSubWidgets;
    private Consumer<Boolean> onEditorClose;
    private DestinationSuggestions destinationSuggestions;
    private class_2561 clickToEdit = Lang.translateDirect("gui.schedule.lmb_edit", new Object[0]).method_27695(new class_124[]{class_124.field_1063, class_124.field_1056});
    private class_2561 rClickToDelete = Lang.translateDirect("gui.schedule.rmb_remove", new Object[0]).method_27695(new class_124[]{class_124.field_1063, class_124.field_1056});

    public ScheduleScreen(ScheduleMenu menu, class_1661 inv, class_2561 title) {
        super(menu, inv, title);
        this.schedule = new Schedule();
        class_2487 tag = ((class_1799)menu.contentHolder).method_7948().method_10562("Schedule");
        if (!tag.method_33133()) {
            this.schedule = Schedule.fromTag(tag);
        }
        menu.slotsActive = false;
        this.editorSubWidgets = new ModularGuiLine();
    }

    @Override
    protected void method_25426() {
        AllGuiTextures bg = AllGuiTextures.SCHEDULE;
        this.setWindowSize(bg.width, bg.height);
        super.method_25426();
        this.method_37067();
        this.confirmButton = new IconButton(this.field_2776 + bg.width - 42, this.field_2800 + bg.height - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.field_22787.field_1724.method_7346());
        this.method_37063(this.confirmButton);
        this.cyclicIndicator = new Indicator(this.field_2776 + 21, this.field_2800 + 196, Components.immutableEmpty());
        this.cyclicIndicator.state = this.schedule.cyclic ? Indicator.State.ON : Indicator.State.OFF;
        this.method_37063(this.cyclicIndicator);
        this.cyclicButton = new IconButton(this.field_2776 + 21, this.field_2800 + 202, AllIcons.I_REFRESH);
        this.cyclicButton.withCallback(() -> {
            this.schedule.cyclic = !this.schedule.cyclic;
            this.cyclicIndicator.state = this.schedule.cyclic ? Indicator.State.ON : Indicator.State.OFF;
        });
        List<class_2561> tip = this.cyclicButton.getToolTip();
        tip.add((class_2561)Lang.translateDirect("schedule.loop", new Object[0]));
        tip.add((class_2561)Lang.translateDirect("schedule.loop1", new Object[0]).method_27692(class_124.field_1080));
        tip.add((class_2561)Lang.translateDirect("schedule.loop2", new Object[0]).method_27692(class_124.field_1080));
        this.method_37063(this.cyclicButton);
        this.resetProgress = new IconButton(this.field_2776 + 45, this.field_2800 + 202, AllIcons.I_PRIORITY_VERY_HIGH);
        this.resetProgress.withCallback(() -> {
            this.schedule.savedProgress = 0;
            this.resetProgress.field_22763 = false;
        });
        this.resetProgress.field_22763 = this.schedule.savedProgress > 0 && !this.schedule.entries.isEmpty();
        this.resetProgress.setToolTip((class_2561)Lang.translateDirect("schedule.reset", new Object[0]));
        this.method_37063(this.resetProgress);
        this.skipProgress = new IconButton(this.field_2776 + 63, this.field_2800 + 202, AllIcons.I_PRIORITY_LOW);
        this.skipProgress.withCallback(() -> {
            ++this.schedule.savedProgress;
            this.schedule.savedProgress %= this.schedule.entries.size();
            this.resetProgress.field_22763 = this.schedule.savedProgress > 0;
        });
        this.skipProgress.field_22763 = this.schedule.entries.size() > 1;
        this.skipProgress.setToolTip((class_2561)Lang.translateDirect("schedule.skip", new Object[0]));
        this.method_37063(this.skipProgress);
        this.stopEditing();
        this.extraAreas = ImmutableList.of((Object)new class_768(this.field_2776 + bg.width, this.field_2800 + bg.height - 56, 48, 48));
        this.horizontalScrolls.clear();
        for (int i = 0; i < this.schedule.entries.size(); ++i) {
            this.horizontalScrolls.add(LerpedFloat.linear().startWithValue(0.0));
        }
    }

    protected void startEditing(IScheduleInput field, Consumer<Boolean> onClose, boolean allowDeletion) {
        int i;
        this.onEditorClose = onClose;
        this.confirmButton.field_22764 = false;
        this.cyclicButton.field_22764 = false;
        this.cyclicIndicator.field_22764 = false;
        this.skipProgress.field_22764 = false;
        this.resetProgress.field_22764 = false;
        this.scrollInput = new SelectionScrollInput(this.field_2776 + 56, this.field_2800 + 65, 143, 16);
        this.scrollInputLabel = new Label(this.field_2776 + 59, this.field_2800 + 69, Components.immutableEmpty()).withShadow();
        this.editorConfirm = new IconButton(this.field_2776 + 56 + 168, this.field_2800 + 65 + 22, AllIcons.I_CONFIRM);
        if (allowDeletion) {
            this.editorDelete = new IconButton(this.field_2776 + 56 - 45, this.field_2800 + 65 + 22, AllIcons.I_TRASH);
        }
        ((ScheduleMenu)this.field_2797).slotsActive = true;
        ((ScheduleMenu)this.field_2797).targetSlotsActive = field.slotsTargeted();
        for (int i2 = 0; i2 < field.slotsTargeted(); ++i2) {
            class_1799 item = field.getItem(i2);
            ((ScheduleMenu)this.field_2797).ghostInventory.setStackInSlot(i2, item);
            AllPackets.getChannel().sendToServer((C2SPacket)new GhostItemSubmitPacket(item, i2));
        }
        if (field instanceof ScheduleInstruction) {
            ScheduleInstruction instruction = (ScheduleInstruction)field;
            int startIndex = 0;
            for (i = 0; i < Schedule.INSTRUCTION_TYPES.size(); ++i) {
                if (!Schedule.INSTRUCTION_TYPES.get(i).getFirst().equals((Object)instruction.getId())) continue;
                startIndex = i;
            }
            this.editingDestination = instruction;
            this.updateEditorSubwidgets(this.editingDestination);
            this.scrollInput.forOptions(Schedule.getTypeOptions(Schedule.INSTRUCTION_TYPES)).titled(Lang.translateDirect("schedule.instruction_type", new Object[0])).writingTo(this.scrollInputLabel).calling(index -> {
                ScheduleInstruction newlyCreated = Schedule.INSTRUCTION_TYPES.get((int)index).getSecond().get();
                if (this.editingDestination.getId().equals((Object)newlyCreated.getId())) {
                    return;
                }
                this.editingDestination = newlyCreated;
                this.updateEditorSubwidgets(this.editingDestination);
            }).setState(startIndex);
        }
        if (field instanceof ScheduleWaitCondition) {
            ScheduleWaitCondition cond = (ScheduleWaitCondition)field;
            int startIndex = 0;
            for (i = 0; i < Schedule.CONDITION_TYPES.size(); ++i) {
                if (!Schedule.CONDITION_TYPES.get(i).getFirst().equals((Object)cond.getId())) continue;
                startIndex = i;
            }
            this.editingCondition = cond;
            this.updateEditorSubwidgets(this.editingCondition);
            this.scrollInput.forOptions(Schedule.getTypeOptions(Schedule.CONDITION_TYPES)).titled(Lang.translateDirect("schedule.condition_type", new Object[0])).writingTo(this.scrollInputLabel).calling(index -> {
                ScheduleWaitCondition newlyCreated = Schedule.CONDITION_TYPES.get((int)index).getSecond().get();
                if (this.editingCondition.getId().equals((Object)newlyCreated.getId())) {
                    return;
                }
                this.editingCondition = newlyCreated;
                this.updateEditorSubwidgets(this.editingCondition);
            }).setState(startIndex);
        }
        this.method_37063(this.scrollInput);
        this.method_37063(this.scrollInputLabel);
        this.method_37063(this.editorConfirm);
        if (allowDeletion) {
            this.method_37063(this.editorDelete);
        }
    }

    private void onDestinationEdited(String text) {
        if (this.destinationSuggestions != null) {
            this.destinationSuggestions.method_23934();
        }
    }

    protected void stopEditing() {
        this.confirmButton.field_22764 = true;
        this.cyclicButton.field_22764 = true;
        this.cyclicIndicator.field_22764 = true;
        this.skipProgress.field_22764 = true;
        this.resetProgress.field_22764 = true;
        if (this.editingCondition == null && this.editingDestination == null) {
            return;
        }
        this.destinationSuggestions = null;
        this.method_37066(this.scrollInput);
        this.method_37066(this.scrollInputLabel);
        this.method_37066(this.editorConfirm);
        this.method_37066(this.editorDelete);
        ScheduleDataEntry editing = this.editingCondition == null ? this.editingDestination : this.editingCondition;
        for (int i = 0; i < editing.slotsTargeted(); ++i) {
            editing.setItem(i, ((ScheduleMenu)this.field_2797).ghostInventory.getStackInSlot(i));
            AllPackets.getChannel().sendToServer((C2SPacket)new GhostItemSubmitPacket(class_1799.field_8037, i));
        }
        this.editorSubWidgets.saveValues(editing.getData());
        this.editorSubWidgets.forEach(x$0 -> this.method_37066((class_364)x$0));
        this.editorSubWidgets.clear();
        this.editingCondition = null;
        this.editingDestination = null;
        this.editorConfirm = null;
        this.editorDelete = null;
        ((ScheduleMenu)this.field_2797).slotsActive = false;
        this.method_25426();
    }

    protected void updateEditorSubwidgets(IScheduleInput field) {
        this.destinationSuggestions = null;
        ((ScheduleMenu)this.field_2797).targetSlotsActive = field.slotsTargeted();
        this.editorSubWidgets.forEach(x$0 -> this.method_37066((class_364)x$0));
        this.editorSubWidgets.clear();
        field.initConfigurationWidgets(new ModularGuiLineBuilder(this.field_22793, this.editorSubWidgets, this.field_2776 + 77, this.field_2800 + 92).speechBubble());
        this.editorSubWidgets.loadValues(field.getData(), x$0 -> this.method_37063((class_364)x$0), x$0 -> {
            class_364 cfr_ignored_0 = (class_364)this.method_37060((class_4068)x$0);
        });
        if (!(field instanceof DestinationInstruction)) {
            return;
        }
        this.editorSubWidgets.forEach(e -> {
            if (!(e instanceof class_342)) {
                return;
            }
            class_342 destinationBox = (class_342)e;
            this.destinationSuggestions = new DestinationSuggestions(this.field_22787, (class_437)this, destinationBox, this.field_22793, this.getViableStations(field), this.field_2800 + 33);
            this.destinationSuggestions.method_23933(true);
            this.destinationSuggestions.method_23934();
            destinationBox.method_1863(this::onDestinationEdited);
        });
    }

    private List<IntAttached<String>> getViableStations(IScheduleInput field) {
        GlobalRailwayManager railwayManager = Create.RAILWAYS.sided(null);
        HashSet<TrackGraph> viableGraphs = new HashSet<TrackGraph>(railwayManager.trackNetworks.values());
        for (ScheduleEntry entry : this.schedule.entries) {
            String filter;
            DestinationInstruction destination;
            ScheduleInstruction scheduleInstruction = entry.instruction;
            if (!(scheduleInstruction instanceof DestinationInstruction) || (destination = (DestinationInstruction)scheduleInstruction) == field || (filter = destination.getFilterForRegex()).isBlank()) continue;
            Iterator iterator = viableGraphs.iterator();
            block1: while (iterator.hasNext()) {
                TrackGraph trackGraph = (TrackGraph)iterator.next();
                for (GlobalStation station2 : trackGraph.getPoints(EdgePointType.STATION)) {
                    if (!station2.name.matches(filter)) continue;
                    continue block1;
                }
                iterator.remove();
            }
        }
        if (viableGraphs.isEmpty()) {
            viableGraphs = new HashSet<TrackGraph>(railwayManager.trackNetworks.values());
        }
        class_243 position = this.field_22787.field_1724.method_19538();
        HashSet visited = new HashSet();
        return viableGraphs.stream().flatMap(g -> g.getPoints(EdgePointType.STATION).stream()).filter(station -> station.blockEntityPos != null).filter(station -> visited.add(station.name)).map(station -> IntAttached.with((int)class_243.method_24955((class_2382)station.blockEntityPos).method_1022(position), station.name)).toList();
    }

    @Override
    protected void method_37432() {
        super.method_37432();
        this.scroll.tickChaser();
        for (LerpedFloat lerpedFloat : this.horizontalScrolls) {
            lerpedFloat.tickChaser();
        }
        if (this.destinationSuggestions != null) {
            this.destinationSuggestions.tick();
        }
        this.schedule.savedProgress = this.schedule.entries.isEmpty() ? 0 : class_3532.method_15340((int)this.schedule.savedProgress, (int)0, (int)(this.schedule.entries.size() - 1));
        this.resetProgress.field_22763 = this.schedule.savedProgress > 0;
        this.skipProgress.field_22763 = this.schedule.entries.size() > 1;
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        partialTicks = this.field_22787.method_1488();
        if (((ScheduleMenu)this.field_2797).slotsActive) {
            super.method_25394(graphics, mouseX, mouseY, partialTicks);
        } else {
            this.method_25420(graphics);
            this.method_2389(graphics, partialTicks, mouseX, mouseY);
            for (class_4068 widget : ((ScreenAccessor)this).port_lib$getRenderables()) {
                widget.method_25394(graphics, mouseX, mouseY, partialTicks);
            }
            this.renderForeground(graphics, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderSchedule(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        class_4587 matrixStack = graphics.method_51448();
        UIRenderHelper.swapAndBlitColor(this.field_22787.method_1522(), UIRenderHelper.framebuffer);
        UIRenderHelper.drawStretched(graphics, this.field_2776 + 33, this.field_2800 + 16, 3, 173, 200, AllGuiTextures.SCHEDULE_STRIP_DARK);
        int yOffset = 25;
        List<ScheduleEntry> entries = this.schedule.entries;
        float scrollOffset = -this.scroll.getValue(partialTicks);
        for (int i = 0; i <= entries.size(); ++i) {
            if (this.schedule.savedProgress == i && !this.schedule.entries.isEmpty()) {
                matrixStack.method_22903();
                float expectedY = scrollOffset + (float)this.field_2800 + (float)yOffset + 4.0f;
                float actualY = class_3532.method_15363((float)expectedY, (float)(this.field_2800 + 18), (float)(this.field_2800 + 170));
                matrixStack.method_46416(0.0f, actualY, 0.0f);
                (expectedY == actualY ? AllGuiTextures.SCHEDULE_POINTER : AllGuiTextures.SCHEDULE_POINTER_OFFSCREEN).render(graphics, this.field_2776, 0);
                matrixStack.method_22909();
            }
            this.startStencil(graphics, this.field_2776 + 16, this.field_2800 + 16, 220.0f, 173.0f);
            matrixStack.method_22903();
            matrixStack.method_46416(0.0f, scrollOffset, 0.0f);
            if (i == 0 || entries.size() == 0) {
                UIRenderHelper.drawStretched(graphics, this.field_2776 + 33, this.field_2800 + 16, 3, 10, -100, AllGuiTextures.SCHEDULE_STRIP_LIGHT);
            }
            if (i == entries.size()) {
                if (i > 0) {
                    yOffset += 9;
                }
                AllGuiTextures.SCHEDULE_STRIP_END.render(graphics, this.field_2776 + 29, this.field_2800 + yOffset);
                AllGuiTextures.SCHEDULE_CARD_NEW.render(graphics, this.field_2776 + 43, this.field_2800 + yOffset);
                matrixStack.method_22909();
                this.endStencil();
                break;
            }
            ScheduleEntry scheduleEntry = entries.get(i);
            int cardY = yOffset;
            int cardHeight = this.renderScheduleEntry(graphics, scheduleEntry, cardY, mouseX, mouseY, partialTicks);
            yOffset += cardHeight;
            if (i + 1 < entries.size()) {
                AllGuiTextures.SCHEDULE_STRIP_DOTTED.render(graphics, this.field_2776 + 29, this.field_2800 + yOffset - 3);
                yOffset += 10;
            }
            matrixStack.method_22909();
            this.endStencil();
            if (!scheduleEntry.instruction.supportsConditions()) continue;
            float y1 = (float)(cardY + 24) + scrollOffset;
            float h = cardHeight - 26;
            float y2 = y1 + h;
            if (y2 > 189.0f) {
                h -= y2 - 189.0f;
            }
            if (y1 < 16.0f) {
                float correction = 16.0f - y1;
                y1 += correction;
                h -= correction;
            }
            if (h <= 0.0f) continue;
            this.startStencil(graphics, this.field_2776 + 43, (float)this.field_2800 + y1, 161.0f, h);
            matrixStack.method_22903();
            matrixStack.method_46416(0.0f, scrollOffset, 0.0f);
            this.renderScheduleConditions(graphics, scheduleEntry, cardY, mouseX, mouseY, partialTicks, cardHeight, i);
            matrixStack.method_22909();
            this.endStencil();
            if (!this.isConditionAreaScrollable(scheduleEntry)) continue;
            this.startStencil(graphics, this.field_2776 + 16, this.field_2800 + 16, 220.0f, 173.0f);
            matrixStack.method_22903();
            matrixStack.method_46416(0.0f, scrollOffset, 0.0f);
            int center = (cardHeight - 8 + 22) / 2;
            float chaseTarget = this.horizontalScrolls.get(i).getChaseTarget();
            if (!class_3532.method_15347((float)chaseTarget, (float)0.0f)) {
                AllGuiTextures.SCHEDULE_SCROLL_LEFT.render(graphics, this.field_2776 + 40, this.field_2800 + cardY + center);
            }
            if (!class_3532.method_15347((float)chaseTarget, (float)(scheduleEntry.conditions.size() - 1))) {
                AllGuiTextures.SCHEDULE_SCROLL_RIGHT.render(graphics, this.field_2776 + 203, this.field_2800 + cardY + center);
            }
            matrixStack.method_22909();
            this.endStencil();
        }
        int zLevel = 200;
        graphics.method_33284(this.field_2776 + 16, this.field_2800 + 16, this.field_2776 + 16 + 220, this.field_2800 + 16 + 10, zLevel, 0x77000000, 0);
        graphics.method_33284(this.field_2776 + 16, this.field_2800 + 179, this.field_2776 + 16 + 220, this.field_2800 + 179 + 10, zLevel, 0, 0x77000000);
        UIRenderHelper.swapAndBlitColor(UIRenderHelper.framebuffer, this.field_22787.method_1522());
    }

    public int renderScheduleEntry(class_332 graphics, ScheduleEntry entry, int yOffset, int mouseX, int mouseY, float partialTicks) {
        int zLevel = -100;
        AllGuiTextures light = AllGuiTextures.SCHEDULE_CARD_LIGHT;
        AllGuiTextures medium = AllGuiTextures.SCHEDULE_CARD_MEDIUM;
        AllGuiTextures dark = AllGuiTextures.SCHEDULE_CARD_DARK;
        int cardWidth = 195;
        int cardHeader = 22;
        int maxRows = 0;
        for (List<ScheduleWaitCondition> list : entry.conditions) {
            maxRows = Math.max(maxRows, list.size());
        }
        boolean supportsConditions = entry.instruction.supportsConditions();
        int cardHeight = cardHeader + (supportsConditions ? 24 + maxRows * 18 : 4);
        class_4587 matrixStack = graphics.method_51448();
        matrixStack.method_22903();
        matrixStack.method_46416((float)(this.field_2776 + 25), (float)(this.field_2800 + yOffset), 0.0f);
        UIRenderHelper.drawStretched(graphics, 0, 1, cardWidth, cardHeight - 2, zLevel, light);
        UIRenderHelper.drawStretched(graphics, 1, 0, cardWidth - 2, cardHeight, zLevel, light);
        UIRenderHelper.drawStretched(graphics, 1, 1, cardWidth - 2, cardHeight - 2, zLevel, dark);
        UIRenderHelper.drawStretched(graphics, 2, 2, cardWidth - 4, cardHeight - 4, zLevel, medium);
        UIRenderHelper.drawStretched(graphics, 2, 2, cardWidth - 4, cardHeader, zLevel, supportsConditions ? light : medium);
        AllGuiTextures.SCHEDULE_CARD_REMOVE.render(graphics, cardWidth - 14, 2);
        AllGuiTextures.SCHEDULE_CARD_DUPLICATE.render(graphics, cardWidth - 14, cardHeight - 14);
        int i = this.schedule.entries.indexOf(entry);
        if (i > 0) {
            AllGuiTextures.SCHEDULE_CARD_MOVE_UP.render(graphics, cardWidth, cardHeader - 14);
        }
        if (i < this.schedule.entries.size() - 1) {
            AllGuiTextures.SCHEDULE_CARD_MOVE_DOWN.render(graphics, cardWidth, cardHeader);
        }
        UIRenderHelper.drawStretched(graphics, 8, 0, 3, cardHeight + 10, zLevel, AllGuiTextures.SCHEDULE_STRIP_LIGHT);
        (supportsConditions ? AllGuiTextures.SCHEDULE_STRIP_TRAVEL : AllGuiTextures.SCHEDULE_STRIP_ACTION).render(graphics, 4, 6);
        if (supportsConditions) {
            AllGuiTextures.SCHEDULE_STRIP_WAIT.render(graphics, 4, 28);
        }
        Pair<class_1799, class_2561> destination = entry.instruction.getSummary();
        this.renderInput(graphics, destination, 26, 5, false, 100);
        entry.instruction.renderSpecialIcon(graphics, 30, 5);
        matrixStack.method_22909();
        return cardHeight;
    }

    public void renderScheduleConditions(class_332 graphics, ScheduleEntry entry, int yOffset, int mouseX, int mouseY, float partialTicks, int cardHeight, int entryIndex) {
        int cardWidth = 195;
        int cardHeader = 22;
        class_4587 matrixStack = graphics.method_51448();
        matrixStack.method_22903();
        matrixStack.method_46416((float)(this.field_2776 + 25), (float)(this.field_2800 + yOffset), 0.0f);
        int xOffset = 26;
        float scrollOffset = this.getConditionScroll(entry, partialTicks, entryIndex);
        matrixStack.method_22903();
        matrixStack.method_46416(-scrollOffset, 0.0f, 0.0f);
        for (List<ScheduleWaitCondition> list : entry.conditions) {
            int maxWidth = this.getConditionColumnWidth(list);
            for (int i = 0; i < list.size(); ++i) {
                ScheduleWaitCondition scheduleWaitCondition = list.get(i);
                Math.max(maxWidth, this.renderInput(graphics, scheduleWaitCondition.getSummary(), xOffset, 29 + i * 18, i != 0, maxWidth));
                scheduleWaitCondition.renderSpecialIcon(graphics, xOffset + 4, 29 + i * 18);
            }
            AllGuiTextures.SCHEDULE_CONDITION_APPEND.render(graphics, xOffset + (maxWidth - 10) / 2, 29 + list.size() * 18);
            xOffset += maxWidth + 10;
        }
        AllGuiTextures.SCHEDULE_CONDITION_NEW.render(graphics, xOffset - 3, 29);
        matrixStack.method_22909();
        if (xOffset + 16 > cardWidth - 26) {
            TransformStack.cast((class_4587)matrixStack).rotateZ(-90.0);
            int zLevel = 200;
            graphics.method_33284(-cardHeight + 2, 18, -2 - cardHeader, 28, zLevel, 0x44000000, 0);
            graphics.method_33284(-cardHeight + 2, cardWidth - 26, -2 - cardHeader, cardWidth - 16, zLevel, 0, 0x44000000);
        }
        matrixStack.method_22909();
    }

    private boolean isConditionAreaScrollable(ScheduleEntry entry) {
        int xOffset = 26;
        for (List<ScheduleWaitCondition> list : entry.conditions) {
            xOffset += this.getConditionColumnWidth(list) + 10;
        }
        return xOffset + 16 > 169;
    }

    private float getConditionScroll(ScheduleEntry entry, float partialTicks, int entryIndex) {
        float scrollOffset = 0.0f;
        float scrollIndex = this.horizontalScrolls.get(entryIndex).getValue(partialTicks);
        for (List<ScheduleWaitCondition> list : entry.conditions) {
            int maxWidth = this.getConditionColumnWidth(list);
            float partialOfThisColumn = Math.min(1.0f, scrollIndex);
            scrollOffset += (float)(maxWidth + 10) * partialOfThisColumn;
            scrollIndex -= partialOfThisColumn;
        }
        return scrollOffset;
    }

    private int getConditionColumnWidth(List<ScheduleWaitCondition> list) {
        int maxWidth = 0;
        for (ScheduleWaitCondition scheduleWaitCondition : list) {
            maxWidth = Math.max(maxWidth, this.getFieldSize(32, scheduleWaitCondition.getSummary()));
        }
        return maxWidth;
    }

    protected int renderInput(class_332 graphics, Pair<class_1799, class_2561> pair, int x, int y, boolean clean, int minSize) {
        class_1799 stack = pair.getFirst();
        class_2561 text = pair.getSecond();
        boolean hasItem = !stack.method_7960();
        int fieldSize = Math.min(this.getFieldSize(minSize, pair), 150);
        class_4587 matrixStack = graphics.method_51448();
        matrixStack.method_22903();
        AllGuiTextures left = clean ? AllGuiTextures.SCHEDULE_CONDITION_LEFT_CLEAN : AllGuiTextures.SCHEDULE_CONDITION_LEFT;
        AllGuiTextures middle = AllGuiTextures.SCHEDULE_CONDITION_MIDDLE;
        AllGuiTextures item = AllGuiTextures.SCHEDULE_CONDITION_ITEM;
        AllGuiTextures right = AllGuiTextures.SCHEDULE_CONDITION_RIGHT;
        matrixStack.method_46416((float)x, (float)y, 0.0f);
        UIRenderHelper.drawStretched(graphics, 0, 0, fieldSize, 16, -100, middle);
        left.render(graphics, clean ? 0 : -3, 0);
        right.render(graphics, fieldSize - 2, 0);
        if (hasItem) {
            item.render(graphics, 3, 0);
        }
        if (hasItem) {
            item.render(graphics, 3, 0);
            if (stack.method_7909() != class_1802.field_8615) {
                ((RenderElement)GuiGameElement.of(stack).at(4.0f, 0.0f)).render(graphics);
            }
        }
        if (text != null) {
            graphics.method_25303(this.field_22793, this.field_22793.method_1714((class_5348)text, 120).getString(), hasItem ? 28 : 8, 4, -855314);
        }
        matrixStack.method_22909();
        return fieldSize;
    }

    public boolean action(@Nullable class_332 graphics, double mouseX, double mouseY, int click) {
        if (this.editingCondition != null || this.editingDestination != null) {
            return false;
        }
        class_2561 empty = Components.immutableEmpty();
        int mx = (int)mouseX;
        int my = (int)mouseY;
        int x = mx - this.field_2776 - 25;
        int y = my - this.field_2800 - 25;
        if (x < 0 || x >= 205) {
            return false;
        }
        if (y < 0 || y >= 173) {
            return false;
        }
        y = (int)((float)y + this.scroll.getValue(0.0f));
        List<ScheduleEntry> entries = this.schedule.entries;
        for (int i = 0; i < entries.size(); ++i) {
            int center;
            ScheduleEntry entry = entries.get(i);
            int maxRows = 0;
            for (List<ScheduleWaitCondition> list : entry.conditions) {
                maxRows = Math.max(maxRows, list.size());
            }
            int cardHeight = 22 + (entry.instruction.supportsConditions() ? 24 + maxRows * 18 : 4);
            if (y >= cardHeight + 5) {
                if ((y -= cardHeight + 10) >= 0) continue;
                return false;
            }
            int fieldSize = this.getFieldSize(100, entry.instruction.getSummary());
            if (x > 25 && x <= 25 + fieldSize && y > 4 && y <= 20) {
                ArrayList<class_2561> components = new ArrayList<class_2561>();
                components.addAll(entry.instruction.getTitleAs("instruction"));
                components.add(empty);
                components.add(this.clickToEdit);
                this.renderActionTooltip(graphics, components, mx, my);
                if (click == 0) {
                    this.startEditing(entry.instruction, confirmed -> {
                        if (confirmed.booleanValue()) {
                            entry.instruction = this.editingDestination;
                        }
                    }, false);
                }
                return true;
            }
            if (x > 180 && x <= 192) {
                if (y > 0 && y <= 14) {
                    this.renderActionTooltip(graphics, (List<class_2561>)ImmutableList.of((Object)Lang.translateDirect("gui.schedule.remove_entry", new Object[0])), mx, my);
                    if (click == 0) {
                        entries.remove(entry);
                        this.method_25426();
                    }
                    return true;
                }
                if (y > cardHeight - 14) {
                    this.renderActionTooltip(graphics, (List<class_2561>)ImmutableList.of((Object)Lang.translateDirect("gui.schedule.duplicate", new Object[0])), mx, my);
                    if (click == 0) {
                        entries.add(entries.indexOf(entry), entry.clone());
                        this.method_25426();
                    }
                    return true;
                }
            }
            if (x > 194) {
                if (y > 7 && y <= 20 && i > 0) {
                    this.renderActionTooltip(graphics, (List<class_2561>)ImmutableList.of((Object)Lang.translateDirect("gui.schedule.move_up", new Object[0])), mx, my);
                    if (click == 0) {
                        entries.remove(entry);
                        entries.add(i - 1, entry);
                        this.method_25426();
                    }
                    return true;
                }
                if (y > 20 && y <= 33 && i < entries.size() - 1) {
                    this.renderActionTooltip(graphics, (List<class_2561>)ImmutableList.of((Object)Lang.translateDirect("gui.schedule.move_down", new Object[0])), mx, my);
                    if (click == 0) {
                        entries.remove(entry);
                        entries.add(i + 1, entry);
                        this.method_25426();
                    }
                    return true;
                }
            }
            if (y > (center = (cardHeight - 8 + 22) / 2) - 1 && y <= center + 7 && this.isConditionAreaScrollable(entry)) {
                float chaseTarget = this.horizontalScrolls.get(i).getChaseTarget();
                if (x > 12 && x <= 19 && !class_3532.method_15347((float)chaseTarget, (float)0.0f)) {
                    if (click == 0) {
                        this.horizontalScrolls.get(i).chase(chaseTarget - 1.0f, 0.5, LerpedFloat.Chaser.EXP);
                    }
                    return true;
                }
                if (x > 177 && x <= 184 && !class_3532.method_15347((float)chaseTarget, (float)(entry.conditions.size() - 1))) {
                    if (click == 0) {
                        this.horizontalScrolls.get(i).chase(chaseTarget + 1.0f, 0.5, LerpedFloat.Chaser.EXP);
                    }
                    return true;
                }
            }
            if ((x -= 18) < 0 || (y -= 28) < 0 || x > 160) {
                return false;
            }
            x = (int)((float)x + (this.getConditionScroll(entry, 0.0f, i) - 8.0f));
            List<List<ScheduleWaitCondition>> columns = entry.conditions;
            for (int j = 0; j < columns.size(); ++j) {
                List<ScheduleWaitCondition> conditions = columns.get(j);
                if (x < 0) {
                    return false;
                }
                int w = this.getConditionColumnWidth(conditions);
                if (x >= w) {
                    x -= w + 10;
                    continue;
                }
                int row = y / 18;
                if (row < conditions.size() && row >= 0) {
                    boolean canRemove = conditions.size() > 1 || columns.size() > 1;
                    ArrayList<class_2561> components = new ArrayList<class_2561>();
                    components.add((class_2561)Lang.translateDirect("schedule.condition_type", new Object[0]).method_27692(class_124.field_1080));
                    ScheduleWaitCondition condition = conditions.get(row);
                    components.addAll(condition.getTitleAs("condition"));
                    components.add(empty);
                    components.add(this.clickToEdit);
                    if (canRemove) {
                        components.add(this.rClickToDelete);
                    }
                    this.renderActionTooltip(graphics, components, mx, my);
                    if (canRemove && click == 1) {
                        conditions.remove(row);
                        if (conditions.isEmpty()) {
                            columns.remove(conditions);
                        }
                    }
                    if (click == 0) {
                        this.startEditing(condition, confirmed -> {
                            conditions.remove(row);
                            if (confirmed.booleanValue()) {
                                conditions.add(row, this.editingCondition);
                                return;
                            }
                            if (conditions.isEmpty()) {
                                columns.remove(conditions);
                            }
                        }, canRemove);
                    }
                    return true;
                }
                if (y > 18 * conditions.size() && y <= 18 * conditions.size() + 10 && x >= w / 2 - 5 && x < w / 2 + 5) {
                    this.renderActionTooltip(graphics, (List<class_2561>)ImmutableList.of((Object)Lang.translateDirect("gui.schedule.add_condition", new Object[0])), mx, my);
                    if (click == 0) {
                        this.startEditing(new ScheduledDelay(), confirmed -> {
                            if (confirmed.booleanValue()) {
                                conditions.add(this.editingCondition);
                            }
                        }, true);
                    }
                    return true;
                }
                return false;
            }
            if (x < 0 || x > 15 || y > 20) {
                return false;
            }
            this.renderActionTooltip(graphics, (List<class_2561>)ImmutableList.of((Object)Lang.translateDirect("gui.schedule.alternative_condition", new Object[0])), mx, my);
            if (click == 0) {
                this.startEditing(new ScheduledDelay(), confirmed -> {
                    if (!confirmed.booleanValue()) {
                        return;
                    }
                    ArrayList<ScheduleWaitCondition> conditions = new ArrayList<ScheduleWaitCondition>();
                    conditions.add(this.editingCondition);
                    columns.add(conditions);
                }, true);
            }
            return true;
        }
        if (x < 18 || x > 33 || y > 14) {
            return false;
        }
        this.renderActionTooltip(graphics, (List<class_2561>)ImmutableList.of((Object)Lang.translateDirect("gui.schedule.add_entry", new Object[0])), mx, my);
        if (click == 0) {
            this.startEditing(new DestinationInstruction(), confirmed -> {
                if (!confirmed.booleanValue()) {
                    return;
                }
                ScheduleEntry entry = new ScheduleEntry();
                ScheduledDelay delay = new ScheduledDelay();
                ArrayList<ScheduledDelay> initialConditions = new ArrayList<ScheduledDelay>();
                initialConditions.add(delay);
                entry.instruction = this.editingDestination;
                entry.conditions.add(initialConditions);
                this.schedule.entries.add(entry);
            }, true);
        }
        return true;
    }

    private void renderActionTooltip(@Nullable class_332 graphics, List<class_2561> tooltip, int mx, int my) {
        if (graphics != null) {
            graphics.method_51437(this.field_22793, tooltip, Optional.empty(), mx, my);
        }
    }

    private int getFieldSize(int minSize, Pair<class_1799, class_2561> pair) {
        class_1799 stack = pair.getFirst();
        class_2561 text = pair.getSecond();
        boolean hasItem = !stack.method_7960();
        return Math.max((text == null ? 0 : this.field_22793.method_27525((class_5348)text)) + (hasItem ? 20 : 0) + 16, minSize);
    }

    protected void startStencil(class_332 graphics, float x, float y, float w, float h) {
        RenderSystem.clear((int)1280, (boolean)class_310.field_1703);
        GL11.glDisable((int)2960);
        RenderSystem.stencilMask((int)-1);
        RenderSystem.clear((int)1024, (boolean)class_310.field_1703);
        GL11.glEnable((int)2960);
        RenderSystem.stencilOp((int)7681, (int)7680, (int)7680);
        RenderSystem.stencilMask((int)255);
        RenderSystem.stencilFunc((int)512, (int)1, (int)255);
        class_4587 matrixStack = graphics.method_51448();
        matrixStack.method_22903();
        matrixStack.method_46416(x, y, 0.0f);
        matrixStack.method_22905(w, h, 1.0f);
        graphics.method_33284(0, 0, 1, 1, -100, -16777216, -16777216);
        matrixStack.method_22909();
        GL11.glEnable((int)2960);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
        RenderSystem.stencilFunc((int)514, (int)1, (int)255);
    }

    protected void endStencil() {
        GL11.glDisable((int)2960);
    }

    @Override
    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.method_23922((int)pMouseX, (int)pMouseY, pButton)) {
            return true;
        }
        if (this.editorConfirm != null && this.editorConfirm.method_25405(pMouseX, pMouseY) && this.onEditorClose != null) {
            this.onEditorClose.accept(true);
            this.stopEditing();
            return true;
        }
        if (this.editorDelete != null && this.editorDelete.method_25405(pMouseX, pMouseY) && this.onEditorClose != null) {
            this.onEditorClose.accept(false);
            this.stopEditing();
            return true;
        }
        if (this.action(null, pMouseX, pMouseY, pButton)) {
            return true;
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    @Override
    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        boolean hitE;
        if (this.destinationSuggestions != null && this.destinationSuggestions.method_23924(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (this.editingCondition == null && this.editingDestination == null) {
            return super.method_25404(pKeyCode, pScanCode, pModifiers);
        }
        class_3675.class_306 mouseKey = class_3675.method_15985((int)pKeyCode, (int)pScanCode);
        boolean hitEnter = this.method_25399() instanceof class_342 && (pKeyCode == 257 || pKeyCode == 335);
        boolean bl = hitE = this.method_25399() == null && KeyBindingHelper.isActiveAndMatches((class_304)this.field_22787.field_1690.field_1822, (class_3675.class_306)mouseKey);
        if (hitE || hitEnter) {
            this.onEditorClose.accept(true);
            this.stopEditing();
            return true;
        }
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    public boolean method_25401(double pMouseX, double pMouseY, double pDelta) {
        int maxRows;
        if (this.destinationSuggestions != null && this.destinationSuggestions.method_23921(class_3532.method_15350((double)pDelta, (double)-1.0, (double)1.0))) {
            return true;
        }
        if (this.editingCondition != null || this.editingDestination != null) {
            return super.method_25401(pMouseX, pMouseY, pDelta);
        }
        if (ScheduleScreen.method_25442()) {
            List<ScheduleEntry> entries = this.schedule.entries;
            int y = (int)(pMouseY - (double)this.field_2800 - 25.0 + (double)this.scroll.getValue());
            for (int i = 0; i < entries.size(); ++i) {
                ScheduleEntry entry = entries.get(i);
                maxRows = 0;
                for (List<ScheduleWaitCondition> list : entry.conditions) {
                    maxRows = Math.max(maxRows, list.size());
                }
                int cardHeight = 46 + maxRows * 18;
                if (y >= cardHeight) {
                    if ((y -= cardHeight + 9) >= 0) continue;
                    break;
                }
                if (!this.isConditionAreaScrollable(entry) || y < 24 || pMouseX < (double)(this.field_2776 + 25) || pMouseX > (double)(this.field_2776 + 205)) break;
                float chaseTarget = this.horizontalScrolls.get(i).getChaseTarget();
                if (pDelta > 0.0 && !class_3532.method_15347((float)chaseTarget, (float)0.0f)) {
                    this.horizontalScrolls.get(i).chase(chaseTarget - 1.0f, 0.5, LerpedFloat.Chaser.EXP);
                    return true;
                }
                if (pDelta < 0.0 && !class_3532.method_15347((float)chaseTarget, (float)(entry.conditions.size() - 1))) {
                    this.horizontalScrolls.get(i).chase(chaseTarget + 1.0f, 0.5, LerpedFloat.Chaser.EXP);
                    return true;
                }
                return false;
            }
        }
        float chaseTarget = this.scroll.getChaseTarget();
        float max = -133.0f;
        for (ScheduleEntry scheduleEntry : this.schedule.entries) {
            maxRows = 0;
            for (List<ScheduleWaitCondition> list : scheduleEntry.conditions) {
                maxRows = Math.max(maxRows, list.size());
            }
            max += (float)(46 + maxRows * 18 + 10);
        }
        if (max > 0.0f) {
            chaseTarget = (float)((double)chaseTarget - pDelta * 12.0);
            chaseTarget = class_3532.method_15363((float)chaseTarget, (float)0.0f, (float)max);
            this.scroll.chase((int)chaseTarget, 0.7f, LerpedFloat.Chaser.EXP);
        } else {
            this.scroll.chase(0.0, 0.7f, LerpedFloat.Chaser.EXP);
        }
        return super.method_25401(pMouseX, pMouseY, pDelta);
    }

    @Override
    protected void renderForeground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        class_4587 matrixStack = graphics.method_51448();
        if (this.destinationSuggestions != null) {
            matrixStack.method_22903();
            matrixStack.method_46416(0.0f, 0.0f, 500.0f);
            this.destinationSuggestions.method_23923(graphics, mouseX, mouseY);
            matrixStack.method_22909();
        }
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((class_1799)((ScheduleMenu)this.field_2797).contentHolder).at(this.field_2776 + AllGuiTextures.SCHEDULE.width, this.field_2800 + AllGuiTextures.SCHEDULE.height - 56, -200.0f)).scale(3.0).render(graphics);
        this.action(graphics, mouseX, mouseY, -1);
        if (this.editingCondition == null && this.editingDestination == null) {
            return;
        }
        int x = this.field_2776 + 53;
        int y = this.field_2800 + 87;
        if (mouseX < x || mouseY < y || mouseX >= x + 120 || mouseY >= y + 18) {
            return;
        }
        ScheduleDataEntry rendered = this.editingCondition == null ? this.editingDestination : this.editingCondition;
        for (int i = 0; i < Math.max(1, rendered.slotsTargeted()); ++i) {
            List<class_2561> secondLineTooltip = rendered.getSecondLineTooltip(i);
            if (secondLineTooltip == null || this.field_2787 != ((ScheduleMenu)this.field_2797).method_7611(36 + i) || !this.field_2787.method_7677().method_7960()) continue;
            this.renderActionTooltip(graphics, secondLineTooltip, mouseX, mouseY);
        }
    }

    protected void method_2389(class_332 graphics, float pPartialTick, int pMouseX, int pMouseY) {
        AllGuiTextures.SCHEDULE.render(graphics, this.field_2776, this.field_2800);
        class_5481 formattedcharsequence = this.field_22785.method_30937();
        int center = this.field_2776 + (AllGuiTextures.SCHEDULE.width - 8) / 2;
        graphics.method_51430(this.field_22793, formattedcharsequence, center - this.field_22793.method_30880(formattedcharsequence) / 2, this.field_2800 + 4, 0x505050, false);
        this.renderSchedule(graphics, pMouseX, pMouseY, pPartialTick);
        if (this.editingCondition == null && this.editingDestination == null) {
            return;
        }
        graphics.method_25296(0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
        AllGuiTextures.SCHEDULE_EDITOR.render(graphics, this.field_2776 - 2, this.field_2800 + 40);
        AllGuiTextures.PLAYER_INVENTORY.render(graphics, this.field_2776 + 38, this.field_2800 + 122);
        graphics.method_51439(this.field_22793, this.field_29347, this.field_2776 + 46, this.field_2800 + 128, 0x505050, false);
        formattedcharsequence = this.editingCondition == null ? Lang.translateDirect("schedule.instruction.editor", new Object[0]).method_30937() : Lang.translateDirect("schedule.condition.editor", new Object[0]).method_30937();
        graphics.method_51430(this.field_22793, formattedcharsequence, center - this.field_22793.method_30880(formattedcharsequence) / 2, this.field_2800 + 44, 0x505050, false);
        ScheduleDataEntry rendered = this.editingCondition == null ? this.editingDestination : this.editingCondition;
        for (int i = 0; i < rendered.slotsTargeted(); ++i) {
            AllGuiTextures.SCHEDULE_EDITOR_ADDITIONAL_SLOT.render(graphics, this.field_2776 + 53 + 20 * i, this.field_2800 + 87);
        }
        if (rendered.slotsTargeted() == 0 && !rendered.renderSpecialIcon(graphics, this.field_2776 + 54, this.field_2800 + 88)) {
            Pair<class_1799, class_2561> summary = rendered.getSummary();
            class_1799 icon = summary.getFirst();
            if (icon.method_7960()) {
                icon = rendered.getSecondLineIcon();
            }
            if (icon.method_7960()) {
                AllGuiTextures.SCHEDULE_EDITOR_INACTIVE_SLOT.render(graphics, this.field_2776 + 53, this.field_2800 + 87);
            } else {
                ((RenderElement)GuiGameElement.of(icon).at(this.field_2776 + 54, this.field_2800 + 88)).render(graphics);
            }
        }
        class_4587 pPoseStack = graphics.method_51448();
        pPoseStack.method_22903();
        pPoseStack.method_46416(0.0f, (float)(this.field_2800 + 87), 0.0f);
        this.editorSubWidgets.renderWidgetBG(this.field_2776 + 77, graphics);
        pPoseStack.method_22909();
    }

    public void method_25432() {
        super.method_25432();
        AllPackets.getChannel().sendToServer((C2SPacket)new ScheduleEditPacket(this.schedule));
    }

    @Override
    public List<class_768> getExtraAreas() {
        return this.extraAreas;
    }

    public class_327 getFont() {
        return this.field_22793;
    }
}

