/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.behaviour;

import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.function.UnaryOperator;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3499;

public class MovementContext {
    public class_243 position;
    public class_243 motion;
    public class_243 relativeMotion;
    public UnaryOperator<class_243> rotation;
    public class_1937 world;
    public class_2680 state;
    public class_2338 localPos;
    public class_2487 blockEntityData;
    public boolean stall;
    public boolean disabled;
    public boolean firstMovement;
    public class_2487 data;
    public Contraption contraption;
    public Object temporaryData;
    private FilterItemStack filter;

    public MovementContext(class_1937 world, class_3499.class_3501 info, Contraption contraption) {
        this.world = world;
        this.state = info.comp_1342();
        this.blockEntityData = info.comp_1343();
        this.contraption = contraption;
        this.localPos = info.comp_1341();
        this.disabled = false;
        this.firstMovement = true;
        this.motion = class_243.field_1353;
        this.relativeMotion = class_243.field_1353;
        this.rotation = v -> v;
        this.position = null;
        this.data = new class_2487();
        this.stall = false;
        this.filter = null;
    }

    public float getAnimationSpeed() {
        int modifier = 1000;
        double length = -this.motion.method_1033();
        if (this.disabled) {
            return 0.0f;
        }
        if (this.world.field_9236 && this.contraption.stalled) {
            return 700.0f;
        }
        if (Math.abs(length) < 0.001953125) {
            return 0.0f;
        }
        return (int)(length * (double)modifier + 100.0 * Math.signum(length)) / 100 * 100;
    }

    public static MovementContext readNBT(class_1937 world, class_3499.class_3501 info, class_2487 nbt, Contraption contraption) {
        MovementContext context = new MovementContext(world, info, contraption);
        context.motion = VecHelper.readNBT(nbt.method_10554("Motion", 6));
        context.relativeMotion = VecHelper.readNBT(nbt.method_10554("RelativeMotion", 6));
        if (nbt.method_10545("Position")) {
            context.position = VecHelper.readNBT(nbt.method_10554("Position", 6));
        }
        context.stall = nbt.method_10577("Stall");
        context.firstMovement = nbt.method_10577("FirstMovement");
        context.data = nbt.method_10562("Data");
        return context;
    }

    public class_2487 writeToNBT(class_2487 nbt) {
        nbt.method_10566("Motion", (class_2520)VecHelper.writeNBT(this.motion));
        nbt.method_10566("RelativeMotion", (class_2520)VecHelper.writeNBT(this.relativeMotion));
        if (this.position != null) {
            nbt.method_10566("Position", (class_2520)VecHelper.writeNBT(this.position));
        }
        nbt.method_10556("Stall", this.stall);
        nbt.method_10556("FirstMovement", this.firstMovement);
        nbt.method_10566("Data", (class_2520)this.data.method_10553());
        return nbt;
    }

    public FilterItemStack getFilterFromBE() {
        if (this.filter != null) {
            return this.filter;
        }
        this.filter = FilterItemStack.of(this.blockEntityData.method_10562("Filter"));
        return this.filter;
    }
}

