/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.google.common.collect.ImmutableMap;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.BogeyRenderer;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.content.trains.bogey.StandardBogeyRenderer;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.tterrag.registrate.util.entry.BlockEntry;
import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class AllBogeyStyles {
    public static final Map<class_2960, BogeyStyle> BOGEY_STYLES = new HashMap<class_2960, BogeyStyle>();
    public static final Map<class_2960, Map<class_2960, BogeyStyle>> CYCLE_GROUPS = new HashMap<class_2960, Map<class_2960, BogeyStyle>>();
    private static final Map<class_2960, BogeyStyle> EMPTY_GROUP = ImmutableMap.of();
    public static final String STANDARD_CYCLE_GROUP = "standard";
    public static final BogeyStyle STANDARD = AllBogeyStyles.create("standard", "standard").commonRenderer(() -> StandardBogeyRenderer.CommonStandardBogeyRenderer::new).displayName((class_2561)Components.translatable("create.bogey.style.standard")).size(BogeySizes.SMALL, () -> StandardBogeyRenderer.SmallStandardBogeyRenderer::new, AllBlocks.SMALL_BOGEY).size(BogeySizes.LARGE, () -> StandardBogeyRenderer.LargeStandardBogeyRenderer::new, AllBlocks.LARGE_BOGEY).build();

    public static Map<class_2960, BogeyStyle> getCycleGroup(class_2960 cycleGroup) {
        return CYCLE_GROUPS.getOrDefault(cycleGroup, EMPTY_GROUP);
    }

    private static BogeyStyleBuilder create(String name, String cycleGroup) {
        return AllBogeyStyles.create(Create.asResource(name), Create.asResource(cycleGroup));
    }

    public static BogeyStyleBuilder create(class_2960 name, class_2960 cycleGroup) {
        return new BogeyStyleBuilder(name, cycleGroup);
    }

    public static void register() {
    }

    public static class BogeyStyleBuilder {
        protected final Map<BogeySizes.BogeySize, Supplier<BogeyStyle.SizeRenderData>> sizeRenderers = new HashMap<BogeySizes.BogeySize, Supplier<BogeyStyle.SizeRenderData>>();
        protected final Map<BogeySizes.BogeySize, class_2960> sizes = new HashMap<BogeySizes.BogeySize, class_2960>();
        protected final class_2960 name;
        protected final class_2960 cycleGroup;
        protected class_2561 displayName = Lang.translateDirect("bogey.style.invalid", new Object[0]);
        protected class_2960 soundType = AllSoundEvents.TRAIN2.getId();
        protected class_2487 defaultData = new class_2487();
        protected class_2394 contactParticle = class_2398.field_11205;
        protected class_2394 smokeParticle = class_2398.field_11203;
        protected Optional<Supplier<? extends BogeyRenderer.CommonRenderer>> commonRenderer = Optional.empty();

        public BogeyStyleBuilder(class_2960 name, class_2960 cycleGroup) {
            this.name = name;
            this.cycleGroup = cycleGroup;
        }

        public BogeyStyleBuilder displayName(class_2561 displayName) {
            this.displayName = displayName;
            return this;
        }

        public BogeyStyleBuilder soundType(class_2960 soundType) {
            this.soundType = soundType;
            return this;
        }

        public BogeyStyleBuilder defaultData(class_2487 defaultData) {
            this.defaultData = defaultData;
            return this;
        }

        public BogeyStyleBuilder size(BogeySizes.BogeySize size, Supplier<Supplier<? extends BogeyRenderer>> renderer, BlockEntry<? extends AbstractBogeyBlock<?>> blockEntry) {
            this.size(size, renderer, blockEntry.getId());
            return this;
        }

        public BogeyStyleBuilder size(BogeySizes.BogeySize size, Supplier<Supplier<? extends BogeyRenderer>> renderer, class_2960 location) {
            this.sizes.put(size, location);
            EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> this.lambda$size$1(size, (Supplier)renderer));
            return this;
        }

        public BogeyStyleBuilder contactParticle(class_2394 contactParticle) {
            this.contactParticle = contactParticle;
            return this;
        }

        public BogeyStyleBuilder smokeParticle(class_2394 smokeParticle) {
            this.smokeParticle = smokeParticle;
            return this;
        }

        public BogeyStyleBuilder commonRenderer(Supplier<Supplier<? extends BogeyRenderer.CommonRenderer>> commonRenderer) {
            EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> this.lambda$commonRenderer$3((Supplier)commonRenderer));
            return this;
        }

        public BogeyStyle build() {
            BogeyStyle entry = new BogeyStyle(this.name, this.cycleGroup, this.displayName, this.soundType, this.contactParticle, this.smokeParticle, this.defaultData, this.sizes, this.sizeRenderers, this.commonRenderer);
            BOGEY_STYLES.put(this.name, entry);
            CYCLE_GROUPS.computeIfAbsent(this.cycleGroup, l -> new HashMap()).put(this.name, entry);
            return entry;
        }

        private /* synthetic */ void lambda$commonRenderer$3(Supplier commonRenderer) {
            this.commonRenderer = Optional.of((Supplier)commonRenderer.get());
        }

        private /* synthetic */ void lambda$size$1(BogeySizes.BogeySize size, Supplier renderer) {
            this.sizeRenderers.put(size, () -> BogeyStyleBuilder.lambda$size$0((Supplier)renderer));
        }

        private static /* synthetic */ BogeyStyle.SizeRenderData lambda$size$0(Supplier renderer) {
            return new BogeyStyle.SizeRenderData((Supplier)renderer.get(), (BogeyRenderer)((Supplier)renderer.get()).get());
        }
    }
}

