/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import org.betterx.bclib.BCLib;
import org.jetbrains.annotations.Nullable;

public class ItemUtil {
    @Nullable
    public static class_1799 fromStackString(String stackString) {
        if (stackString == null || stackString.equals("")) {
            return null;
        }
        try {
            String[] parts = stackString.split(":");
            if (parts.length < 2) {
                return null;
            }
            if (parts.length == 2) {
                class_2960 itemId = new class_2960(stackString);
                class_1792 item = (class_1792)class_7923.field_41178.method_17966(itemId).orElseThrow(() -> new IllegalStateException("Output item " + itemId + " does not exists!"));
                return new class_1799((class_1935)item);
            }
            class_2960 itemId = new class_2960(parts[0], parts[1]);
            class_1792 item = (class_1792)class_7923.field_41178.method_17966(itemId).orElseThrow(() -> new IllegalStateException("Output item " + itemId + " does not exists!"));
            return new class_1799((class_1935)item, Integer.valueOf(parts[2]).intValue());
        }
        catch (Exception ex) {
            BCLib.LOGGER.error("ItemStack deserialization error!", ex);
            return null;
        }
    }

    public static class_2487 readNBT(JsonObject recipe) {
        if (recipe.has("nbt")) {
            try {
                String nbtData = class_3518.method_15265((JsonObject)recipe, (String)"nbt");
                class_2487 nbt = class_2522.method_10718((String)nbtData);
                return nbt;
            }
            catch (CommandSyntaxException ex) {
                BCLib.LOGGER.warning("Error parsing nbt data for output.", new Object[]{ex});
            }
        }
        return null;
    }

    public static void writeNBT(JsonObject root, class_2487 nbt) {
        if (nbt != null) {
            String nbtData = nbt.toString();
            root.addProperty("nbt", nbtData);
        }
    }

    public static class_1856 fromJsonIngredientWithNBT(JsonObject ingredient) {
        class_1856 ing = class_1856.method_52177((JsonElement)ingredient);
        class_2487 nbt = ItemUtil.readNBT(ingredient);
        if (nbt != null && !ing.method_8103()) {
            ing.method_8105()[0].method_7980(nbt);
        }
        return ing;
    }

    public static class_1799 fromJsonRecipeWithNBT(JsonObject recipe) {
        class_1799 output = ItemUtil.fromJsonRecipe(recipe);
        class_2487 nbt = ItemUtil.readNBT(recipe);
        if (output != null && nbt != null) {
            output.method_7980(nbt);
        }
        return output;
    }

    @Nullable
    public static class_1799 fromJsonRecipe(JsonObject recipe) {
        try {
            if (!recipe.has("item")) {
                throw new IllegalStateException("Invalid JsonObject. Entry 'item' does not exists!");
            }
            class_2960 itemId = new class_2960(class_3518.method_15265((JsonObject)recipe, (String)"item"));
            class_1792 item = (class_1792)class_7923.field_41178.method_17966(itemId).orElseThrow(() -> new IllegalStateException("Output item " + itemId + " does not exists!"));
            int count = class_3518.method_15282((JsonObject)recipe, (String)"count", (int)1);
            return new class_1799((class_1935)item, count);
        }
        catch (Exception ex) {
            BCLib.LOGGER.error("ItemStack deserialization error!", ex);
            return null;
        }
    }

    public static JsonElement toJsonIngredientWithNBT(class_1856 ing) {
        JsonElement el = ing.method_8089();
        if (el.isJsonObject() && !ing.method_8103() && ing.method_8105()[0].method_7985()) {
            JsonObject obj = el.getAsJsonObject();
            ItemUtil.writeNBT(obj, ing.method_8105()[0].method_7969());
        }
        return el;
    }

    public static JsonObject toJsonRecipeWithNBT(class_1799 stack) {
        return ItemUtil.toJsonRecipeWithNBT((class_1935)stack.method_7909(), stack.method_7947(), stack.method_7969());
    }

    public static JsonObject toJsonRecipeWithNBT(class_1935 item, int count, class_2487 nbt) {
        JsonObject root = ItemUtil.toJsonRecipe(item, count);
        ItemUtil.writeNBT(root, nbt);
        return root;
    }

    public static JsonObject toJsonRecipe(class_1799 stack) {
        return ItemUtil.toJsonRecipe((class_1935)stack.method_7909(), stack.method_7947());
    }

    public static JsonObject toJsonRecipe(class_1935 item, int count) {
        class_2960 id = class_7923.field_41178.method_10221((Object)item.method_8389());
        if (id == null) {
            throw new IllegalStateException("Unknown Item " + item);
        }
        JsonObject root = new JsonObject();
        root.addProperty("item", class_7923.field_41178.method_10221((Object)item.method_8389()).toString());
        if (count > 1) {
            root.addProperty("count", (Number)count);
        }
        return root;
    }
}

