/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.light.LightListener;
import com.jozufozu.flywheel.light.LightUpdater;
import com.jozufozu.flywheel.util.box.GridAlignedBB;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.railwayteam.railways.content.custom_tracks.casing.CasingRenderUtils;
import com.railwayteam.railways.mixin_interfaces.IGetBezierConnection;
import com.railwayteam.railways.mixin_interfaces.IHasTrackCasing;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.util.MathUtils;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackInstance;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={TrackInstance.class}, remap=false)
public abstract class MixinTrackInstance
extends BlockEntityInstance<TrackBlockEntity>
implements IGetBezierConnection {
    @Nullable
    private BezierConnection bezierConnection = null;
    private final List<Pair<ModelData, class_2338>> casingData = new ArrayList<Pair<ModelData, class_2338>>();

    private MixinTrackInstance(MaterialManager materialManager, TrackBlockEntity blockEntity) {
        super(materialManager, (class_2586)blockEntity);
    }

    @Shadow
    public abstract void remove();

    @Override
    @Nullable
    public BezierConnection getBezierConnection() {
        return this.bezierConnection;
    }

    @Inject(method={"createInstance"}, at={@At(value="HEAD")})
    private void preCreateInstance(BezierConnection bc, CallbackInfoReturnable<?> cir) {
        this.bezierConnection = bc;
    }

    @Inject(method={"update"}, at={@At(value="RETURN", ordinal=0)})
    private void updateWithoutConnections(CallbackInfo ci) {
        this.remove();
        this.railways$makeCasingData(false);
        LightUpdater.get((class_1936)this.world).addListener((LightListener)this);
    }

    @Inject(method={"update"}, at={@At(value="RETURN", ordinal=1)})
    private void updateWithConnections(CallbackInfo ci) {
        this.railways$makeCasingData(true);
    }

    @Inject(method={"updateLight"}, at={@At(value="HEAD")})
    private void railways$updateLight(CallbackInfo ci) {
        this.casingData.forEach(data -> ((ModelData)data.getFirst()).updateLight((class_1920)this.world, (class_2338)data.getSecond()));
    }

    @Inject(method={"remove"}, at={@At(value="HEAD")})
    private void railways$remove(CallbackInfo ci) {
        this.casingData.forEach(data -> ((ModelData)data.getFirst()).delete());
        this.casingData.clear();
    }

    @Inject(method={"getVolume"}, at={@At(value="INVOKE", target="Ljava/util/List;addAll(Ljava/util/Collection;)Z")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void railways$getVolume(CallbackInfoReturnable<GridAlignedBB> cir, List<class_2338> out) {
        out.add(this.pos);
    }

    @Unique
    private void railways$makeCasingData(boolean connections) {
        TrackShape shape;
        Material mat = this.materialManager.cutout(class_1921.method_23579()).material(Materials.TRANSFORMED);
        class_4587 ms = new class_4587();
        ((TransformStack)TransformStack.cast((class_4587)ms).translate((class_2382)this.getInstancePosition())).nudge((int)this.pos.method_10063());
        class_2482 casingBlock = ((IHasTrackCasing)this.blockEntity).getTrackCasing();
        if (casingBlock != null && CRBlockPartials.TRACK_CASINGS.containsKey(shape = (TrackShape)this.blockState.method_11654((class_2769)TrackBlock.SHAPE))) {
            ms.method_22903();
            if (((TrackBlockEntity)this.blockEntity).isTilted()) {
                double angle = (Double)((TrackBlockEntity)this.blockEntity).tilt.smoothingAngle.get();
                switch ((TrackShape)((TrackBlockEntity)this.blockEntity).method_11010().method_11654((class_2769)TrackBlock.SHAPE)) {
                    case ZO: {
                        TransformStack.cast((class_4587)ms).rotateX(-angle);
                        break;
                    }
                    case XO: {
                        TransformStack.cast((class_4587)ms).rotateZ(angle);
                    }
                }
            }
            TrackMaterial.TrackType trackType = null;
            class_2248 class_22482 = this.blockState.method_26204();
            if (class_22482 instanceof TrackBlock) {
                TrackBlock trackBlock = (TrackBlock)class_22482;
                trackType = trackBlock.getMaterial().trackType;
            }
            CRBlockPartials.TrackCasingSpec spec = CRBlockPartials.TRACK_CASINGS.get(shape);
            spec = ((IHasTrackCasing)this.blockEntity).isAlternate() ? spec.getNonNullAltSpec(trackType) : spec.getFor(trackType);
            PartialModel rawCasingModel = spec.model;
            CRBlockPartials.ModelTransform transform = spec.transform;
            ModelData casingInstance = CasingRenderUtils.makeCasingInstance(rawCasingModel, casingBlock, (Material<ModelData>)mat);
            ((ModelData)((ModelData)((ModelData)casingInstance.setTransform(ms).rotateX((double)transform.rx())).rotateY((double)transform.ry())).rotateZ((double)transform.rz())).translate(transform.x(), transform.y(), transform.z());
            casingInstance.updateLight((class_1920)this.world, this.pos);
            this.casingData.add((Pair<ModelData, class_2338>)Pair.of((Object)casingInstance, (Object)this.pos));
            for (CRBlockPartials.ModelTransform additionalTransform : spec.additionalTransforms) {
                ModelData additionalInstance = CasingRenderUtils.makeCasingInstance(rawCasingModel, casingBlock, (Material<ModelData>)mat);
                ((ModelData)((ModelData)((ModelData)additionalInstance.setTransform(ms).rotateX((double)additionalTransform.rx())).rotateY((double)additionalTransform.ry())).rotateZ((double)additionalTransform.rz())).translate(additionalTransform.x(), additionalTransform.y(), additionalTransform.z());
                additionalInstance.updateLight((class_1920)this.world, this.pos);
                this.casingData.add((Pair<ModelData, class_2338>)Pair.of((Object)additionalInstance, (Object)this.pos.method_10069(class_3532.method_15357((double)additionalTransform.x()), class_3532.method_15357((double)additionalTransform.y()), class_3532.method_15357((double)additionalTransform.z()))));
            }
            ms.method_22909();
        }
        if (connections) {
            for (BezierConnection bc : ((TrackBlockEntity)this.blockEntity).getConnections().values()) {
                double shiftDown;
                if (!bc.isPrimary() || (casingBlock = ((IHasTrackCasing)bc).getTrackCasing()) == null) continue;
                int heightDiff = Math.abs(((class_2338)bc.tePositions.get(false)).method_10264() - ((class_2338)bc.tePositions.get(true)).method_10264());
                double d = shiftDown = ((IHasTrackCasing)bc).isAlternate() && heightDiff > 0 ? -0.25 : 0.0;
                if ((double)heightDiff / bc.getLength() <= 0.13333333333333333) {
                    for (class_243 pos : CasingRenderUtils.casingPositions(bc)) {
                        ModelData casingInstance = CasingRenderUtils.makeCasingInstance(heightDiff == 0 ? CRBlockPartials.TRACK_CASING_FLAT : CRBlockPartials.TRACK_CASING_FLAT_THICK, casingBlock, (Material<ModelData>)mat);
                        casingInstance.setTransform(ms).translate(0.0, shiftDown, 0.0).translate(pos.field_1352, pos.field_1351, pos.field_1350).scale(1.001f);
                        class_2338 relativePos = class_2338.method_49637((double)((double)this.pos.method_10263() + pos.field_1352), (double)((double)this.pos.method_10264() + pos.field_1351), (double)((double)this.pos.method_10260() + pos.field_1350));
                        casingInstance.updateLight((class_1920)this.world, relativePos);
                        this.casingData.add((Pair<ModelData, class_2338>)Pair.of((Object)casingInstance, (Object)relativePos));
                    }
                    continue;
                }
                BezierConnection.SegmentAngles[] segments = bc.getBakedSegments();
                for (int i = 1; i < segments.length; ++i) {
                    if (i % 2 == 0) continue;
                    BezierConnection.SegmentAngles segment = segments[i];
                    Matrix4f pose_matrix = MathUtils.copy(segment.tieTransform.method_23761());
                    pose_matrix.translate((Vector3fc)new Vector3f(0.0f, (float)(i % 4) * 0.001f, 0.0f));
                    ModelData casingInstance = CasingRenderUtils.makeCasingInstance(heightDiff == 0 ? CRBlockPartials.TRACK_CASING_FLAT : CRBlockPartials.TRACK_CASING_FLAT_THICK, casingBlock, (Material<ModelData>)mat);
                    casingInstance.setTransform(ms).mulPose(pose_matrix).mulNormal(segment.tieTransform.method_23762()).translate(0.0, shiftDown, 0.0).scale(1.001f);
                    class_2338 relativePos = segment.lightPosition.method_10081((class_2382)this.pos);
                    casingInstance.updateLight((class_1920)this.world, relativePos);
                    this.casingData.add((Pair<ModelData, class_2338>)Pair.of((Object)casingInstance, (Object)relativePos));
                    TrackMaterial.TrackType trackType = bc.getMaterial().trackType;
                    if (trackType == CRTrackMaterials.CRTrackType.WIDE_GAUGE) {
                        for (boolean first : Iterate.trueAndFalse) {
                            for (boolean inner : Iterate.trueAndFalse) {
                                class_4587.class_4665 transform = (class_4587.class_4665)segment.railTransforms.get(first);
                                Matrix4f pose_matrix2 = MathUtils.copy(transform.method_23761());
                                pose_matrix2.translate((Vector3fc)new Vector3f(0.0f, (float)(i % 4) * 0.001f, 0.0f));
                                ModelData casingInstance2 = CasingRenderUtils.makeCasingInstance(heightDiff == 0 ? CRBlockPartials.TRACK_CASING_FLAT : CRBlockPartials.TRACK_CASING_FLAT_THICK, casingBlock, (Material<ModelData>)mat);
                                casingInstance2.setTransform(ms).mulPose(pose_matrix2).mulNormal(transform.method_23762()).translate((first ? -0.953125 : -0.03125) + (double)(inner ? 0 : (first ? 1 : -1)), shiftDown, 0.0);
                                class_2338 relativePos2 = segment.lightPosition.method_10081((class_2382)this.pos);
                                casingInstance2.updateLight((class_1920)this.world, relativePos2);
                                this.casingData.add((Pair<ModelData, class_2338>)Pair.of((Object)casingInstance2, (Object)relativePos2));
                            }
                        }
                        continue;
                    }
                    for (boolean first : Iterate.trueAndFalse) {
                        class_4587.class_4665 transform = (class_4587.class_4665)segment.railTransforms.get(first);
                        Matrix4f pose_matrix2 = MathUtils.copy(transform.method_23761());
                        pose_matrix2.translate((Vector3fc)new Vector3f(0.0f, (float)(i % 4) * 0.001f, 0.0f));
                        ModelData casingInstance2 = CasingRenderUtils.makeCasingInstance(heightDiff == 0 ? CRBlockPartials.TRACK_CASING_FLAT : CRBlockPartials.TRACK_CASING_FLAT_THICK, casingBlock, (Material<ModelData>)mat);
                        casingInstance2.setTransform(ms).mulPose(pose_matrix2).mulNormal(transform.method_23762()).translate(-0.5 + (trackType == CRTrackMaterials.CRTrackType.NARROW_GAUGE ? (first ? 0.5 : -0.5) : 0.0), shiftDown, 0.0);
                        class_2338 relativePos2 = segment.lightPosition.method_10081((class_2382)this.pos);
                        casingInstance2.updateLight((class_1920)this.world, relativePos2);
                        this.casingData.add((Pair<ModelData, class_2338>)Pair.of((Object)casingInstance2, (Object)relativePos2));
                    }
                }
            }
        }
    }
}

