/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.values;

import de.ambertation.wunderlib.ui.layout.values.SizeType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class Value {
    private SizeType sizeType;
    private int calculatedSize;

    public Value(SizeType sizeType) {
        this.sizeType = sizeType;
        this.calculatedSize = 0;
    }

    public static Value fixed(int size) {
        return new Value(new SizeType.Fixed(size));
    }

    public static Value relative(double percentage) {
        return new Value(new SizeType.Relative(percentage));
    }

    public static Value fill() {
        return new Value(SizeType.FILL);
    }

    public static Value fit() {
        return new Value(SizeType.FIT_CONTENT);
    }

    public static Value fitOrFill() {
        return new Value(SizeType.FIT_CONTENT_OR_FILL);
    }

    public int calculatedSize() {
        return this.calculatedSize;
    }

    public int setCalculatedSize(int value) {
        this.calculatedSize = value;
        return value;
    }

    public Value attachComponent(SizeType.FitContent.ContentSizeSupplier c) {
        SizeType.FitContent fit;
        SizeType sizeType = this.sizeType;
        if (sizeType instanceof SizeType.FitContent && (fit = (SizeType.FitContent)sizeType).contentSize() == null) {
            this.sizeType = fit.copyForSupplier(c);
        }
        return this;
    }

    public int calculateFixed() {
        return this.calculate(0);
    }

    public double calculateRelative() {
        SizeType sizeType = this.sizeType;
        if (sizeType instanceof SizeType.Relative) {
            SizeType.Relative rel = (SizeType.Relative)sizeType;
            return rel.percentage();
        }
        return 0.0;
    }

    public int calculate(int parentSize) {
        this.calculatedSize = 0;
        SizeType sizeType = this.sizeType;
        if (sizeType instanceof SizeType.Fixed) {
            SizeType.Fixed fixed = (SizeType.Fixed)sizeType;
            this.calculatedSize = fixed.size();
        } else {
            sizeType = this.sizeType;
            if (sizeType instanceof SizeType.FitContent) {
                SizeType.FitContent fit = (SizeType.FitContent)sizeType;
                this.calculatedSize = fit.contentSize().get();
            } else {
                sizeType = this.sizeType;
                if (sizeType instanceof SizeType.Relative) {
                    SizeType.Relative rel = (SizeType.Relative)sizeType;
                    this.calculatedSize = (int)((double)parentSize * rel.percentage());
                }
            }
        }
        return this.calculatedSize;
    }

    public int calculateOrFill(int parentSize) {
        this.calculatedSize = this.calculate(parentSize);
        if (this.sizeType instanceof SizeType.Fill || this.sizeType instanceof SizeType.FitContentOrFill) {
            this.calculatedSize = Math.max(parentSize, this.calculatedSize);
        }
        return this.calculatedSize;
    }

    public double fillWeight() {
        block4: {
            block3: {
                block2: {
                    SizeType sizeType = this.sizeType;
                    if (!(sizeType instanceof SizeType.Fill)) break block2;
                    SizeType.Fill fill = (SizeType.Fill)sizeType;
                    break block3;
                }
                if (!(this.sizeType instanceof SizeType.FitContentOrFill)) break block4;
            }
            return 1.0;
        }
        return 0.0;
    }

    public int fill(int fillSize) {
        return this.fill(fillSize, this.fillWeight());
    }

    public int fill(int fillSize, double totalFillWeight) {
        if (this.sizeType instanceof SizeType.Fill) {
            this.calculatedSize = (int)Math.round((double)fillSize * (this.fillWeight() / totalFillWeight));
        }
        return this.calculatedSize;
    }

    public String toString() {
        return "DynamicSize{sizeType=" + this.sizeType.getClass().getSimpleName() + ", calculatedSize=" + this.calculatedSize + "}";
    }
}

