/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.math.sdf.interfaces;

import de.ambertation.wunderlib.math.Bounds;
import de.ambertation.wunderlib.math.Float3;
import de.ambertation.wunderlib.math.Matrix4;
import de.ambertation.wunderlib.math.Transform;
import de.ambertation.wunderlib.math.sdf.interfaces.RootedSDF;

public interface Transformable
extends RootedSDF {
    public Float3[] getCornersInWorldSpace(boolean var1, Transform var2);

    public Float3[] getCornersAndCenterInWorldSpace(boolean var1, Transform var2);

    public Float3 getCornerInWorldSpace(Bounds.Interpolate var1, boolean var2, Transform var3);

    public Transform getLocalTransform();

    public void setLocalTransform(Transform var1);

    public Matrix4 getParentTransformMatrix();

    default public Float3[] getCornersInWorldSpace(boolean blockAligned) {
        return this.getCornersInWorldSpace(blockAligned, this.getLocalTransform());
    }

    default public Float3[] getCornersAndCenterInWorldSpace(boolean blockAligned) {
        return this.getCornersAndCenterInWorldSpace(blockAligned, this.getLocalTransform());
    }

    default public Float3 getCornerInWorldSpace(Bounds.Interpolate corner, boolean blockAligned) {
        return this.getCornerInWorldSpace(corner, blockAligned, this.getLocalTransform());
    }

    default public Matrix4 getWorldTransformMatrix() {
        return this.getParentTransformMatrix().mul(this.getLocalTransform().asMatrix());
    }

    public boolean isOperation();
}

