/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.math;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ambertation.wunderlib.math.Float2;
import de.ambertation.wunderlib.math.Float4;
import de.ambertation.wunderlib.math.Quaternion;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import org.joml.Vector3f;

public class Float3 {
    public static final double EPSILON = 1.0E-10;
    public static final Float3 ZERO = Float3.of(0.0);
    public static final Float3 IDENTITY = Float3.of(1.0);
    public static final Float3 X_AXIS = Float3.of(1.0, 0.0, 0.0);
    public static final Float3 Y_AXIS = Float3.of(0.0, 1.0, 0.0);
    public static final Float3 Z_AXIS = Float3.of(0.0, 0.0, 1.0);
    public static final Float3 mX_AXIS = Float3.of(-1.0, 0.0, 0.0);
    public static final Float3 mY_AXIS = Float3.of(0.0, -1.0, 0.0);
    public static final Float3 mZ_AXIS = Float3.of(0.0, 0.0, -1.0);
    public static final Float3 SOUTH = Z_AXIS;
    public static final Float3 NORTH = mZ_AXIS;
    public static final Float3 EAST = X_AXIS;
    public static final Float3 WEST = mX_AXIS;
    public static final Float3 UP = Y_AXIS;
    public static final Float3 DOWN = mY_AXIS;
    public static final Float3 XZ_PLANE = Float3.of(1.0, 0.0, 1.0);
    public static final Float3 mXZ_PLANE = Float3.of(-1.0, 0.0, 1.0);
    public static final Float3 XmZ_PLANE = Float3.of(1.0, 0.0, -1.0);
    public static final Float3 mXmZ_PLANE = Float3.of(-1.0, 0.0, -1.0);
    public static final Float3 XY_PLANE = Float3.of(1.0, 1.0, 0.0);
    public static final Float3 mXY_PLANE = Float3.of(-1.0, 1.0, 0.0);
    public static final Float3 XmY_PLANE = Float3.of(1.0, -1.0, 0.0);
    public static final Float3 mXmY_PLANE = Float3.of(-1.0, -1.0, 0.0);
    public static final Float3 YZ_PLANE = Float3.of(0.0, 1.0, 1.0);
    public static final Float3 mYZ_PLANE = Float3.of(0.0, -1.0, 1.0);
    public static final Float3 YmZ_PLANE = Float3.of(0.0, 1.0, -1.0);
    public static final Float3 mYmZ_PLANE = Float3.of(0.0, -1.0, -1.0);
    public static final Codec<Float3> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("x").forGetter(o -> Float.valueOf((float)o.x)), (App)Codec.FLOAT.fieldOf("y").forGetter(o -> Float.valueOf((float)o.y)), (App)Codec.FLOAT.fieldOf("z").forGetter(o -> Float.valueOf((float)o.z))).apply((Applicative)instance, Float3::new));
    public final double x;
    public final double y;
    public final double z;

    public Float3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static Float3 of(double xyz) {
        return new Float3(xyz, xyz, xyz);
    }

    public static Float3 of(double x, double y, double z) {
        return new Float3(x, y, z);
    }

    public static Float3 of(Float2 xy, double z) {
        return new Float3(xy.x, xy.y, z);
    }

    public static Float3 of(double x, Float2 xy) {
        return new Float3(x, xy.x, xy.y);
    }

    public static Float3 of(class_2338 pos) {
        return new Float3((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
    }

    public static Float3 of(class_243 pos) {
        return new Float3(pos.method_10216(), pos.method_10214(), pos.method_10215());
    }

    public static Float3 of(Vector3f pos) {
        return new Float3(pos.x(), pos.y(), pos.z());
    }

    public static Float3 blockAligned(double x, double y, double z) {
        return new Float3(Float3.toAlignedPos(x), Float3.toAlignedPos(y), Float3.toAlignedPos(z));
    }

    public Float3 blockAligned() {
        return new Float3(Float3.toAlignedPos(this.x), Float3.toAlignedPos(this.y), Float3.toAlignedPos(this.z));
    }

    public Float3 align(boolean toBlock) {
        return toBlock ? new Float3(Float3.toAlignedPos(this.x), Float3.toAlignedPos(this.y), Float3.toAlignedPos(this.z)) : this;
    }

    public Float3 div(Float3 p) {
        return new Float3(this.x / p.x, this.y / p.y, this.z / p.z);
    }

    public Float3 mul(Float3 p) {
        return new Float3(this.x * p.x, this.y * p.y, this.z * p.z);
    }

    public double dot(Float3 p) {
        return this.x * p.x + this.y * p.y + this.z * p.z;
    }

    public double angleTo(Float3 target) {
        return Math.acos(Math.max(-1.0, Math.min(1.0, this.dot(target) / Math.sqrt(this.lengthSquare() * target.lengthSquare()))));
    }

    public Float3 cross(Float3 p) {
        return Float3.of(this.y * p.z - this.z * p.y, this.z * p.x - this.x * p.z, this.x * p.y - this.y * p.x);
    }

    public Float3 square() {
        return new Float3(this.x * this.x, this.y * this.y, this.z * this.z);
    }

    public Float3 add(Float3 p) {
        return new Float3(this.x + p.x, this.y + p.y, this.z + p.z);
    }

    public Float3 add(class_243 p) {
        return new Float3(this.x + p.field_1352, this.y + p.field_1351, this.z + p.field_1350);
    }

    public Float3 add(double d) {
        return new Float3(this.x + d, this.y + d, this.z + d);
    }

    public Float3 add(double dx, double dy, double dz) {
        return new Float3(this.x + dx, this.y + dy, this.z + dz);
    }

    public Float3 sub(double d) {
        return new Float3(this.x - d, this.y - d, this.z - d);
    }

    public Float3 sub(double dx, double dy, double dz) {
        return new Float3(this.x - dx, this.y - dy, this.z - dz);
    }

    public Float3 abs() {
        return new Float3(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    public Float3 max(double d) {
        return new Float3(Math.max(this.x, d), Math.max(this.y, d), Math.max(this.z, d));
    }

    public double maxAbsComponent() {
        return Float3.maxAbs(Float3.maxAbs(this.x, this.y), this.z);
    }

    public Float3 min(double d) {
        return new Float3(Math.min(this.x, d), Math.min(this.y, d), Math.min(this.z, d));
    }

    public double min() {
        return Math.min(Math.min(this.x, this.y), this.z);
    }

    public Float3 sub(Float3 p) {
        return new Float3(this.x - p.x, this.y - p.y, this.z - p.z);
    }

    public Float3 sub(class_243 p) {
        return new Float3(this.x - p.field_1352, this.y - p.field_1351, this.z - p.field_1350);
    }

    public Float3 mul(double d) {
        return new Float3(this.x * d, this.y * d, this.z * d);
    }

    public Float3 div(double d) {
        return new Float3(this.x / d, this.y / d, this.z / d);
    }

    public Float3 reciprocal() {
        return new Float3(1.0 / this.x, 1.0 / this.y, 1.0 / this.z);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double lengthSquare() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Float3 project(Float3 unitDirection) {
        return unitDirection.mul(this.dot(unitDirection));
    }

    public Float3 normalized() {
        double d = this.length();
        return new Float3(this.x / d, this.y / d, this.z / d);
    }

    public Float4 asDirection() {
        return Float4.ofDirection(this);
    }

    public Float4 asPoint() {
        return Float4.ofPoint(this);
    }

    public class_238 toAABB() {
        return new class_238(this.x, this.y, this.z, this.x + 1.0, this.y + 1.0, this.z + 1.0);
    }

    public class_238 toAABB(class_243 offset) {
        return new class_238(this.x + offset.field_1352, this.y + offset.field_1351, this.z + offset.field_1350, this.x + 1.0 + offset.field_1352, this.y + 1.0 + offset.field_1351, this.z + 1.0 + offset.field_1350);
    }

    public class_2338 toBlockPos() {
        return Float3.toBlockPos(this.x, this.y, this.z);
    }

    public Float3 ceil() {
        return Float3.of(Math.ceil(this.x), Math.ceil(this.y), Math.ceil(this.z));
    }

    public Float3 floor() {
        return Float3.of(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    public Float3 round() {
        return Float3.of(Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    public Float3 conservative() {
        return Float3.of(Float3.conservative(this.x), Float3.conservative(this.y), Float3.conservative(this.z));
    }

    public class_243 toVec3() {
        return new class_243(this.x, this.y, this.z);
    }

    public Vector3f toVector3() {
        return new Vector3f((float)this.x, (float)this.y, (float)this.z);
    }

    public double distSquare(Float3 b) {
        return Math.pow(this.x - b.x, 2.0) + Math.pow(this.y - b.y, 2.0) + Math.pow(this.z - b.z, 2.0);
    }

    public double distSquare(class_2338 b) {
        return Math.pow(this.x - (double)b.method_10263(), 2.0) + Math.pow(this.y - (double)b.method_10264(), 2.0) + Math.pow(this.z - (double)b.method_10260(), 2.0);
    }

    public Float3 rotate(Quaternion rot) {
        return rot.rotate(this);
    }

    public Float3 unRotate(Quaternion rot) {
        return rot.unRotate(this);
    }

    public Float3 rotateX(double a) {
        return Float3.of(this.x * Math.cos(a) - this.y * Math.sin(a), this.x * Math.sin(a) + this.y * Math.cos(a), this.z);
    }

    public Float3 rotateY(double a) {
        return Float3.of(this.x * Math.cos(a) + this.z * Math.sin(a), this.y, -this.x * Math.sin(a) + this.z * Math.cos(a));
    }

    public Float3 rotateZ(double a) {
        return Float3.of(this.x, this.y * Math.cos(a) - this.z * Math.sin(a), this.y * Math.sin(a) + this.z * Math.cos(a));
    }

    public static double conservative(double x) {
        return x < 0.0 ? Math.floor(x) : Math.ceil(x);
    }

    public static double maxAbs(double a, double b) {
        return Math.abs(a) > Math.abs(b) ? a : b;
    }

    public static int toBlockPos(double d) {
        return (int)d;
    }

    public static double toAlignedPos(double d) {
        return (double)((int)Math.round(d + 0.5)) - 0.5;
    }

    public static class_2338 toBlockPos(class_243 vec) {
        return Float3.toBlockPos(vec.field_1352, vec.field_1351, vec.field_1350);
    }

    public static class_2338 toBlockPos(double x, double y, double z) {
        return new class_2338(Float3.toBlockPos(x), Float3.toBlockPos(y), Float3.toBlockPos(z));
    }

    public String toString() {
        return "(" + Float3.toString(this.x) + ", " + Float3.toString(this.y) + ", " + Float3.toString(this.z) + ")";
    }

    public static String toString(double d) {
        return "" + (double)Math.round(d * 100.0) / 100.0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Float3 pos = (Float3)o;
        return Math.abs(pos.x - this.x) < 1.0E-10 && Math.abs(pos.y - this.y) < 1.0E-10 && Math.abs(pos.z - this.z) < 1.0E-10;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public void serializeToNetwork(class_2540 buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
    }

    public static Float3 deserializeFromNetwork(class_2540 buf) {
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        return Float3.of(x, y, z);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public Float2 xx() {
        return new Float2(this.x, this.x);
    }

    public Float2 xy() {
        return new Float2(this.x, this.y);
    }

    public Float2 xz() {
        return new Float2(this.x, this.z);
    }

    public Float2 yx() {
        return new Float2(this.y, this.x);
    }

    public Float2 yy() {
        return new Float2(this.y, this.y);
    }

    public Float2 yz() {
        return new Float2(this.y, this.z);
    }

    public Float2 zx() {
        return new Float2(this.z, this.x);
    }

    public Float2 zy() {
        return new Float2(this.z, this.y);
    }

    public Float2 zz() {
        return new Float2(this.z, this.z);
    }

    public Float3 xxx() {
        return new Float3(this.x, this.x, this.x);
    }

    public Float3 xxy() {
        return new Float3(this.x, this.x, this.y);
    }

    public Float3 xxz() {
        return new Float3(this.x, this.x, this.z);
    }

    public Float3 xyx() {
        return new Float3(this.x, this.y, this.x);
    }

    public Float3 xyy() {
        return new Float3(this.x, this.y, this.y);
    }

    public Float3 xyz() {
        return new Float3(this.x, this.y, this.z);
    }

    public Float3 xzx() {
        return new Float3(this.x, this.z, this.x);
    }

    public Float3 xzy() {
        return new Float3(this.x, this.z, this.y);
    }

    public Float3 xzz() {
        return new Float3(this.x, this.z, this.z);
    }

    public Float3 yxx() {
        return new Float3(this.y, this.x, this.x);
    }

    public Float3 yxy() {
        return new Float3(this.y, this.x, this.y);
    }

    public Float3 yxz() {
        return new Float3(this.y, this.x, this.z);
    }

    public Float3 yyx() {
        return new Float3(this.y, this.y, this.x);
    }

    public Float3 yyy() {
        return new Float3(this.y, this.y, this.y);
    }

    public Float3 yyz() {
        return new Float3(this.y, this.y, this.z);
    }

    public Float3 yzx() {
        return new Float3(this.y, this.z, this.x);
    }

    public Float3 yzy() {
        return new Float3(this.y, this.z, this.y);
    }

    public Float3 yzz() {
        return new Float3(this.y, this.z, this.z);
    }

    public Float3 zxx() {
        return new Float3(this.z, this.x, this.x);
    }

    public Float3 zxy() {
        return new Float3(this.z, this.x, this.y);
    }

    public Float3 zxz() {
        return new Float3(this.z, this.x, this.z);
    }

    public Float3 zyx() {
        return new Float3(this.z, this.y, this.x);
    }

    public Float3 zyy() {
        return new Float3(this.z, this.y, this.y);
    }

    public Float3 zyz() {
        return new Float3(this.z, this.y, this.z);
    }

    public Float3 zzx() {
        return new Float3(this.z, this.z, this.x);
    }

    public Float3 zzy() {
        return new Float3(this.z, this.z, this.y);
    }

    public Float3 zzz() {
        return new Float3(this.z, this.z, this.z);
    }
}

