/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.ambertation.wunderlib.WunderLib;
import de.ambertation.wunderlib.utils.Version;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigFile {
    public static final String MODIFY_VERSION = "modify_version";
    public static final String CREATE_VERSION = "create_version";
    private static final Gson JSON_BUILDER = new GsonBuilder().setPrettyPrinting().create();
    public final String category;
    private final File path;
    private final List<Value<?, ?>> knownValues = new LinkedList();
    private JsonObject root;
    private boolean modified;
    private final Version.ModVersionProvider versionProvider;

    public ConfigFile(Version.ModVersionProvider versionProvider, String category) {
        this(versionProvider, versionProvider.getModID(), category);
    }

    public ConfigFile(Version.ModVersionProvider versionProvider, String basePath, String category) {
        Path dir = FabricLoader.getInstance().getConfigDir().resolve(basePath);
        this.path = dir.resolve(category + ".json").toFile();
        this.category = basePath + "." + category;
        this.versionProvider = versionProvider;
        if (!dir.toFile().exists()) {
            dir.toFile().mkdirs();
        }
        this.loadFromDisc();
    }

    private void setModified() {
        this.modified = true;
    }

    public int getMaxOrder() {
        int highestOrder = 0;
        for (Value<?, ?> v : this.knownValues) {
            if (v.order <= highestOrder) continue;
            highestOrder = v.order;
        }
        return highestOrder;
    }

    private void registerValue(Value<?, ?> v) {
        this.knownValues.remove(v);
        this.knownValues.add(v);
        v.order = this.getMaxOrder() + 1;
        v.parentFile = this;
    }

    private JsonElement getValue(ConfigToken t, boolean addIfMissing) {
        JsonObject obj = this.getPathElement(t.path, addIfMissing);
        if (!obj.has(t.key)) {
            return null;
        }
        return obj.get(t.key);
    }

    private void setValue(ConfigToken t, JsonElement value) {
        if (!value.equals(this.getValue(t, true))) {
            this.setModified();
        }
        JsonObject obj = this.getPathElement(t.path, true);
        obj.add(t.key, value);
    }

    private void removeValue(ConfigToken t) {
        JsonObject o = this.getPathElement(t.path, false);
        if (o.has(t.key)) {
            WunderLib.LOGGER.info("Removing Config " + t.path + "." + t.key);
            o.remove(t.key);
            this.setModified();
        }
    }

    private JsonObject getPathElement(String path, boolean addIfMissing) {
        if (path == null || path.trim().equals("")) {
            return this.root;
        }
        String[] names = path.split("\\.");
        JsonObject obj = this.root;
        for (int i = 0; i < names.length; ++i) {
            String p = names[i];
            if (obj.has(p)) {
                obj = obj.get(p).getAsJsonObject();
                continue;
            }
            JsonObject newObject = new JsonObject();
            if (addIfMissing) {
                obj.add(p, (JsonElement)newObject);
            }
            obj = newObject;
        }
        return obj;
    }

    public void loadFromDisc() {
        this.modified = false;
        if (this.path.exists()) {
            try (FileReader reader = new FileReader(this.path);){
                this.root = ((JsonElement)JSON_BUILDER.fromJson((Reader)reader, JsonElement.class)).getAsJsonObject();
            }
            catch (Exception ex) {
                WunderLib.LOGGER.error("Unable to open Config File at '{}'.", this.path.toString(), ex);
            }
        } else {
            this.root = new JsonObject();
            this.root.add(CREATE_VERSION, (JsonElement)new JsonPrimitive(this.versionProvider.getModVersion().toString()));
        }
    }

    public void save() {
        this.save(false);
    }

    public void save(boolean force) {
        if (!this.modified && !force) {
            return;
        }
        try (FileWriter jsonWriter = new FileWriter(this.path);){
            this.root.add(MODIFY_VERSION, (JsonElement)new JsonPrimitive(this.versionProvider.getModVersion().toString()));
            String string = JSON_BUILDER.toJson((JsonElement)this.root);
            jsonWriter.write(string);
            jsonWriter.flush();
            this.modified = false;
        }
        catch (IOException ex) {
            WunderLib.LOGGER.error("Unable to store Config File at '{}'.", this.path.toString(), ex);
        }
    }

    private String getVersionString(String name) {
        JsonObject mod = this.getPathElement("", true);
        if (mod == null) {
            return "1.0.0";
        }
        JsonPrimitive p = mod.getAsJsonPrimitive(name);
        if (p == null) {
            return this.versionProvider.getModVersion().toString();
        }
        if (!p.isString()) {
            return "1.0.0";
        }
        return p.getAsString();
    }

    public Version lastModifiedVersion() {
        return new Version(this.getVersionString(MODIFY_VERSION));
    }

    public Version createdVersion() {
        return new Version(this.getVersionString(CREATE_VERSION));
    }

    @Environment(value=EnvType.CLIENT)
    public List<Value<?, ?>> getAllValues() {
        return this.knownValues;
    }

    @Environment(value=EnvType.CLIENT)
    public List<Value<?, ?>> getAllVisibleValues() {
        ArrayList values = new ArrayList();
        for (Value<?, ?> v : this.knownValues) {
            if (v.hiddenInUI) continue;
            values.add(v);
        }
        return values;
    }

    @Environment(value=EnvType.CLIENT)
    public List<Value<?, ?>> getAllVisibleValues(Group group) {
        ArrayList values = new ArrayList();
        for (Value<?, ?> v : this.knownValues) {
            if (v.hiddenInUI || v.group != group) continue;
            values.add(v);
        }
        values.sort(Comparator.comparingInt(o -> o.order));
        return values;
    }

    @Environment(value=EnvType.CLIENT)
    public static List<Value<?, ?>> getAllVisibleValues(Group group, List<ConfigFile> configFiles) {
        ArrayList values = new ArrayList();
        for (ConfigFile c : configFiles) {
            for (Value<?, ?> v : c.knownValues) {
                if (v.hiddenInUI || v.group != group) continue;
                values.add(v);
            }
        }
        values.sort(Comparator.comparingInt(o -> o.order));
        return values;
    }

    @Environment(value=EnvType.CLIENT)
    public List<Group> getAllGroups() {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Value<?, ?> v : this.knownValues) {
            if (v.group == null || groups.contains(v.group)) continue;
            groups.add(v.group);
        }
        groups.sort(Comparator.comparingInt(o -> o.order));
        return groups;
    }

    @Environment(value=EnvType.CLIENT)
    public static List<Group> getAllGroups(List<ConfigFile> configFiles) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (ConfigFile c : configFiles) {
            for (Value<?, ?> v : c.knownValues) {
                if (v.group == null || groups.contains(v.group)) continue;
                groups.add(v.group);
            }
        }
        groups.sort(Comparator.comparingInt(o -> o.order));
        return groups;
    }

    @Environment(value=EnvType.CLIENT)
    public static String getAllCategories(List<ConfigFile> configFiles) {
        StringBuilder sb = new StringBuilder();
        for (ConfigFile c : configFiles) {
            if (!sb.isEmpty()) {
                sb.append(",");
            }
            sb.append(c.category);
        }
        return sb.toString();
    }

    public abstract class Value<T, R extends Value<T, R>> {
        @NotNull
        public final ConfigToken<T> token;
        @Nullable
        protected Supplier<Boolean> isValidSupplier;
        private boolean hiddenInUI = false;
        @Nullable
        private BooleanValue enabledInUI = null;
        private boolean deprecated = false;
        @Nullable
        private Group group;
        private int order;
        @Nullable
        private ConfigFile parentFile;

        public Value(String path, String key, T defaultValue) {
            this(new ConfigToken<T>(path, key, defaultValue), false);
        }

        public Value(String path, String key, T defaultValue, boolean isDeprecated) {
            this(new ConfigToken<T>(path, key, defaultValue), isDeprecated);
        }

        public Value(ConfigToken token) {
            this(token, false);
        }

        public Value(ConfigToken token, boolean isDeprecated) {
            this.deprecated = isDeprecated;
            this.token = token;
            this.group = null;
            this.get();
            ConfigFile.this.registerValue(this);
        }

        public R hideInUI() {
            this.hiddenInUI = true;
            return (R)this;
        }

        public R setGroup(Group group) {
            this.group = group;
            return (R)this;
        }

        public R setOrder(int order) {
            this.order = order;
            return (R)this;
        }

        public R setDependency(BooleanValue value) {
            this.enabledInUI = value;
            return (R)this;
        }

        public boolean isHiddenInUI() {
            return this.hiddenInUI;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        @Nullable
        public Group getGroup() {
            return this.group;
        }

        public int getOrder() {
            return this.order;
        }

        @Nullable
        public ConfigFile getParentFile() {
            return this.parentFile;
        }

        public boolean hasDependency() {
            return this.enabledInUI != null;
        }

        @Nullable
        public BooleanValue getDependency() {
            return this.enabledInUI;
        }

        @Nullable
        public Supplier<Boolean> getIsValidSupplier() {
            return this.isValidSupplier;
        }

        public final T getRaw() {
            JsonElement el = ConfigFile.this.getValue(this.token, !this.deprecated);
            if (el == null) {
                if (!this.deprecated) {
                    this.set(this.token.defaultValue);
                }
                return this.token.defaultValue;
            }
            return this.convert(el);
        }

        public T get() {
            return this.getRaw();
        }

        public void remove() {
            ConfigFile.this.removeValue(this.token);
        }

        public void migrate(Value<T, R> newConfig) {
            newConfig.set(this.get());
            this.remove();
        }

        protected abstract T convert(@NotNull JsonElement var1);

        @NotNull
        protected abstract JsonElement convert(T var1);

        public void set(T value) {
            if (this.deprecated) {
                throw new IllegalStateException("'" + this.token.path() + "." + this.token.key + "' is deprecated and can no-longer be used");
            }
            ConfigFile.this.setValue(this.token, this.convert(value));
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{token=" + this.token + ", value='" + this.get() + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Value)) {
                return false;
            }
            Value value = (Value)o;
            return this.token.equals(value.token);
        }

        public int hashCode() {
            return Objects.hash(this.token);
        }
    }

    public record ConfigToken<T>(String path, String key, T defaultValue) {
        @Override
        public String toString() {
            return "ConfigToken{path='" + this.path + "', key='" + this.key + "', defaultValue=" + this.defaultValue + "}";
        }
    }

    public record Group(@NotNull String modID, @NotNull String title, int order) {
        @Override
        public String toString() {
            return "Group{title='" + this.title + "', order=" + this.order + "}";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Group group = (Group)o;
            return this.title.equals(group.title);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.title);
        }
    }

    public class BooleanValue
    extends Value<Boolean, BooleanValue> {
        public BooleanValue(String path, String key, boolean defaultValue) {
            super(path, key, defaultValue);
        }

        protected BooleanValue(ConfigToken t) {
            super(t);
        }

        public BooleanValue(String path, String key, boolean defaultValue, boolean isDeprecated) {
            super(path, key, defaultValue, isDeprecated);
        }

        protected BooleanValue(ConfigToken t, boolean isDeprecated) {
            super(t, isDeprecated);
        }

        @Override
        protected Boolean convert(@NotNull JsonElement el) {
            return el.getAsBoolean();
        }

        @Override
        @NotNull
        protected JsonElement convert(Boolean value) {
            return new JsonPrimitive(value);
        }

        public BooleanValue and(BooleanValue ... condition) {
            BooleanValue res = this.and(() -> Arrays.stream(condition).map(c -> (Boolean)c.get()).reduce(true, (p, c) -> p != false && c != false));
            if (condition.length == 1) {
                res.setDependency(condition[0]);
            }
            return res;
        }

        public BooleanValue and(final Supplier<Boolean> condition) {
            final BooleanValue self = this;
            BooleanValue res = new BooleanValue(this.token, this.isDeprecated()){

                @Override
                public Boolean get() {
                    return (Boolean)condition.get() != false && (Boolean)self.get() != false;
                }

                @Override
                public void set(Boolean value) {
                    self.set(value);
                }
            };
            res.isValidSupplier = condition;
            return res;
        }

        public BooleanValue or(BooleanValue ... condition) {
            return this.or(() -> Arrays.stream(condition).map(c -> (Boolean)c.get()).reduce(true, (p, c) -> p != false || c != false));
        }

        public BooleanValue or(final Supplier<Boolean> condition) {
            final BooleanValue self = this;
            BooleanValue res = new BooleanValue(this.token, this.isDeprecated()){

                @Override
                public Boolean get() {
                    return (Boolean)condition.get() != false || (Boolean)self.get() != false;
                }

                @Override
                public void set(Boolean value) {
                    self.set(value);
                }
            };
            res.isValidSupplier = condition;
            return res;
        }

        @Override
        public BooleanValue hideInUI() {
            return (BooleanValue)super.hideInUI();
        }
    }

    public class FloatValue
    extends Value<Float, FloatValue> {
        public FloatValue(String path, String key, float defaultValue) {
            super(path, key, Float.valueOf(defaultValue));
        }

        protected FloatValue(ConfigToken t) {
            super(t);
        }

        public FloatValue(String path, String key, float defaultValue, boolean isDeprecated) {
            super(path, key, Float.valueOf(defaultValue), isDeprecated);
        }

        protected FloatValue(ConfigToken t, boolean isDeprecated) {
            super(t, isDeprecated);
        }

        @Override
        protected Float convert(@NotNull JsonElement el) {
            return Float.valueOf(el.getAsFloat());
        }

        @Override
        @NotNull
        protected JsonElement convert(Float value) {
            return new JsonPrimitive((Number)value);
        }

        @Override
        public FloatValue hideInUI() {
            return (FloatValue)super.hideInUI();
        }
    }

    public class IntValue
    extends Value<Integer, IntValue> {
        public IntValue(String path, String key, int defaultValue) {
            super(path, key, defaultValue);
        }

        protected IntValue(ConfigToken t) {
            super(t);
        }

        public IntValue(String path, String key, int defaultValue, boolean isDeprecated) {
            super(path, key, defaultValue, isDeprecated);
        }

        protected IntValue(ConfigToken t, boolean isDeprecated) {
            super(t, isDeprecated);
        }

        @Override
        protected Integer convert(@NotNull JsonElement el) {
            return el.getAsInt();
        }

        @Override
        @NotNull
        protected JsonElement convert(Integer value) {
            return new JsonPrimitive((Number)value);
        }

        @Override
        public IntValue hideInUI() {
            return (IntValue)super.hideInUI();
        }
    }
}

