/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.ritchiesprojectilelib.network;

import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import rbasamoyai.ritchiesprojectilelib.network.ClientboundCheckChannelVersionPacket;
import rbasamoyai.ritchiesprojectilelib.network.ClientboundPreciseMotionSyncPacket;
import rbasamoyai.ritchiesprojectilelib.network.RootPacket;
import rbasamoyai.ritchiesprojectilelib.network.fabric.RPLNetworkImpl;

public class RPLNetwork {
    private static final Int2ObjectMap<Function<class_2540, ? extends RootPacket>> ID_TO_CONSTRUCTOR = new Int2ObjectOpenHashMap();
    private static final Object2IntMap<Class<? extends RootPacket>> TYPE_TO_ID = new Object2IntOpenHashMap();
    public static final String VERSION = "1.0.0";

    public static void init() {
        int id = 0;
        RPLNetwork.addMsg(id++, ClientboundCheckChannelVersionPacket.class, ClientboundCheckChannelVersionPacket::new);
        RPLNetwork.addMsg(id++, ClientboundPreciseMotionSyncPacket.class, ClientboundPreciseMotionSyncPacket::new);
        RPLNetwork.sidedInit();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sidedInit() {
        RPLNetworkImpl.sidedInit();
    }

    private static <T extends RootPacket> void addMsg(int id, Class<T> clazz, Function<class_2540, T> decoder) {
        TYPE_TO_ID.put(clazz, id);
        ID_TO_CONSTRUCTOR.put(id, decoder);
    }

    public static RootPacket constructPacket(class_2540 buf, int id) {
        if (!ID_TO_CONSTRUCTOR.containsKey(id)) {
            throw new IllegalStateException("Attempted to deserialize packet with illegal id: " + id);
        }
        return (RootPacket)((Function)ID_TO_CONSTRUCTOR.get(id)).apply(buf);
    }

    public static void writeToBuf(RootPacket pkt, class_2540 buf) {
        int id = TYPE_TO_ID.getOrDefault(pkt.getClass(), -1);
        if (id == -1) {
            throw new IllegalStateException("Attempted to serialize packet with illegal id: " + id);
        }
        buf.method_10804(id);
        pkt.rootEncode(buf);
    }

    public static void onPlayerJoin(class_3222 player) {
        RPLNetwork.sendToClientPlayer(new ClientboundCheckChannelVersionPacket(VERSION), player);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sendToServer(RootPacket pkt) {
        RPLNetworkImpl.sendToServer(pkt);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sendToClientPlayer(RootPacket pkt, class_3222 player) {
        void var1_1;
        RPLNetworkImpl.sendToClientPlayer(pkt, (class_3222)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sendToClientTracking(RootPacket pkt, class_1297 tracked) {
        void var1_1;
        RPLNetworkImpl.sendToClientTracking(pkt, (class_1297)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sendToClientAll(RootPacket pkt, MinecraftServer server) {
        void var1_1;
        RPLNetworkImpl.sendToClientAll(pkt, (MinecraftServer)var1_1);
    }
}

