/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.ritchiesprojectilelib.config;

import java.util.function.BiConsumer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class RPLConfigs {
    private static final ForgeConfigSpec serverSpec;
    private static final Server SERVER;

    public static Server server() {
        return SERVER;
    }

    public static void registerConfigs(BiConsumer<ModConfig.Type, ForgeConfigSpec> cons) {
        cons.accept(ModConfig.Type.SERVER, serverSpec);
    }

    public static void onModConfigLoad(ModConfig modConfig) {
    }

    public static void onModConfigReload(ModConfig modConfig) {
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.IntValue maxChunksForceLoaded;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Server configuration settings for Ritchie's Projectile Library").push("server");
            this.maxChunksForceLoaded = builder.comment("The maximum amount of chunks forced to load during a single tick. Set to -1 to force load unlimited chunks.").translation("ritchiesprojectilelib.configgui.maxChunksForceLoaded").worldRestart().defineInRange("maxChunksForceLoaded", 64, -1, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

