/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.ritchiesprojectilelib.chunkloading;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2839;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import rbasamoyai.ritchiesprojectilelib.config.RPLConfigs;

public class ChunkManager
extends class_18 {
    private final SetMultimap<UUID, Long> chunks;
    private final LinkedList<Long> iterated = new LinkedList();
    private final Set<Long> currentlyLoaded = new HashSet<Long>();

    public ChunkManager() {
        this((SetMultimap<UUID, Long>)HashMultimap.create());
    }

    private ChunkManager(SetMultimap<UUID, Long> map) {
        this.chunks = map;
        this.iterated.addAll(this.chunks.values());
    }

    public static ChunkManager load(class_2487 tag) {
        HashMultimap chunks = HashMultimap.create();
        class_2499 loadedList = tag.method_10554("LoadedChunks", 10);
        for (int i = 0; i < loadedList.size(); ++i) {
            class_2487 eTag = loadedList.method_10602(i);
            chunks.put((Object)eTag.method_25926("UUID"), (Object)eTag.method_10537("ChunkPos"));
        }
        return new ChunkManager((SetMultimap<UUID, Long>)chunks);
    }

    public class_2487 method_75(class_2487 compoundTag) {
        class_2499 loadedList = new class_2499();
        for (Map.Entry e : this.chunks.entries()) {
            class_2487 eTag = new class_2487();
            eTag.method_25927("UUID", (UUID)e.getKey());
            eTag.method_10544("ChunkPos", ((Long)e.getValue()).longValue());
            loadedList.add((Object)eTag);
        }
        compoundTag.method_10566("LoadedChunks", (class_2520)loadedList);
        return compoundTag;
    }

    public void trackForcedChunk(class_3218 level, class_1297 entity, class_1923 pos, boolean loaded) {
        long l = pos.method_8324();
        UUID uuid = entity.method_5667();
        if (loaded && !entity.method_31481() && !this.chunks.containsEntry((Object)uuid, (Object)l)) {
            if (!this.chunks.containsValue((Object)l)) {
                this.iterated.add(l);
            }
            this.chunks.put((Object)uuid, (Object)l);
            this.method_80();
        } else if (!loaded && this.chunks.containsEntry((Object)uuid, (Object)l)) {
            this.chunks.remove((Object)uuid, (Object)l);
            this.expireChunkIfNecessary(level, pos);
            this.method_80();
        }
    }

    public void clearEntity(class_1297 entity) {
        this.chunks.removeAll((Object)entity.method_5667());
        this.method_80();
    }

    public void expireChunkIfNecessary(class_3218 level, class_1923 cpos) {
        long l = cpos.method_8324();
        if (!this.currentlyLoaded.contains(l) || level.method_17984().contains(l)) {
            return;
        }
        if (!this.chunks.containsValue((Object)l) || this.iterated.size() > this.currentlyLoaded.size() && this.currentlyLoaded.size() >= (Integer)RPLConfigs.server().maxChunksForceLoaded.get()) {
            this.currentlyLoaded.remove(l);
            level.method_14178().method_12124(cpos, false);
        }
    }

    public void tick(class_3218 level) {
        long l;
        LongSet vanillaForcedChunks = level.method_17984();
        HashSet<Long> badChunks = new HashSet<Long>();
        int MAX_SIZE = (Integer)RPLConfigs.server().maxChunksForceLoaded.get();
        int MAX_ITER = 64;
        if (MAX_SIZE != 0) {
            int p = 0;
            int q = 0;
            LinkedList<Long> tempBuf = new LinkedList<Long>();
            while (!(MAX_SIZE != -1 && p >= MAX_SIZE || this.iterated.isEmpty() || MAX_SIZE != -1 && this.currentlyLoaded.size() >= MAX_SIZE || q++ >= MAX_ITER)) {
                l = this.iterated.poll();
                if (!this.chunks.containsValue((Object)l)) continue;
                if (!vanillaForcedChunks.contains(l) && !this.currentlyLoaded.contains(l)) {
                    if (!ChunkManager.loadChunkNoGenerate(level, new class_1923(l))) {
                        badChunks.add(l);
                        continue;
                    }
                    this.currentlyLoaded.add(l);
                }
                tempBuf.add(l);
                ++p;
            }
            this.iterated.addAll(tempBuf);
        }
        for (UUID uuid : this.chunks.keySet()) {
            Iterator iterator = badChunks.iterator();
            while (iterator.hasNext()) {
                l = (Long)iterator.next();
                this.chunks.remove((Object)uuid, (Object)l);
            }
        }
        this.method_80();
    }

    private static boolean loadChunkNoGenerate(class_3218 level, class_1923 cpos) {
        class_3215 source = level.method_14178();
        class_2791 access = source.method_12121(cpos.field_9181, cpos.field_9180, class_2806.field_12798, true);
        if (access instanceof class_2839) {
            source.method_17300(class_3230.field_14032, cpos, -11, (Object)cpos);
            access = source.method_12121(cpos.field_9181, cpos.field_9180, class_2806.field_12803, true);
        }
        if (access instanceof class_2818) {
            source.method_12124(cpos, true);
            return true;
        }
        return false;
    }
}

