/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.util;

import com.google.common.math.LongMath;
import io.github.fabricators_of_create.porting_lib.core.PortingLib;
import io.github.fabricators_of_create.porting_lib.util.FluidUnit;
import java.text.NumberFormat;
import java.util.Locale;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_3902;
import net.minecraft.class_4080;

public class FluidTextUtil {
    public static final Format NUMBER_FORMAT = new Format();
    private static final char[] SUPERSCRIPT = new char[]{'\u2070', '\u00b9', '\u00b2', '\u00b3', '\u2074', '\u2075', '\u2076', '\u2077', '\u2078', '\u2079'};
    private static final char FRACTION_BAR = '\u2044';
    private static final char[] SUBSCRIPT = new char[]{'\u2080', '\u2081', '\u2082', '\u2083', '\u2084', '\u2085', '\u2086', '\u2087', '\u2088', '\u2089'};

    static String format(double d) {
        return NUMBER_FORMAT.get().format(d).replace("\u00a0", " ");
    }

    public static String getUnicodeFraction(long numerator, long denominator, boolean simplify) {
        if (numerator < 0L || denominator < 0L) {
            throw new IllegalArgumentException("Numerator and denominator must be non negative.");
        }
        if (simplify && denominator != 0L) {
            long g = LongMath.gcd((long)numerator, (long)denominator);
            numerator /= g;
            denominator /= g;
        }
        StringBuilder numString = new StringBuilder();
        while (numerator > 0L) {
            numString.append(SUPERSCRIPT[(int)(numerator % 10L)]);
            numerator /= 10L;
        }
        StringBuilder denomString = new StringBuilder();
        while (denominator > 0L) {
            denomString.append(SUBSCRIPT[(int)(denominator % 10L)]);
            denominator /= 10L;
        }
        return numString.reverse().toString() + "\u2044" + denomString.reverse().toString();
    }

    public static String getUnicodeMillibuckets(long droplets, FluidUnit unit, boolean simplify) {
        if (unit == FluidUnit.DROPLETS) {
            return FluidTextUtil.format(droplets);
        }
        Object result = FluidTextUtil.format(droplets / (long)unit.getOneBucketAmount());
        if (droplets % 81L != 0L && !simplify) {
            result = (String)result + " " + FluidTextUtil.getUnicodeFraction(droplets % (long)unit.getOneBucketAmount(), unit.getOneBucketAmount(), true);
        }
        return result;
    }

    public static class Format
    extends class_4080<class_3902>
    implements IdentifiableResourceReloadListener {
        public static final class_2960 ID = PortingLib.id((String)"format_reload_listener");
        private NumberFormat format = NumberFormat.getNumberInstance(Locale.ROOT);

        private Format() {
        }

        public NumberFormat get() {
            return this.format;
        }

        public void update() {
            this.format = NumberFormat.getInstance();
            this.format.setMaximumFractionDigits(2);
            this.format.setMinimumFractionDigits(0);
            this.format.setGroupingUsed(true);
        }

        protected class_3902 prepare(class_3300 resourceManager, class_3695 profiler) {
            return class_3902.field_17274;
        }

        protected void apply(class_3902 object, class_3300 resourceManager, class_3695 profiler) {
            this.update();
        }

        public class_2960 getFabricId() {
            return ID;
        }
    }
}

