/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.tool;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ToolAction {
    private static final Map<String, ToolAction> actions = new ConcurrentHashMap<String, ToolAction>();
    private final String name;

    private ToolAction(String name) {
        this.name = name;
    }

    public static Collection<ToolAction> getActions() {
        return Collections.unmodifiableCollection(actions.values());
    }

    public static ToolAction get(String name) {
        return actions.computeIfAbsent(name, ToolAction::new);
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return "ToolAction[" + this.name + "]";
    }
}

