/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.registries;

import com.mojang.serialization.Codec;
import io.github.fabricators_of_create.porting_lib.registries.DynamicRegistryHandler;
import io.github.fabricators_of_create.porting_lib.registries.mixin.NetworkedRegistryDataAccessor;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_7655;
import org.jetbrains.annotations.Nullable;

public interface RegistryEvents {
    public static final Event<NewDataPackRegistryCallback> NEW_DATAPACK_REGISTRY = EventFactory.createArrayBacked(NewDataPackRegistryCallback.class, callbacks -> registry -> {
        for (NewDataPackRegistryCallback e : callbacks) {
            e.onRegisterNewDataPackRegistry(registry);
        }
    });

    public static interface NewDataPackRegistryCallback {
        public void onRegisterNewDataPackRegistry(NewDatapackRegistry var1);
    }

    public static class NewDatapackRegistry {
        public <T> void register(class_7655.class_7657<T> registryData) {
            this.register(registryData, null);
        }

        public <T> void register(class_7655.class_7657<T> registryData, @Nullable Codec<T> networkCodec) {
            DynamicRegistryHandler.REGISTRIES.add(new RegistryDataWithNetworkCodec<T>(registryData, networkCodec));
            if (networkCodec != null) {
                DynamicRegistryHandler.NETWORKABLE_REGISTRIES.put(registryData.comp_985(), NetworkedRegistryDataAccessor.createNetworkedRegistryData(registryData.comp_985(), networkCodec));
            }
        }
    }

    public record RegistryDataWithNetworkCodec<T>(class_7655.class_7657<T> registryData, @Nullable Codec<T> networkCodec) {
    }
}

